<?php

namespace Modules\Team\Models;

use CodeIgniter\Model;

class TeamModel extends Model
{

  protected $table = 'team';
    protected $primaryKey = 'id';

    protected $allowedFields = ['title', 'alias', 'photo', 'position', 'category_id', 'content', 'ordering', 'excerpt', 'birthday', 'died_at', 'achievements', 'relationship_status', 'status', 'hits', 'urls', 'metadesc', 'metakey', 'facebook', 'twitter', 'instagram', 'tiktok', 'linkedin', 'snapchat',  'created_by', 'updated_at', 'updated_by'];

    protected $useTimestamps  = true;
    protected $useSoftDeletes = true;
    
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';
    protected $deletedField  = 'deleted_at';

    //Get all Menus
    public function getAll()
    {
      $builder = $this->db->table('team as t');
      $builder->select('t.*, tc.name as category_name');
      $builder->join('team_category as tc', 'tc.id=t.category_id');
      $builder->where('t.deleted_at', null);
      $builder->orderBy('t.id', 'DESC');
	    $result = $builder->get()->getResult();
	    return $result;
    }

    //Get all Management Team
    public function showStaffMembers()
    {
      $builder = $this->db->table('team as t');
      $builder->select('t.*, tc.name as category_name,');
      $builder->join('team_category as tc', 'tc.id=t.category_id');
      $builder->where('t.deleted_at', null);
      $builder->where('category_id', 2);
      $builder->where('status', 'published');
      $builder->orderBy('ordering', 'ASC');
	  $result = $builder->get()->getResult();
	  return $result;
    }

    //Get all Board of Directors
    public function showBoardMembers()
    {
      $builder = $this->db->table('team as t');
      $builder->select('t.*, tc.name as category_name,');
      $builder->join('team_category as tc', 'tc.id=t.category_id');
      $builder->where('t.deleted_at', null);
      $builder->where('t.category_id', 3);
      $builder->where('t.status', 'published');
      $builder->orderBy('t.ordering', 'ASC');
	  $result = $builder->get()->getResult();
	  return $result;
    }

    public function getSingleMember($id)
    {
      $builder = $this->db->table('team as t');
      $builder->select('t.*, tc.name as category_name');
      $builder->join('team_category as tc', 'tc.id=t.category_id');
      $builder->where('t.id', $id);
      $builder->orWhere('t.alias', $id);
	    $result = $builder->get()->getRow();
	    return $result;
    }
   
    //Get Team Category Members
    public function getCategoryMembers($category)
    {
      $builder = $this->db->table('team as t');
      $builder->select('t.*, tc.name as category_name');
      $builder->join('team_category as tc', 'tc.id=t.category_id');
      $builder->where('t.deleted_at', null);
      $builder->where('t.category_id', $category);
      $builder->orWhere('tc.alias', $category);
      //$builder->orderBy('t.id', 'DESC');
	    $result = $builder->get()->getResult();
	    return $result;
    }

}
