<?php

namespace Modules\Team\Models;

use CodeIgniter\Model;

class TeamMemberGalleryModel extends Model
{

  protected $table = 'team_category';
    protected $primaryKey = 'id';

    protected $allowedFields = ['team_member_id', 'photo', 'caption', 'created_by', 'updated_at',];

    protected $returnType     = 'array';
    protected $useTimestamps  = true;
    protected $useSoftDeletes = true;
    
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';
    protected $deletedField  = 'deleted_at';

    //Get all Member Photos
    public function getAllMemberPhotos($member)
    {
      $builder = $this->db->table('team_category');
      $builder->where('team_member_id', $member);
	  $result = $builder->get()->getResult();
	  return $result;
    }


}
