<?php

namespace Modules\Menu\Config;

use Config;
// Create a new instance of our RouteCollection class.
$routes = Config\Services::routes();

// Load the system's routing file first, so that the app and ENVIRONMENT
// can override as needed.
if (is_file(SYSTEMPATH . 'Config/Routes.php')) {
    require SYSTEMPATH . 'Config/Routes.php';
}


//setting up Inventory routes.
$routes->group('administrator/team', ['filter' => 'isLoggedIn', 'filter' => 'checkPermission', 'namespace' => 'Modules\Team\Controllers'],   static function($routes){

    $routes->GET('members', 'Team::index');
    $routes->GET('member/add', 'Team::addMember');
    $routes->POST('member/add', 'Team::addMember');
    $routes->GET('member/view/(:any)', 'Team::viewMember/$1');
    $routes->GET('member/edit/(:any)', 'Team::editMember/$1');
    $routes->POST('member/update', 'Team::updateMember');
    $routes->GET('member/delete/(:any)', 'Team::deleteMember/$1');

    $routes->GET('categories', 'Team::categories');
    $routes->POST('categories/add', 'Team::addCategory');
    $routes->GET('categories/edit/(:any)', 'Team::editCategory/$1');
    $routes->POST('categories/update', 'Team::updateCategory');
    $routes->GET('categories/delete/(:any)', 'Team::delCategory/$1');

});
