<?= $this->extend('Modules\Admin\Views\index'); ?>
<?= $this->section('content');?>
<div class="container-fluid">
<div class="row mb-md-3">
    <div class="col">
        <h4>Edit Slide</h4>
        <!-- Breadcrumb !-->
        <nav aria-label="breadcrumb"><small>
            <ol class="breadcrumb mb-0">
                <li class="breadcrumb-item"><a href="<?= base_url('administrator') ?> ">Home</a></li>
                <li class="breadcrumb-item"><a href="<?= base_url('administrator/sliders/all') ?> ">All Slides</a></li>
                <li class="breadcrumb-item active" aria-current="page"><?= esc($bcrumb) ?> </li>
            </ol></small>
        </nav>
    </div>
</div>

<!-- Messages -->
<div class="row">
    <div class="col">
        <?php if(session()->getTempdata('success')): ?>
            <div class="alert alert-success" role="alert"><?= session()->getTempdata('success');?></div>
        <?php endif;?>
        <?php if(session()->getTempdata('error')): ?>
            <div class="alert alert-danger" role="alert"><?= session()->getTempdata('error');?></div>
        <?php endif;?>
        <?php if(isset($validation)): ?>
            <div class="alert alert-danger"><?= $validation->listErrors()?></div>
        <?php endif;?>
        <div id="showMsg"></div>
    </div>
</div>

<!-- Edit Slide Form -->
<form method="POST" action="<?= base_url('administrator/sliders/update')?>" enctype="multipart/form-data">
<?= csrf_field();?>
<input type="hidden" name="id" value="<?=$myslide['id'] ?>">
    <div class="card rounded-0 shadow-sm">
        <div class="card-header bg-light bg-opacity-100">
            <div class="d-flex bd-highlight align-items-center">
                <div class="p-1 bd-highlight align-items-center">
                    <div class="btn-group border shadow-sm">
                        <button type="button" class="btn bg-success rounded-0"><i class="bi bi-plus-lg text-white"></i></button>
                        <button type="submit" class="btn btn-sm btn-success align-items-center"> &nbsp; Update &nbsp;</button>
                    </div>
                </div>
                <div class="p-1 bd-highlight">
                    <div class="btn-group border shadow-sm">
                        <button type="button" class="btn bg-danger bg-opacity-25 rounded-0"><i class="bi bi-x-lg"></i></button>
                        <button type="reset" class="btn btn-sm btn-danger">Reset</button>
                    </div>
                </div>
                <div class="p-1 bd-highlight">
                    <div class="btn-group border shadow-sm">
                        <button type="button" class="btn bg-primary bg-opacity-25 rounded-0"><i class="bi bi-x-lg"></i></button>
                        <a href="<?= base_url('administrator/sliders/all') ?>" class="btn btn-sm btn-primary">Back to Slides</a>
                    </div>
                </div>
            </div>
        </div>
        <div class="card-body">
            <!-- Row 1: Basic Info and Links -->
            <div class="row mb-4">
                <!-- Basic Information Section -->
                <div class="col-md-6">
                    <div class="card h-100">
                        <div class="card-header bg-primary text-white">
                            <strong><i class="fas fa-info-circle"></i> Basic Information</strong>
                        </div>
                        <div class="card-body">
                            <div class="mb-3">
                                <label class="form-label"><strong>Title</strong></label>
                                <input type="text" name="title" value="<?=$myslide['title'] ?>" class="form-control" required>
                            </div>
                            <div class="mb-3">
                                <label class="form-label"><strong>Category</strong></label>
                                <select name="category_id" class="form-select" required>
                                    <option value="">Select Category</option>
                                    <?php foreach($categories as $cat): ?>
                                        <option value="<?= $cat->id;?>" <?php if($cat->id == $myslide['category_id']) echo "selected"; ?>><?= $cat->name;?></option>
                                    <?php endforeach;?>
                                </select>
                            </div>
                            <div class="mb-3">
                                <label class="form-label"><strong>Description</strong></label>
                                <textarea name="description" class="form-control" rows="3" placeholder="Write description text here.."><?=trim($myslide['description']) ?></textarea>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Links Section -->
                <div class="col-md-6">
                    <div class="card h-100">
                        <div class="card-header bg-info text-white">
                            <strong><i class="fas fa-link"></i> Links Configuration</strong>
                        </div>
                        <div class="card-body">
                            <!-- Primary Link -->
                            <div class="mb-4">
                                <label class="form-label"><strong>Primary Link</strong></label>
                                <div class="row g-2">
                                    <div class="col-md-4">
                                        <input type="text" name="link_text" value="<?=$myslide['link_text'] ?>" class="form-control" placeholder="Link Text">
                                    </div>
                                    <div class="col-md-4">
                                        <div class="position-relative">
                                            <input type="text" name="link" id="link" value="<?=$myslide['link'] ?>" class="form-control" placeholder="Link URL" autocomplete="off">
                                            <div id="linkSearchResults" class="list-group" style="z-index:1050; position: absolute; left: 0; right: 0; display: none;"></div>
                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <select name="link_icon" class="form-select">
                                            <option value="fas fa-info-circle" <?php if($myslide['link_icon'] == "fas fa-info-circle") echo "selected"; ?>>Info Circle</option>
                                            <option value="fas fa-user-plus" <?php if($myslide['link_icon'] == "fas fa-user-plus") echo "selected"; ?>>User Plus</option>
                                            <option value="fas fa-rocket" <?php if($myslide['link_icon'] == "fas fa-rocket") echo "selected"; ?>>Rocket</option>
                                            <option value="fas fa-bank" <?php if($myslide['link_icon'] == "fas fa-bank") echo "selected"; ?>>Bank</option>
                                            <option value="fas fa-credit-card" <?php if($myslide['link_icon'] == "fas fa-credit-card") echo "selected"; ?>>Credit Card</option>
                                            <option value="fas fa-money-bill" <?php if($myslide['link_icon'] == "fas fa-money-bill") echo "selected"; ?>>Money</option>
                                            <option value="fas fa-chart-line" <?php if($myslide['link_icon'] == "fas fa-chart-line") echo "selected"; ?>>Chart</option>
                                        </select>
                                    </div>
                                </div>
                                <input type="hidden" name="selected_link_id" id="selected_link_id" value="<?= isset($selected_link_id) ? $selected_link_id : '' ?>">
                                <input type="hidden" name="selected_link_type" id="selected_link_type" value="<?= isset($selected_link_meta['type']) ? $selected_link_meta['type'] : '' ?>">
                            </div>

                            <!-- Secondary Link -->
                            <div class="mb-3">
                                <label class="form-label"><strong>Secondary Link</strong></label>
                                <div class="row g-2">
                                    <div class="col-md-4">
                                        <input type="text" name="link_2_text" class="form-control" value="<?=$myslide['link_2_text'] ?>" placeholder="Link Text">
                                    </div>
                                    <div class="col-md-4">
                                        <input type="text" name="link_2" class="form-control" value="<?=$myslide['link_2'] ?>" placeholder="Link URL">
                                    </div>
                                    <div class="col-md-4">
                                        <select name="link_2_icon" class="form-select">
                                            <option value="fas fa-phone-alt" <?php if($myslide['link_2_icon'] == "fas fa-phone-alt") echo "selected"; ?>>Phone</option>
                                            <option value="fas fa-envelope" <?php if($myslide['link_2_icon'] == "fas fa-envelope") echo "selected"; ?>>Envelope</option>
                                            <option value="fas fa-compass" <?php if($myslide['link_2_icon'] == "fas fa-compass") echo "selected"; ?>>Compass</option>
                                            <option value="fas fa-concierge-bell" <?php if($myslide['link_2_icon'] == "fas fa-concierge-bell") echo "selected"; ?>>Service Bell</option>
                                            <option value="fas fa-handshake" <?php if($myslide['link_2_icon'] == "fas fa-handshake") echo "selected"; ?>>Handshake</option>
                                            <option value="fas fa-comments" <?php if($myslide['link_2_icon'] == "fas fa-comments") echo "selected"; ?>>Comments</option>
                                        </select>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Row 2: Classification and Media -->
            <div class="row mb-4">
                <!-- Classification Section -->
                <div class="col-md-6">
                    <div class="card h-100">
                        <div class="card-header bg-success text-white">
                            <strong><i class="fas fa-tags"></i> Classification</strong>
                        </div>
                        <div class="card-body">
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="mb-3">
                                        <label class="form-label"><strong>Service Group</strong></label>
                                        <select name="service_group" class="form-select">
                                            <option value="general" <?php if($myslide['service_group'] == "general") echo "selected"; ?>>General</option>
                                            <option value="current" <?php if($myslide['service_group'] == "current") echo "selected"; ?>>Current Account</option>
                                            <option value="saving" <?php if($myslide['service_group'] == "saving") echo "selected"; ?>>Savings</option>
                                            <option value="loans" <?php if($myslide['service_group'] == "loans") echo "selected"; ?>>Loans</option>
                                            <option value="investing" <?php if($myslide['service_group'] == "investing") echo "selected"; ?>>Investing</option>
                                            <option value="insurance" <?php if($myslide['service_group'] == "insurance") echo "selected"; ?>>Insurance</option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="mb-3">
                                        <label class="form-label"><strong>Navigation Context</strong></label>
                                        <select name="nav_context" class="form-select">
                                            <option value="personal" <?php if($myslide['nav_context'] == "personal") echo "selected"; ?>>Personal Banking</option>
                                            <option value="business" <?php if($myslide['nav_context'] == "business") echo "selected"; ?>>Business Banking</option>
                                            <option value="forex" <?php if($myslide['nav_context'] == "forex") echo "selected"; ?>>Forex Trading</option>
                                        </select>
                                    </div>
                                </div>
                            </div>
                            <div class="mb-3">
                                <label class="form-label"><strong>Template Group</strong></label>
                                <input type="text" name="template_group" class="form-control" value="<?=$myslide['template_group'] ?? 'default' ?>">
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Media Section -->
                <div class="col-md-6">
                    <div class="card h-100">
                        <div class="card-header bg-info text-white">
                            <strong><i class="fas fa-images"></i> Media</strong>
                        </div>
                        <div class="card-body">
                            <!-- Main Image -->
                            <div class="mb-3">
                                <label class="form-label"><strong>Main Image</strong></label>
                                <div class="image-preview-container" style="height: 200px; background: #F2F9FF; border-radius: 5px; position: relative; overflow: hidden; cursor: pointer;">
                                    <div id="postImgPreview" style="width: 100%; height: 100%; display: flex; align-items: center; justify-content: center; color: #666; font-size: 14px;">
                                        <?php if(!empty($myslide['photo'])): ?>
                                            <img src="<?= base_url('media/files/' . $myslide['photo']) ?>" style="max-width: 100%; max-height: 100%; object-fit: contain;" alt="Current slide image">
                                        <?php else: ?>
                                            <div class="text-center">
                                                <i class="fas fa-cloud-upload-alt fa-2x mb-2"></i><br>
                                                <span>Click to select image or<br>drag and drop</span>
                                            </div>
                                        <?php endif; ?>
                                    </div>
                                </div>
                                <input type="file" name="photo" id="post_image" class="postImg upload-photo" accept=".jpg, .gif, .png, .tiff, .jpeg, .webp" style="display: none;">
                                <div class="d-grid gap-2 mt-2">
                                    <button type="button" class="btn btn-outline-primary btn-sm" onclick="document.getElementById('post_image').click()">
                                        <i class="fas fa-image"></i> <?= empty($myslide['photo']) ? 'Choose Image' : 'Change Image' ?>
                                    </button>
                                </div>
                                <?php if(!empty($myslide['photo'])): ?>
                                    <small class="text-muted d-block mt-1">Current image will be replaced if you select a new one</small>
                                <?php endif; ?>
                            </div>

                            <!-- Background Image -->
                            <div class="mb-3">
                                <label class="form-label"><strong>Background Image</strong> <small class="text-muted">(Optional)</small></label>
                                <?php if(!empty($myslide['background-img'])): ?>
                                    <div class="mb-2">
                                        <img src="<?= base_url('media/files/' . $myslide['background-img']) ?>" class="img-thumbnail" style="max-height: 100px;" alt="Current background">
                                    </div>
                                <?php endif; ?>
                                <input type="file" name="background-img" class="form-control form-control-sm" accept=".jpg, .gif, .png, .tiff, .jpeg, .webp">
                                <?php if(!empty($myslide['background-img'])): ?>
                                    <small class="text-muted">Upload new to replace current background</small>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Row 3: Publishing Options and Extra Info -->
            <div class="row">
                <!-- Publishing Options -->
                <div class="col-md-6">
                    <div class="card h-100">
                        <div class="card-header bg-warning">
                            <strong><i class="fas fa-cog"></i> Publishing Options</strong>
                        </div>
                        <div class="card-body">
                            <div class="mb-3">
                                <label class="form-label"><strong>Status</strong></label>
                                <div class="input-group">
                                    <span class="input-group-text"><i class="fas fa-toggle-on"></i></span>
                                    <select name="status" class="form-select">
                                        <option value="published" <?php if(strtolower($myslide['status']) == "published") echo "selected"; ?> class="text-success">Published</option>
                                        <option value="unpublished" <?php if(strtolower($myslide['status']) == "unpublished") echo "selected"; ?> class="text-warning">Unpublished</option>
                                        <option value="archived" <?php if(strtolower($myslide['status']) == "archived") echo "selected"; ?> class="text-secondary">Archived</option>
                                        <option value="trashed" <?php if(strtolower($myslide['status']) == "trashed") echo "selected"; ?> class="text-danger">Trashed</option>
                                    </select>
                                </div>
                            </div>

                            <div class="mb-3">
                                <label class="form-label"><strong>Access Level</strong></label>
                                <div class="input-group">
                                    <span class="input-group-text"><i class="fas fa-lock"></i></span>
                                    <select name="access" class="form-select">
                                        <option value="public" <?php if(strtolower($myslide['access']) == "public") echo "selected"; ?>>Public</option>
                                        <option value="admin" <?php if(strtolower($myslide['access']) == "admin") echo "selected"; ?>>Admin Only</option>
                                        <option value="user" <?php if(strtolower($myslide['access']) == "user") echo "selected"; ?>>Registered Users</option>
                                    </select>
                                </div>
                            </div>

                            <div class="mb-3">
                                <label class="form-label"><strong>Display Order</strong></label>
                                <div class="input-group">
                                    <span class="input-group-text"><i class="fas fa-sort-numeric-down"></i></span>
                                    <select name="ordering" class="form-select">
                                        <?php for($i = 1; $i <= 10; $i++): ?>
                                            <option value="<?= $i ?>" <?php if($myslide['ordering'] == $i) echo "selected"; ?>><?= $i ?></option>
                                        <?php endfor; ?>
                                    </select>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Extra Information -->
                <div class="col-md-6">
                    <div class="card h-100">
                        <div class="card-header bg-secondary text-white">
                            <strong><i class="fas fa-plus-circle"></i> Extra Information</strong>
                        </div>
                        <div class="card-body">
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="mb-3">
                                        <label class="form-label"><strong>Extra Text 1</strong></label>
                                        <input type="text" name="extra_1" value="<?=$myslide['extra_1'] ?>" class="form-control">
                                    </div>
                                    <div class="mb-3">
                                        <label class="form-label"><strong>Extra Text 2</strong></label>
                                        <input type="text" name="extra_2" value="<?=$myslide['extra_2'] ?>" class="form-control">
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="mb-3">
                                        <label class="form-label"><strong>Extra Text 3</strong></label>
                                        <input type="text" name="extra_3" value="<?=$myslide['extra_3'] ?>" class="form-control">
                                    </div>
                                    <div class="mb-3">
                                        <label class="form-label"><strong>Extra Text 4</strong></label>
                                        <input type="text" name="extra_4" value="<?=$myslide['extra_4'] ?>" class="form-control">
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</form>

<!---- JS --->
<script src="<?= base_url();?>/assets/admin_assets/js/modules/sliders.js"></script>  
<?= $this->endSection();?>