<?= $this->extend('Modules\Admin\Views\index'); ?>
<?= $this->section('content');?>
<div class="container-fluid">
<div class="row mb-md-3">
	<div class="col">
		<h4>Slides</h4>
		<!-- Breadcrumb !-->
		<nav aria-label="breadcrumb"><small>
			<ol class="breadcrumb mb-0">
				<li class="breadcrumb-item"><a href="<?= base_url('administrator') ?> ">Home</a></li>
                <li class="breadcrumb-item"><a href="<?= base_url('administrator/sliders/dashboard') ?> ">Slider Dashboard</a></li>
				<li class="breadcrumb-item active" aria-current="page"><?= esc($bcrumb) ?> </li>
			</ol></small>
		</nav>
		<!-- End Breadcrumb !-->
	</div>
</div>
<!-- print success message !-->
<div class="row">
    <div class="col">
		<!-- print success message !-->
		<?php if(session()->getTempdata('success')): ?>
			<div class="alert alert-success" role="alert"><?= session()->getTempdata('success');?></div>
		<?php endif;?>
		<!-- print failure message !-->
		<?php if(session()->getTempdata('error')): ?>
			<div class="alert alert-danger" role="alert"><?= session()->getTempdata('error');?></div>
		<?php endif;?>
        <?php if(isset($validation)): ?>
			<div class="alert alert-danger">
		<?= $validation->listErrors()?>
		</div>
        <?php endif;?>
        <div id="showMsg"></div>
</div></div>
<!-- All Slides !-->
<div class="card card-body">
    <div ><a href="<?= base_url('administrator/sliders/add');?>" title="Add Slider" class="btn btn-sm btn-warning float-end rounded-0">Add Slide</a> <a href="<?= base_url('administrator/sliders/dashboard'); ?>" class="btn btn-sm btn-primary rounded-0 float-md-end">Back to Dashboard</a></div><hr>
    <div class="row">
        <?php foreach($allslides as $all):?>
        <div class="col-lg-6">
            <div class="row">
                <div class="col"><img src="<?= base_url('media/files/' . $all['photo']); ?>" class="side_img"></div>
                <div class="col">
                    <div class="d-flex flex-column bd-highlight mb-3">
                    <div class="p-2 bd-highlight fw-bold">
                        <?= $all['title']; ?>
                        <?php
                        $statusClass = [
                            'published' => 'bg-success',
                            'unpublished' => 'bg-warning',
                            'archived' => 'bg-secondary',
                            'trashed' => 'bg-danger'
                        ];
                        $statusBadgeClass = $statusClass[$all['status']] ?? 'bg-secondary';
                        ?>
                        <span class="badge <?= $statusBadgeClass ?> ms-2"><?= ucfirst($all['status']); ?></span>
                    </div>
                    <div class="p-2 bd-highlight"><?= $all['description']; ?></div>
                    <div class="p-2 bd-highlight"><small><strong>Extra 1: </strong><?= $all['extra_1']; ?></small></div>
                    <div class="p-2 bd-highlight">
                        <small><strong>Link: </strong>
                            <?php if ($all['link_text']): ?>
                                <i class="<?= $all['link_icon'] ?? 'fas fa-info-circle' ?>"></i> 
                                <?= $all['link_text'] ?> / 
                            <?php endif; ?>
                            <small class="text-muted"><?=$all['link']; ?></small>
                        </small>
                    </div>
                    <div class="p-2 bd-highlight">
                        <small><strong>Link 2: </strong>
                            <?php if ($all['link_2_text']): ?>
                                <i class="<?= $all['link_2_icon'] ?? 'fas fa-phone-alt' ?>"></i> 
                                <?= $all['link_2_text'] ?> / 
                            <?php endif; ?>
                            <small class="text-muted"><?=$all['link_2']; ?></small>
                        </small>
                    </div>
                    <div class="p-2 bd-highlight">
                        <small>
                            <strong>Group: </strong><span class="badge bg-info"><?= ucfirst($all['service_group'] ?? 'general') ?></span>
                            <strong class="ms-2">Context: </strong><span class="badge bg-primary"><?= ucfirst($all['nav_context'] ?? 'personal') ?></span>
                        </small>
                    </div>
                    <div class="p-2 bd-highlight">
                        <div class="d-flex bd-highlight">
                            <div class="p-2 flex-grow-1 bd-highlight"></div>
                            <div class="p-2 bd-highlight"><a href="<?= base_url('administrator/sliders/edit/').'/'. $all['id'].'-'.$all['alias']; ?>" class="btn btn-sm btn-success">Edit</a></div>
                            <div class="p-2 bd-highlight"><a onclick="delete_slide(<?= $all['id'] ?>, '<?= $all['title'] ?>')" class="btn btn-sm btn-danger">Delete</a></div>
                        </div>
                    </div>
                    </div>
                </div>
            </div>
        </div>
    <?php endforeach;?>
    </div>
</div>
            



                
    
<!-- Modals !-->
<?= view('Modules\Sliders\Views\modals\del_slideModal') ?>

<!---- JS --->  
<script type="text/javascript">
    $(document).ready(function () {
    $('#photoslist').DataTable({
        pageLength: 10,
        order: [[0, "Desc"]],
    });
    });

</script>        
<script src="<?= base_url();?>/assets/admin_assets/js/modules/sliders.js"></script>  
<?= $this->endSection();?>