<?php

namespace Modules\Sliders\Models;

use CodeIgniter\Model;

class SlidersModel extends Model
{

  protected $table = 'usc_slider';
    protected $primaryKey = 'id';

    protected $allowedFields = ['title', 'alias', 'photo', 'description', 'extra_1', 'extra_2', 'extra_3', 'extra_4', 'category_id', 'link_text', 'link_icon', 'link', 'link_2_text', 'link_2', 'link_2_icon', 'background-img', 'ordering', 'status', 'access', 'service_group', 'nav_context', 'template_group', 'created_by', 'updated_at', 'updated_by'];

    protected $returnType     = 'array';
    protected $useTimestamps  = true;
    protected $useSoftDeletes = true;
    
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';
    protected $deletedField  = 'deleted_at';

    /**
     * Get all sliders
     */
    public function getAll()
    {
      $builder = $this->db->table('usc_slider as s');
      $builder->select('s.*, sc.name as category_name');
      $builder->join('usc_slider_category as sc', 'sc.id=s.category_id', 'left');
      $builder->where('s.deleted_at', null);
      $builder->orderBy('s.ordering', 'ASC');
	  	return $builder->get()->getResultArray();
    }

    /**
     * Get home page sliders
     */
    public function getHomeSlides()
    {
      $builder = $this->db->table('usc_slider as s');
      $builder->select('s.*, sc.name as category_name');
      $builder->join('usc_slider_category as sc', 'sc.id=s.category_id', 'left');
      $builder->where('s.deleted_at', null);
      $builder->where('s.access', 'public');
      $builder->where('s.status', 'published');
      $builder->orderBy('s.ordering', 'ASC');
		  return $builder->get()->getResultArray();
    }

    /**
     * Get sliders by navigation context
     */
    public function getSlidersByContext($context = 'personal')
    {
      $builder = $this->db->table('usc_slider as s');
      $builder->select('s.*, sc.name as category_name');
      $builder->join('usc_slider_category as sc', 'sc.id=s.category_id', 'left');
      $builder->where('s.deleted_at', null);
      $builder->where('s.access', 'public');
      $builder->where('s.status', 'published');
      $builder->where('s.nav_context', $context);
      $builder->orderBy('s.ordering', 'ASC');
		  return $builder->get()->getResultArray();
    }

    /**
     * Get sliders by category
     */
    public function getSlidersByCategory($categoryId)
    {
      $builder = $this->db->table('usc_slider as s');
      $builder->select('s.*, sc.name as category_name');
      $builder->join('usc_slider_category as sc', 'sc.id=s.category_id', 'left');
      $builder->where('s.deleted_at', null);
      $builder->where('s.access', 'public');
      $builder->where('s.status', 'published');
      $builder->where('s.category_id', $categoryId);
      $builder->orderBy('s.ordering', 'ASC');
		  return $builder->get()->getResultArray();
    }

    /**
     * Format multiple sliders
     * 
     * @param array $sliders Array of slider data
     * @return array Sliders data
     */
    public static function formatSlidersData($sliders)
    {
        return empty($sliders) ? $sliders : $sliders;
    }

}
