<?php

namespace Modules\Sliders\Models;

use CodeIgniter\Model;

class SlidersCategoryModel extends Model
{

  protected $table = 'slider_category';
    protected $primaryKey = 'id';

    protected $allowedFields = ['name', 'alias', 'description', 'created_by', 'updated_at', 'updated_by'];

    protected $returnType     = 'array';
    protected $useTimestamps  = true;
    protected $useSoftDeletes = true;
    
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';
    protected $deletedField  = 'deleted_at';

    //Get all Post Categories
    public function getAll()
    {
      $builder = $this->db->table('slider_category');
      $builder->orderBy('id', 'DESC');
		  $result = $builder->get()->getResult();
		  return $result;
    }


}
