<?php

namespace Modules\Admin\Config;

use Config;
// Create a new instance of our RouteCollection class.
$routes = Config\Services::routes();

// Load the system's routing file first, so that the app and ENVIRONMENT
// can override as needed.
if (is_file(SYSTEMPATH . 'Config/Routes.php')) {
    require SYSTEMPATH . 'Config/Routes.php';
}


//setting up API routes
$routes->group('administrator/api', ['filter' => ['isLoggedIn'], 'namespace' => 'Modules\Sliders\Controllers'], static function($routes) {
    $routes->GET('get-page-urls', 'Api::getPageUrls');
});

//setting up Inventory routes.
$routes->group('administrator/sliders', ['filter' => ['isLoggedIn', 'checkPermission'], 'namespace' => 'Modules\Sliders\Controllers'],   static function($routes){

    $routes->GET('dashboard', 'Sliders::index');

    $routes->GET('categories', 'Sliders::sliderCategory');
    $routes->POST('category/add', 'Sliders::addCategory');
    $routes->GET('category/edit/(:any)', 'Sliders::editCategory/$1');
    $routes->POST('category/update', 'Sliders::updateCategory');
    $routes->POST('category/delete/(:any)', 'Sliders::delCategory/$1');

    $routes->GET('all', 'Sliders::allSlides');
    $routes->GET('add', 'Sliders::addSlider');
    $routes->POST('add', 'Sliders::addSlider');
    $routes->GET('edit/(:any)', 'Sliders::editSlider/$1');
    $routes->POST('update', 'Sliders::updateSlider');
    $routes->add('delete/(:any)', 'Sliders::delSlide/$1');



});
