<?php

namespace Modules\Settings\Models;

use CodeIgniter\Model;

class UserGroupsModel extends Model
{
    protected $table = 'usc_user_groups';
    protected $db;
    protected $primaryKey = 'id';

    protected $allowedFields = ['name', 'status','description', 'created_by', 'updated_by', 'updated_at'];

    protected $returnType     = 'object';
    protected $useTimestamps  = true;
    protected $useSoftDeletes = true;

    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';
    protected $deletedField  = 'deleted_at';

    public function __construct()
    {
        parent::__construct();
        $this->db = \Config\Database::connect();
    }

    public function getAll()
    {
        $builder = $this->db->table('usc_user_groups');
        $builder->where('deleted_at', null);
        return $results = $builder->get()->getResult();
    }

    public function getUserGroups()
    {
        $grps = [2,3,4,5];
        $builder = $this->db->table('usc_user_groups');
        $builder->where('deleted_at', null);
        $builder->whereIn('id', $grps);
        return $results = $builder->get()->getResult();
    }
    public function getUserGroupsFreeStartup()
    {
        $grps = [5,6];
        $builder = $this->db->table('usc_user_groups');
        $builder->whereIn('id', $grps);
        return $results = $builder->get()->getResult();
    }

}
