<?php

namespace Modules\Settings\Models;

use CodeIgniter\Model;
use CodeIgniter\I18n\Time;

class ModuleSectionModel extends Model
{
    protected $table = 'usc_module_sections';
    protected $db;
    protected $primaryKey = 'id';
    protected $allowedFields = ['name', 'slug', 'description', 'icon', 'is_active', 'sort_order'];

    protected $returnType     = 'object';
    protected $useTimestamps  = true;
    protected $useSoftDeletes = true;
    
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';
    protected $deletedField  = 'deleted_at';

    public function __construct()
    {
        parent::__construct();
        $this->db = \Config\Database::connect();
    }

    public function getAll()
    {
        $builder = $this->db->table('usc_module_sections as ms');
        $builder->where('ms.deleted_at', null);
        $result = $builder->get()->getResult();
        return $result;
    }

    public function getSectionsWithPermissions()
    {
        $builder = $this->db->table('usc_module_sections');
        $builder->select('usc_module_sections.*, COUNT(p.id) as permission_count')
                ->join('usc_permissions as p', 'p.module_section_id = usc_module_sections.id', 'left')
                ->groupBy('usc_module_sections.id')
                ->orderBy('sort_order', 'ASC');
        return $results = $builder->get()->getResult();
    }

}