<?php

namespace Modules\Settings\Models;

use CodeIgniter\Model;

class CompanySettingsModel extends Model 
{
	
	protected $table      = 'settings_company';
    protected $primaryKey = 'id ';
	
	protected $allowedFields = ['name', 'tel', 'mobile',  'photo', 'mobile', 'default_currency_id', 'tax_id',  'email', 'address_1', 'address_2', 'vision', 'mission', 'objectives', 'achievements', 'core_values', 'description', 'area_code', 'city_id', 'state_id', 'country_id', 'website', 'facebook', 'twitter', 'whatsapp', 'instagram', 'linkedin', 'created_by', 'updated_by'];

    protected $useTimestamps  = true;
    protected $useSoftDeletes = true;
    
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';
    protected $deletedField  = 'deleted_at';

    public function getCompanyDetails()
    {
        $id = 1;
        $builder = $this->db->table('settings_company');
        $builder->select('settings_company.*, co.name as country_name, st.name as state_name, ci.name as city_name,')
                ->join('cities as ci', 'ci.id=settings_company.city_id')
                ->join('states as st', 'st.id=settings_company.state_id')
                ->join('countries as co', 'co.id=settings_company.country_id')
                ->where('settings_company.id', $id);
        return $results = $builder->get()->getRow();
    }

}