<?php

namespace Modules\Settings\Config;

use Config;
// Create a new instance of our RouteCollection class.
$routes = Config\Services::routes();

// Load the system's routing file first, so that the app and ENVIRONMENT
// can override as needed.
if (is_file(SYSTEMPATH . 'Config/Routes.php')) {
    require SYSTEMPATH . 'Config/Routes.php';
}


//setting up Inventory routes.
$routes->group('administrator/settings', ['filter' => ['isLoggedIn',  'checkPermission'], 'namespace' => 'Modules\Settings\Controllers'],   static function($routes){

    $routes->GET('all', 'LTcmsSettings::index');
    $routes->GET('site', 'CompanySettings::index');


    $routes->match(['GET', 'POST'], 'company', 'CompanySettings::setCompany');
    $routes->match(['GET', 'POST'], 'policies', 'CompanySettings::managePolicies');
    $routes->GET('delete-policy/(:num)', 'CompanySettings::deletePolicy/$1');

    $routes->match(['GET', 'POST'], 'permissions', 'SystemPermissions::managePermission');
    $routes->GET('delete-permission/(:num)', 'SystemPermissions::deletePermission/$1');
    $routes->GET('show-group-permissions/(:num)', 'SystemPermissions::getGroupPermissions/$1');
    $routes->POST('update-group-permission', 'SystemPermissions::updateGroupPermission');

    $routes->POST('module-sections/create', 'LTcmsSettings::createModuleSection');
    $routes->GET('module-sections/edit/(:num)', 'LTcmsSettings::editModuleSection/$1');
    $routes->POST('module-sections/update', 'LTcmsSettings::updateModuleSection');
    $routes->GET('module-sections/delete/(:num)', 'LTcmsSettings::deleteModuleSection/$1');


});
