<?= $this->extend('Modules\Admin\Views\index'); ?>
<?= $this->section('content');?>
<div class="container-fluid">
<div class="row mb-md-3">
	<div class="col">
		<h4>View Post</h4>
		<!-- Breadcrumb !-->
		<nav aria-label="breadcrumb"><small>
			<ol class="breadcrumb mb-0">
				<li class="breadcrumb-item"><a href="<?= base_url('administrator') ?> ">Home</a></li>
                <li class="breadcrumb-item"><a href="<?= base_url('administrator/pages') ?> ">All Pages</a></li>
				<li class="breadcrumb-item active" aria-current="page"><?= esc($bcrumb) ?> </li>
			</ol></small>
		</nav>
		<!-- End Breadcrumb !-->
	</div>
</div>
<!-- print success message !-->
<div class="row">
    <div class="col">
		<!-- print success message !-->
		<?php if(session()->getTempdata('success')): ?>
			<div class="alert alert-success" role="alert"><?= session()->getTempdata('success');?></div>
		<?php endif;?>
		<!-- print failure message !-->
		<?php if(session()->getTempdata('error')): ?>
			<div class="alert alert-danger" role="alert"><?= session()->getTempdata('error');?></div>
		<?php endif;?>
        <?php if(isset($validation)): ?>
			<div class="alert alert-danger">
		<?= $validation->listErrors()?>
		</div>
        <?php endif;?>
        <div id="showMsg"></div>
</div></div>
<!-- Create/Post !-->
<div class="row">
    <div class="col-lg-10 col-md-10 col-sm-10">
        <div class="card card-body mb-3">
            <h4 class="fw-bold"><?= $singlePost->title; ?></h4>
            <span class="d-flex"><small><strong>Date:</strong> <?= date('jS M Y', strtotime($singlePost->created_at)); ?> | <strong>Author:</strong> <?= $singlePost->first_name; ?>  | <strong>Category:</strong> <?= $singlePost->category_name; ?> | <strong>Hits:</strong> <span class="badge bg-danger bg-opacity-50"><?= $singlePost->hits; ?></span> </small></span>
            <hr/>
			<small>
                        <strong>Tags: </strong>
                        <?php foreach($postTags as $tag): ?>
                            <span class="badge bg-primary me-1"><?= $tag->tag; ?></span> 
                        <?php endforeach; ?>
                    </small>
			<small><strong>Page Link:</strong> <span class="text-danger"><?= base_url().$singlePost->menu_link; ?></span> </small>
            <hr/>
            <p><img src="<?= $singlePost->photo; ?>" alt="" class="img-fluid" /></p>
            <?= $singlePost->content ?>

        </div> <!-- Post Content !-->
        <div class="card card-body">
            <h5 class="card-title"> Comments </h5>
            <?php if($comments):?>
            <div class="table-responsive">
                <table class="table table-hovered">
                    <tbody>
                        <?php foreach($comments as $comment):?>
                        <tr>
                            <td><small style="font-size: 10px;"><?= date('jS M Y', strtotime($comment->created_at)) ?></small></td>
                            <td><?= $comment->description; ?>  <small class="text-muted" style="font-size: 10px;"><i>By <?= $comment->first_name; ?></i></small></td>
                            <td>
                                <div class="btn-group">
                                    <a class="btn btn-sm btn-primary" style="cursor: pointer" onclick="edit_postcomment(<?= $comment->id ?>)"><i class="bi bi-pencil"></i></a>
                                    <a class="btn btn-sm btn-danger" style="cursor: pointer" onclick="delete_postcomment(<?= $comment->id ?>)"><i class="bi bi-trash"></i></a>
                                </div>
                            </td>
                        </tr>
                        <?php endforeach;?>
                    </tbody>
                </table>
            </div>
            <?php else:?>
                <p class="text-muted">Currently NO comments available</p>
            <?php endif;?>
        </div><!-- Show Comments here !-->
    </div>
    <div class="col-lg-2 col-md-2 col-sm-2">
        <a href="<?= base_url('administrator/posts'); ?>" class="btn btn-sm btn-secondary mb-3 w-100">Back to Posts</a>
        <a href="<?= base_url('administrator/posts/edit/').$singlePost->id.'-'.$singlePost->alias; ?>" class="btn btn-sm btn-info mb-3 w-100">Edit Post</a>
        <a href="<?= base_url('administrator/posts/add/'); ?>" class="btn btn-sm btn-primary mb-3 w-100">Add New Post</a>
        <a  class="btn btn-sm bg-warning bg-opacity-25 mb-3 w-100" onclick="add_postcomment(<?= $singlePost->id;?>)">Add Comment</a>

        <a  class="btn btn-sm bg-warning bg-opacity-50 mb-3 w-100"  href="<?= base_url('administrator/posts/comments'); ?>">View Comments</a>

    </div>
</div>

<!-- End Create/Post !-->
<!-- Modals !-->
<?= view('Modules\Posts\Views\comments\modals\\add_comment') ?>
<!---- JS --->
<script src="<?= base_url();?>/assets/admin_assets/js/modules/posts.js"></script>  
<?= $this->endSection();?>