<?= $this->extend('Modules\Admin\Views\index'); ?>
<?= $this->section('content');?>
<div class="container-fluid">
<div class="row mb-md-3">
	<div class="col">
		<h4>All Tags</h4>
		<!-- Breadcrumb !-->
		<nav aria-label="breadcrumb"><small>
			<ol class="breadcrumb mb-0">
				<li class="breadcrumb-item"><a href="<?= base_url('administrator') ?> ">Home</a></li>
                <li class="breadcrumb-item"><a href="<?= base_url('administrator/posts') ?> ">All Posts</a></li>
				<li class="breadcrumb-item active" aria-current="page"><?= esc($bcrumb) ?> </li>
			</ol></small>
		</nav>
		<!-- End Breadcrumb !-->
	</div>
</div>
<!-- Post Category ADD/EDIT/DELETE/Detailed List !-->
<div class="row">
    <div class="col">

			<!-- print success message !-->
			<?php if(session()->getTempdata('success')): ?>
				<div class="alert alert-success" role="alert"><?= session()->getTempdata('success');?></div>
				<?php endif;?>
			<!-- print failure message !-->
			<?php if(session()->getTempdata('error')): ?>
				<div class="alert alert-danger" role="alert"><?= session()->getTempdata('error');?></div>
			<?php endif;?>
            <div id="showMsg"></div>
</div></div>
<div class="row">
    <div class="col-lg-4"> 
        <div class="card">
                <?php if(!isset($singleTag)):?>
				<div class="card-header"><h6 class="card-title fw-bold">Add Tag</h6></div>
				<div class="card-body ">
                <!-- Add Category  !-->
                <form method="POST" action="<?= base_url('administrator/posts/tags/add');?>">
                <?= csrf_field(); ?>
                <div class="row">
                    <div class="mb-3">
                        <label class="form-label">Tag Name</label>
                        <input type="text" class="form-control" name="name">
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Description</label>
                        <textarea class="form-control" name="description" style="height: 80px;"></textarea>
                    </div>
                    <div class="mb-3">
                        <button type="submit" class="btn btn-outline-danger w-100" >Save</button>
                    </div>
                </div>
                </form>
            </div>
                <!-- End Add Category  !-->
                <?php else:?>
                <div class="card-header"><h6 class="card-title fw-bold">Edit Tags</h6></div>
                <div class="card-body ">
                <!-- Edit Category  !-->
                    <form method="POST" action="<?= base_url('administrator/posts/tags/update');?>">
                    <?= csrf_field(); ?>
                    <div class="row">
                        <div class="mb-3">
                            <label class="form-label">Tags Name</label>
                            <input type="text" class="form-control" name="name" value="<?= $singleTag['name']; ?>">
                        </div>
                        <div class="mb-3">
                            <label class="form-label">Description</label>
                            <textarea class="form-control" name="description" style="height: 80px;"><?= $singleTag['description']; ?></textarea>
                        </div>
                        <div class="mb-3">
                            <input type="hidden" name="id" value="<?= $singleTag['id']; ?>" >
                            <button type="submit" class="btn btn-outline-danger w-100" >Edit</button>
                        </div>
                    </div>
                    </form>
                <!-- End Edit Category  !-->
                </div>
                <?php endif; ?>
        </div>
    </div>
    <div class="col-lg-8 "> 
        <!-- Display all categories !-->
        <div class="card">
        <div class="card-header"><h6 class="card-title fw-bold">Tags</h6></div> 
            <div class="card-body">
        <div class="table-responsive">
            <table id="catlist" class="table table-hover">
                <thead class="bg-primary bg-opacity-10" style="font-size: 13px;">
                    <tr>
                    <th>Name</th>
                    <th>Description</th>
                    <th></th>
                    </tr>
                </thead>
                <tbody style="font-size: 13px;">
                    <?php foreach($tags as $c): ?>
                        <tr>
                        <td><?= $c->name; ?> <small class="text-muted"> (<?= $c->alias; ?>)</small></td>
                        <td> <small class="text-muted"> <?= $c->description; ?></small></td>
                        <td>
                        <div class="btn-group" role="group" aria-label="edit category">
                        <a href="<?= base_url('administrator/posts/tags/edit/').'/'.$c->id; ?>" type="button" class="btn btn-success p-1 rounded-left"><small><i class="bi bi-pencil-square mx-0 "></i></small></a>
                        <a  class="btn btn-danger p-1 rounded-right" onclick="delete_tag(<?= $c->id ?>, '<?= $c->name ?>')"><small><i class="bi bi-trash mx-0" ></i></small></a>
                        </div>
                        </td>
                        </tr>
                    <?php endforeach;?>
                </tbody>
            </table>
        </div>
    </div></div>
            
<!-- END Post Category ADD/EDIT/DELETE/Detailed List !-->
<!-- Modals !-->

<!---- JS --->  
<script type="text/javascript">
    $(document).ready(function () {
    $('#catlist').DataTable({
        pageLength: 10,
        order: [[0, "Desc"]],
    });
    });

</script>
<script>
    function delete_tag(id, name){
        var confirmation = confirm('Are you sure you want to delete '+name+' tag ?');
        if(confirmation == true){
            window.location.href= base_url + "administrator/posts/tags/delete/" + id
        }
    }
</script>       
<script src="<?= base_url();?>/assets/admin_assets/js/modules/posts.js"></script>  
<?= $this->endSection();?>