<?= $this->extend('Modules\Admin\Views\index'); ?>
<?= $this->section('content');?>
<div class="container-fluid">
<div class="row mb-md-3">
    <div class="col">
        <h4>Service Groups</h4>
        <nav aria-label="breadcrumb"><small>
            <ol class="breadcrumb mb-0">
                <li class="breadcrumb-item"><a href="<?= base_url('administrator') ?>">Home</a></li>
                <li class="breadcrumb-item active" aria-current="page"><?= esc($bcrumb) ?></li>
            </ol></small>
        </nav>
    </div>
</div>
<div class="row">
    <div class="col">
        <?php if(session()->getTempdata('success')): ?>
            <div class="alert alert-success" role="alert"><?= session()->getTempdata('success');?></div>
        <?php endif;?>
        <?php if(session()->getTempdata('error')): ?>
            <div class="alert alert-danger" role="alert"><?= session()->getTempdata('error');?></div>
        <?php endif; ?>
    </div>
</div>
<div class="row">
    <div class="col-lg-4">
        <div class="card">
            <?php if(!isset($singleGroup)):?>
            <div class="card-header"><h6 class="card-title fw-bold">Add Service Group</h6></div>
            <div class="card-body">
                <form method="POST" action="<?= base_url('administrator/service-groups/add');?>">
                <?= csrf_field(); ?>
                <div class="mb-3">
                    <label class="form-label">Name</label>
                    <input type="text" class="form-control" name="name">
                </div>
                <div class="mb-3">
                    <label class="form-label">Description</label>
                    <textarea class="form-control" name="description" style="height: 80px;"></textarea>
                </div>
                <div class="mb-3">
                    <label class="form-label">Nav Contexts</label>
                    <div>
                        <?php foreach(($nav_contexts ?? []) as $nc): ?>
                            <div class="form-check">
                                <input class="form-check-input" type="checkbox" name="nav_contexts[]" value="<?= $nc['id'] ?>" id="nc-<?= $nc['id'] ?>">
                                <label class="form-check-label" for="nc-<?= $nc['id'] ?>"><?= esc($nc['name']) ?></label>
                            </div>
                        <?php endforeach; ?>
                    </div>
                </div>
                <div class="mb-3">
                    <button type="submit" class="btn btn-outline-danger w-100">Save</button>
                </div>
                </form>
            </div>
            <?php else:?>
            <div class="card-header"><h6 class="card-title fw-bold">Edit Service Group</h6></div>
            <div class="card-body">
                <form method="POST" action="<?= base_url('administrator/service-groups/update');?>">
                <?= csrf_field(); ?>
                <div class="mb-3">
                    <label class="form-label">Name</label>
                    <input type="text" class="form-control" name="name" value="<?= esc($singleGroup['name']) ?>">
                </div>
                <div class="mb-3">
                    <label class="form-label">Description</label>
                    <textarea class="form-control" name="description" style="height: 80px;"><?= esc($singleGroup['description']) ?></textarea>
                </div>
                <div class="mb-3">
                    <label class="form-label">Nav Contexts</label>
                    <div>
                        <?php
                        // assigned nav-context ids should be provided by the controller when editing
                        $assigned = $assigned ?? [];
                        foreach(($nav_contexts ?? []) as $nc): ?>
                            <?php $checked = in_array($nc['id'], $assigned) ? 'checked' : ''; ?>
                            <div class="form-check">
                                <input class="form-check-input" type="checkbox" name="nav_contexts[]" value="<?= $nc['id'] ?>" id="nc-<?= $nc['id'] ?>" <?= $checked ?>>
                                <label class="form-check-label" for="nc-<?= $nc['id'] ?>"><?= esc($nc['name']) ?></label>
                            </div>
                        <?php endforeach; ?>
                    </div>
                </div>
                <div class="mb-3">
                    <input type="hidden" name="id" value="<?= $singleGroup['id'] ?>">
                    <button type="submit" class="btn btn-outline-danger w-100">Update</button>
                </div>
                </form>
            </div>
            <?php endif; ?>
        </div>
    </div>
    <div class="col-lg-8">
        <div class="card">
            <div class="card-header"><h6 class="card-title fw-bold">Service Groups</h6></div>
            <div class="card-body">
                <div class="table-responsive">
                    <table id="grouplist" class="table table-hover">
                        <thead class="bg-primary bg-opacity-10">
                            <tr>
                                <th>#</th>
                                <th>Name</th>
                                <th>Slug</th>
                                <th>Active</th>
                                <th></th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach($groups as $g): ?>
                                <tr>
                                    <td><?= $g['id'] ?></td>
                                    <td><?= esc($g['name']) ?></td>
                                    <td><?= esc($g['slug']) ?></td>
                                    <td><?= $g['is_active'] ? 'Yes' : 'No' ?></td>
                                    <td>
                                        <a href="<?= base_url('administrator/service-groups/edit/'.$g['id']) ?>" class="btn btn-sm btn-outline-secondary">Edit</a>
                                    </td>
                                </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
    $(document).ready(function(){
        $('#grouplist').DataTable({ pageLength: 10, order: [[0, 'desc']] });
    });
</script>

<?= $this->endSection(); ?>
