<?= $this->extend('Modules\Admin\Views\index'); ?>
<?= $this->section('content');?>
<div class="container-fluid">
<div class="row mb-md-3">
	<div class="col">
		<h4>Add Page</h4>
		<!-- Breadcrumb !-->
		<nav aria-label="breadcrumb"><small>
			<ol class="breadcrumb mb-0">
				<li class="breadcrumb-item"><a href="<?= base_url('administrator') ?> ">Home</a></li>
                <li class="breadcrumb-item"><a href="<?= base_url('administrator/pages') ?> ">All Pages</a></li>
				<li class="breadcrumb-item active" aria-current="page"><?= esc($bcrumb) ?> </li>
			</ol></small>
		</nav>
		<!-- End Breadcrumb !-->
	</div>
</div>
<!-- print success message !-->
<div class="row">
    <div class="col">

			<!-- print success message !-->
			<?php if(session()->getTempdata('success')): ?>
				<div class="alert alert-success" role="alert"><?= session()->getTempdata('success');?></div>
				<?php endif;?>
			<!-- print failure message !-->
			<?php if(session()->getTempdata('error')): ?>
				<div class="alert alert-danger" role="alert"><?= session()->getTempdata('error');?></div>
			<?php endif;?>
            <?php if(isset($validation)): ?>
			<div class="alert alert-danger">
			<?= $validation->listErrors()?>
			</div>
            <?php endif;?>
            <div id="showMsg"></div>
</div></div>
<!-- Create/Post !-->
<form id="yourFormId" method="POST" action="<?= base_url('administrator/pages/add')?>" enctype="multipart/form-data">
    <?= csrf_field(); ?>
    <div class="card rounded-0 shadow-sm">
        <div class="card-header bg-light bg-opacity-100">
            <!-- Save/New/Cancel Btns !-->
            <div class="d-flex bd-highlight align-items-center">
                <div class="p-1 bd-highlight align-items-center">
                    <div class="btn-group border shadow-sm">
                    <button type="button" class="btn bg-success rounded-0"><i class="bi bi-plus-lg text-white"></i></button>
                    <button type="submit" class="btn btn-sm btn-success align-items-center"> Save & Close</button>
                    </div>
                </div>
                <div class="p-1 bd-highlight d-none d-md-block">
                    <div class="btn-group border shadow-sm">
                    <button type="button" class="btn bg-secondary bg-opacity-25 rounded-0"><i class="bi bi-plus-lg"></i></button>
                    <a href="#" class="btn btn-sm btn-light">Save & New</a>
                    </div>
                </div>
                <div class="p-1 bd-highlight">
                    <div class="btn-group border shadow-sm">
                    <button type="button" class="btn bg-danger bg-opacity-25 rounded-0"><i class="bi bi-x-lg"></i></button>
                    <button type="reset" class="btn btn-sm btn-danger">Reset</button>
                    </div>
                </div>
                <div class="p-1 bd-highlight">
                    <div class="btn-group border shadow-sm">
                    <button type="button" class="btn bg-primary bg-opacity-25 rounded-0"><i class="bi bi-eye"></i></button>
                    <a href="<?= base_url('administrator/pages') ?>" class="btn btn-sm btn-primary">Back to Pages</a>
                    </div>
                </div>
            </div>
            <!-- END Save/New/Cancel Btns !-->
        </div>
        <div class="card-body">
            <div class="row">
                <div class="col-md-7">
                    <div class="mb-3">
                    <label class="form-label"><strong>Title</strong></label>
                    <input type="text" name="title" class="form-control" required>
                    </div>
                </div>
                <div class="col-md-5">
                    <div class="mb-3">
                    <label class="form-label"><strong>Alias</strong></label>
                    <input type="text" name="alias" id="alias_input" class="form-control bg-secondary bg-opacity-10" readonly>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-lg-9">
                  <!-- Main post content !-->
                   
                  <div class="mb-3">
                    <label class="form-label"><strong>Content</strong></label>
                    <textarea id="tiny"  name="content" class="form-control tinymce-editor" cols="10" rows="10" placeholder="Write full text here.."></textarea>
                  </div>
                  <div class="mb-3">
                    <label class="form-label"><strong>Excerpt text</strong></label>
                    <textarea name="excerpt" class="form-control"  rows="2" placeholder="Write summary text here.."></textarea>
                  </div>
                  
                  <!-- END Main post content  !-->
                </div>
                <div class="col-lg-3">
                 <!-- Main post params !-->
                 <div class="mb-3">
                    <label class="form-label"><strong>Content Type</strong></label>
                    <select name="content_type_id" class="form-select" id="content_type_selector">
                        <option value="1" selected>Page</option>
                        <option value="3">Service</option>
                    </select>
                    <small class="text-muted">Select Page (if static) or Service (if dynamic content or template)</small>
                  </div>
                  
                  <div class="mb-3" id="template_field" style="display:none;">
                    <label class="form-label"><strong>Page Template *</strong></label>
                    <select name="template_id" class="form-select">
                        <option value="">-- Select Template --</option>
                        <?php foreach($pageTemplates as $template): ?>
                            <option value="<?= $template['id'] ?>"><?= esc($template['name']) ?></option>
                        <?php endforeach; ?>
                    </select>
                    <small class="text-muted">Choose the layout/design for this service</small>
                  </div>


                   <div class="mb-3" id="context_type_field" style="display:none;">
                        <label class="form-label"><strong>Banking Context *</strong></label>
                        <?php foreach(($navContexts ?? []) as $nc): ?>
                            <div class="form-check">
                                <input class="form-check-input" 
                                       type="radio" 
                                       name="nav_context" 
                                       id="context<?= esc(ucfirst($nc['slug'])) ?>" 
                                       value="<?= esc($nc['slug']) ?>"
                                       <?= ($nc['slug'] === 'personal') ? 'checked' : '' ?>>
                                <label class="form-check-label" for="context<?= esc(ucfirst($nc['slug'])) ?>">
                                    <?= esc($nc['name']) ?>
                                    <small class="d-block text-muted">Example: <?= esc($nc['slug']) ?>/your-service</small>
                                </label>
                            </div>
                        <?php endforeach; ?>
                    </div>

                    <div class="mb-3">
                                        <label class="form-label"><strong>Menu Link (preview)</strong></label>
                                        <input type="text" id="menu_link_preview_display" class="form-control" placeholder="Auto-generated from title" readonly />
                                        <div class="form-check mt-1">
                                            <input class="form-check-input" type="checkbox" value="1" id="applyMenuLink">
                                            <label class="form-check-label" for="applyMenuLink">Use this link as page URL</label>
                                        </div>
                                        <input type="hidden" name="menu_link" id="menu_link_hidden" value="" />
                                        <small class="text-muted d-block">For services, the URL will include the banking context prefix (personal/business). Check the box above to use this URL.</small>
                                    </div>

                 
                                   <div class="mb-3" id="service_group_field" style="display:none;">
                    <label class="form-label"><strong>Service Group *</strong></label>
                    <select name="service_group_id" id="service_group_select" class="form-select">
                        <option value="">-- Select Service Group --</option>
                        <?php foreach($serviceGroups as $group): ?>
                            <option value="<?= $group['id'] ?>"><?= esc($group['name']) ?></option>
                        <?php endforeach; ?>
                    </select>
                    <small class="text-muted">Category for this banking service</small>
                  </div>
                                     
                 

                  <div class="mb-3">
                    <label class="form-label"><strong>Status</strong></label>
                    <select name="status" class="form-select bg-success bg-opacity-75 text-white" >
                        <option value="Published" >Published</option>
                        <option value="Unpublished">Unpublished</option>
                        <option value="Archived">Archived</option>
                        <option value="Trashed">Trashed</option>
                    </select>
                  </div>
                  <div class="mb-3">
                    <label class="form-label"><strong>Access</strong></label>
                    <select name="access" class="form-select">
                        <option value="Public" >Public</option>
                        <option value="Private">Private</option>
                        <option value="Users">Users</option>
                    </select>
                  </div>
                  <div class="mb-3">
                    <div style="height: 150px; background: #F2F9FF; border-radius: 5px;">
                    <div id="postImgPreview"></div>
                    <small class="d-flex text-muted p-2">Add Photo to post</small>
                    </div>
                    <input type="file" name="photo" id="post_image" class="postImg upload-photo" accept=".jpg, .gif, .png, .tiff, .jpeg, .webp">
                  </div>
                  <div class="mb-3">
                    <label class="form-label"><strong>Author</strong></label>
                    <input type="hidden" name="author_id" value="<?= $userdata->id; ?>">
                    <input type="text" class="form-control" name="author_name"  value="<?= $userdata->first_name.' '.$userdata->last_name;?>" readonly>
                  </div>
                  <input type="hidden" name="category_id" value="1">
                <!-- END Main post params  !-->
                </div>
            </div>
            <div class="row mb-4">
                <div class="accordion accordion-flush" id="accordionFlushExample">
                    <div class="accordion-item">
                        <h2 class="accordion-header" id="flush-headingOne">
                        <button class="accordion-button collapsed bg-info bg-opacity-10                                    " type="button" data-bs-toggle="collapse" data-bs-target="#flush-collapseOne" aria-expanded="false" aria-controls="flush-collapseOne">
                           Add SEO meta description and keywords
                        </button>
                        </h2>
                        <div id="flush-collapseOne" class="accordion-collapse collapse" aria-labelledby="flush-headingOne" data-bs-parent="#accordionFlushExample">
                        <div class="accordion-body">
                            <div class="row">
                <div class="col">
                    <div class="mb-3">
                    <label class="form-label"><strong>SEO Description</strong></label>
                    <textarea name="metadesc" class="form-control"   placeholder="Provide description(150 words) for SEO experience"></textarea>
                  </div>
                </div>
                <div class="col">
                    <div class="mb-3">
                    <label class="form-label"><strong>SEO Keywords</strong></label>
                    <textarea name="metakey" class="form-control"   placeholder="SEO Keywords separated by comma"></textarea>
                  </div>
                </div>
            </div>
                        </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</form>
<!-- End Create/Post !-->
<!---- JS --->

<script>
// Show/hide service prefix toggle based on content type
$(document).ready(function() {
    $('#content_type_selector').on('change', function() {
        if($(this).val() == '3') {  // Service
            $('#service_prefix_toggle').slideDown();
        } else {  // Page
            $('#service_prefix_toggle').slideUp();
        }
    });
    
    // Trigger on page load
    $('#content_type_selector').trigger('change');
});
</script>
<script>
// Auto-generate menu_link from title and toggle
$(document).ready(function() {
    var $title = $('input[name="title"]');
    var $alias = $('#alias_input');
    var $preview = $('#menu_link_preview_display');
    var $hidden = $('#menu_link_hidden');
    var $apply = $('#applyMenuLink');

    function slugify(text) {
        return text.toString().toLowerCase().trim()
            .replace(/[^a-z0-9]+/g, '-')
            .replace(/^-+|-+$/g, '');
    }

    function updatePreview() {
        var titleVal = $title.val() || '';
        var slug = slugify(titleVal);
        var contentType = $('#content_type_selector').val();
        var context = $('input[name="nav_context"]:checked').val();
        var previewVal = slug;
        
        if (contentType == '3') {
            previewVal = context + '/' + slug;
        }

        // Update alias (slug) - for new pages we auto-set alias
        $alias.val(slug);

        // Update preview display
        $preview.val(previewVal);

        // If apply checkbox is checked, copy to hidden input (will be submitted)
        if ($apply.is(':checked')) {
            $hidden.val(previewVal);
        }
    }

    // If admin checks/unchecks apply, copy/clear hidden input
    $apply.on('change', function(){
        if ($(this).is(':checked')) {
            $hidden.val($preview.val());
        } else {
            $hidden.val('');
        }
    });

    // Listen for changes on title, content type, and nav context
    $title.on('keyup blur change', updatePreview);
    $('#content_type_selector, input[name="nav_context"]').on('change', updatePreview);

    // Initialize
    updatePreview();
});
</script>
<script src="<?= base_url();?>/assets/admin_assets/js/modules/posts.js"></script>  

<script>
// Dynamic form field display based on content type
$(document).ready(function() {
    // Handle content type change
    $('#content_type_selector').change(function() {
        const contentType = $(this).val();
        
        if (contentType == '1') {
            // Page selected
            $('#service_group_field').hide();
            $('#context_type_field').hide();
            $('#template_field').hide();
        } else if (contentType == '3') {
            // Service selected
            $('#service_group_field').show();
            $('#context_type_field').show();
            $('#template_field').show();
        }
    });
    
    // Trigger on page load
    $('#content_type_selector').trigger('change');
});
</script>
<script>
// Service groups filtering using JavaScript
$(document).ready(function(){
    var serviceGroupsData = <?= json_encode($serviceGroupsWithContexts ?? []) ?>;
    
    function filterGroupsByContext(contextType) {
        if (!contextType) {
            $('#service_group_select').html('<option value="">-- Select Service Group --</option>');
            return;
        }
        
        var html = '<option value="">-- Select Service Group --</option>';
        var foundGroups = false;
        
        $.each(serviceGroupsData, function(i, group) {
            if (group.nav_contexts && group.nav_contexts.includes(contextType)) {
                html += '<option value="' + group.id + '">' + group.name + '</option>';
                foundGroups = true;
            }
        });
        
        if (!foundGroups) {
            html += '<option value="">(No service groups available)</option>';
        }
        
        $('#service_group_select').html(html);
    }

    // Bind change on context type radio buttons
    $(document).on('change', 'input[name="nav_context"]', function(){
        filterGroupsByContext($(this).val());
    });

    // Initial filter using default selected radio
    filterGroupsByContext($('input[name="nav_context"]:checked').val());
});
</script>
<?= $this->endSection();?>