<?= $this->extend('Modules\Admin\Views\index'); ?>
<?= $this->section('content');?>
<div class="container-fluid">
    <div class="row mb-md-3">
        <div class="col">
            <h4>Context Manager</h4>
            <nav aria-label="breadcrumb"><small>
                <ol class="breadcrumb mb-0">
                    <li class="breadcrumb-item"><a href="<?= base_url('administrator') ?>">Home</a></li>
                    <li class="breadcrumb-item active" aria-current="page">Context Manager</li>
                </ol></small>
            </nav>
        </div>
    </div>
    <div class="row">
        <div class="col">
            <?php if(session()->getTempdata('success')): ?>
                <div class="alert alert-success" role="alert"><?= session()->getTempdata('success');?></div>
            <?php endif;?>
            <?php if(session()->getTempdata('error')): ?>
                <div class="alert alert-danger" role="alert"><?= session()->getTempdata('error');?></div>
            <?php endif; ?>
        </div>
    </div>
    <div class="row">
        <div class="col-lg-6">
            <div class="card mb-4">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h6 class="card-title fw-bold mb-0">Nav Contexts</h6>
                    <a href="#addNavContextModal" data-bs-toggle="modal" class="btn btn-sm btn-outline-primary">Add</a>
                </div>
                <div class="card-body">
                    <?php if(isset($singleNavContext) && !empty($singleNavContext)): ?>
                    <div class="mb-3">
                        <h6>Edit Nav Context</h6>
                        <form method="POST" action="<?= base_url('administrator/posts/context-manager/nav-contexts/update') ?>">
                            <?= csrf_field() ?>
                            <div class="mb-2">
                                <label class="form-label">Name</label>
                                <input type="text" class="form-control" name="name" value="<?= esc($singleNavContext['name']) ?>">
                            </div>
                            <div class="mb-2">
                                <label class="form-label">Description</label>
                                <textarea class="form-control" name="description" style="height:80px"><?= esc($singleNavContext['description']) ?></textarea>
                            </div>
                            <input type="hidden" name="id" value="<?= $singleNavContext['id'] ?>">
                            <button class="btn btn-sm btn-outline-success">Update</button>
                            <a href="<?= base_url('administrator/posts/context-manager') ?>" class="btn btn-sm btn-outline-secondary">Cancel</a>
                        </form>
                    </div>
                    <hr />
                    <?php endif; ?>
                    <ul class="list-group">
                        <?php foreach($nav_contexts as $nc): ?>
                        <li class="list-group-item d-flex justify-content-between align-items-center">
                            <div>
                                <?= esc($nc['name']) ?>
                                <div class="small text-muted">
                                    <?= esc($nc['slug'] ?? '') ?>
                                </div>
                            </div>
                            <span>
                                <a href="#" 
                                   class="btn btn-sm btn-outline-secondary btn-view-navcontext"
                                   data-id="<?= $nc['id'] ?>"
                                   data-name="<?= esc($nc['name']) ?>"
                                   data-slug="<?= esc($nc['slug']) ?>"
                                   data-description="<?= esc($nc['description']) ?>"
                                   data-active="<?= $nc['is_active'] ?>"
                                   data-created="<?= esc($nc['created_at']) ?>"
                                >View</a>
                                <a href="<?= base_url('administrator/posts/context-manager/nav-contexts/edit/'.$nc['id']) ?>" class="btn btn-sm btn-outline-success">Edit</a>
                                <a href="<?= base_url('administrator/posts/context-manager/nav-contexts/delete/'.$nc['id']) ?>" class="btn btn-sm btn-outline-danger" onclick="return confirm('Delete this nav context?')">Delete</a>
                            </span>
                        </li>
                        <?php endforeach; ?>
                    </ul>
                </div>
            </div>
        </div>
        <div class="col-lg-6">
            <div class="card mb-4">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h6 class="card-title fw-bold mb-0">Service Groups</h6>
                    <a href="#addServiceGroupModal" data-bs-toggle="modal" class="btn btn-sm btn-outline-primary">Add</a>
                </div>
                <div class="card-body">
                    <?php if(isset($singleServiceGroup) && !empty($singleServiceGroup)): ?>
                    <div class="mb-3">
                        <h6>Edit Service Group</h6>
                        <form method="POST" action="<?= base_url('administrator/posts/context-manager/service-groups/update') ?>" enctype="multipart/form-data">
                            <?= csrf_field() ?>
                            <div class="mb-2">
                                <label class="form-label">Name</label>
                                <input type="text" class="form-control" name="name" value="<?= esc($singleServiceGroup['name']) ?>">
                            </div>
                            <div class="mb-2">
                                <label class="form-label">Description</label>
                                <textarea class="form-control" name="description" style="height:80px"><?= esc($singleServiceGroup['description']) ?></textarea>
                            </div>
                            <div class="mb-2">
                                <label class="form-label">Preview Image</label>
                                <?php if(isset($singleServiceGroup['preview_image']) && !empty($singleServiceGroup['preview_image'])): ?>
                                    <div class="mb-2">
                                        <img src="<?= base_url('media/service-groups/' . $singleServiceGroup['preview_image']) ?>" 
                                             alt="Current preview" 
                                             class="img-thumbnail" 
                                             style="max-height: 100px">
                                    </div>
                                <?php endif; ?>
                                <input type="file" class="form-control" name="preview_image" accept="image/*">
                                <small class="text-muted">Leave empty to keep current image</small>
                            </div>
                            <div class="mb-2">
                                <label class="form-label">Nav Contexts</label>
                                <div>
                                    <?php foreach(($nav_contexts ?? []) as $nc): ?>
                                        <div class="form-check">
                                            <input class="form-check-input" type="checkbox" name="nav_contexts[]" value="<?= $nc['id'] ?>" id="nc-edit-<?= $nc['id'] ?>" <?= (isset($singleServiceGroupNavs) && in_array($nc['id'], $singleServiceGroupNavs)) ? 'checked' : '' ?> >
                                            <label class="form-check-label" for="nc-edit-<?= $nc['id'] ?>"><?= esc($nc['name']) ?></label>
                                        </div>
                                    <?php endforeach; ?>
                                </div>
                            </div>
                            <input type="hidden" name="id" value="<?= $singleServiceGroup['id'] ?>">
                            <button class="btn btn-sm btn-outline-success">Update</button>
                            <a href="<?= base_url('administrator/posts/context-manager') ?>" class="btn btn-sm btn-outline-secondary">Cancel</a>
                        </form>
                    </div>
                    <hr />
                    <?php endif; ?>
                    <ul class="list-group">
                        <?php foreach($service_groups as $sg): ?>
                        <li class="list-group-item d-flex justify-content-between align-items-center">
                            <div>
                                <?= esc($sg['name']) ?>
                                <div class="small text-muted">
                                    <?= esc($sg['slug'] ?? '') ?>
                                </div>
                            </div>
                            <span>
                                <a href="#" 
                                   class="btn btn-sm btn-outline-secondary btn-view-servicegroup"
                                   data-id="<?= $sg['id'] ?>"
                                   data-name="<?= esc($sg['name']) ?>"
                                   data-slug="<?= esc($sg['slug']) ?>"
                                   data-description="<?= esc($sg['description']) ?>"
                                   data-active="<?= $sg['is_active'] ?>"
                                   data-preview="<?= base_url('media/service-groups/' . ($sg['preview_image'] ?? '')) ?>"
                                   data-created="<?= esc($sg['created_at']) ?>"
                                   data-createdby="<?= esc($sg['created_by'] ?? '') ?>"
                                >View</a>
                                <a href="<?= base_url('administrator/posts/context-manager/service-groups/edit/'.$sg['id']) ?>" class="btn btn-sm btn-outline-success">Edit</a>
                                <a href="<?= base_url('administrator/posts/context-manager/service-groups/delete/'.$sg['id']) ?>" class="btn btn-sm btn-outline-danger" onclick="return confirm('Delete this service group?')">Delete</a>
                            </span>
                        </li>
                        <?php endforeach; ?>
                    </ul>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Add Nav Context Modal -->
<div class="modal fade" id="addNavContextModal" tabindex="-1" aria-hidden="true">
  <div class="modal-dialog">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title">Add Nav Context</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
      </div>
      <form method="POST" action="<?= base_url('administrator/posts/context-manager/nav-contexts/add') ?>">
      <div class="modal-body">
            <?= csrf_field() ?>
            <div class="mb-2">
                <label class="form-label">Name</label>
                <input type="text" class="form-control" name="name">
            </div>
            <div class="mb-2">
                <label class="form-label">Description</label>
                <textarea class="form-control" name="description" style="height:80px"></textarea>
            </div>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
        <button type="submit" class="btn btn-primary">Save</button>
      </div>
      </form>
    </div>
  </div>
</div>

<!-- Add Service Group Modal -->
<div class="modal fade" id="addServiceGroupModal" tabindex="-1" aria-hidden="true">
  <div class="modal-dialog">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title">Add Service Group</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
      </div>
      <form method="POST" action="<?= base_url('administrator/posts/context-manager/service-groups/add') ?>" enctype="multipart/form-data">
      <div class="modal-body">
            <?= csrf_field() ?>
            <div class="mb-2">
                <label class="form-label">Name</label>
                <input type="text" class="form-control" name="name">
            </div>
            <div class="mb-2">
                <label class="form-label">Description</label>
                <textarea class="form-control" name="description" style="height:80px"></textarea>
            </div>
            <div class="mb-2">
                <label class="form-label">Preview Image</label>
                <input type="file" class="form-control" name="preview_image" accept="image/*">
                <small class="text-muted">Recommended size: 800x600px</small>
            </div>
            <div class="mb-2">
                <label class="form-label">Nav Contexts</label>
                <div>
                    <?php foreach(($nav_contexts ?? []) as $nc): ?>
                        <div class="form-check">
                            <input class="form-check-input" type="checkbox" name="nav_contexts[]" value="<?= $nc['id'] ?>" id="nc-add-<?= $nc['id'] ?>">
                            <label class="form-check-label" for="nc-add-<?= $nc['id'] ?>"><?= esc($nc['name']) ?></label>
                        </div>
                    <?php endforeach; ?>
                </div>
            </div>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
        <button type="submit" class="btn btn-primary">Save</button>
      </div>
      </form>
    </div>
  </div>
</div>

<!-- View Nav Context Modal -->
<div class="modal fade" id="viewNavContextModal" tabindex="-1" aria-hidden="true">
  <div class="modal-dialog">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title">Nav Context Details</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
      </div>
      <div class="modal-body">
        <dl class="row mb-0">
          <dt class="col-sm-4">Name</dt><dd class="col-sm-8" id="vc-name"></dd>
          <dt class="col-sm-4">Slug</dt><dd class="col-sm-8" id="vc-slug"></dd>
          <dt class="col-sm-4">Description</dt><dd class="col-sm-8" id="vc-description"></dd>
          <dt class="col-sm-4">Active</dt><dd class="col-sm-8" id="vc-active"></dd>
          <dt class="col-sm-4">Created</dt><dd class="col-sm-8" id="vc-created"></dd>
        </dl>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
      </div>
    </div>
  </div>
</div>

<!-- View Service Group Modal -->
<div class="modal fade" id="viewServiceGroupModal" tabindex="-1" aria-hidden="true">
  <div class="modal-dialog modal-lg">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title">Service Group Details</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
      </div>
      <div class="modal-body">
        <div class="row">
          <div class="col-md-8">
            <dl class="row mb-0">
              <dt class="col-sm-4">Name</dt><dd class="col-sm-8" id="sg-name"></dd>
              <dt class="col-sm-4">Slug</dt><dd class="col-sm-8" id="sg-slug"></dd>
              <dt class="col-sm-4">Description</dt><dd class="col-sm-8" id="sg-description"></dd>
              <dt class="col-sm-4">Active</dt><dd class="col-sm-8" id="sg-active"></dd>
              <dt class="col-sm-4">Created</dt><dd class="col-sm-8" id="sg-created"></dd>
              <dt class="col-sm-4">Created By</dt><dd class="col-sm-8" id="sg-createdby"></dd>
            </dl>
          </div>
          <div class="col-md-4 text-center" id="sg-preview-col">
            <img id="sg-preview-img" src="" alt="Preview" class="img-fluid img-thumbnail" style="max-height:180px; display:none;">
          </div>
        </div>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
      </div>
    </div>
  </div>
</div>

<script>
document.addEventListener('DOMContentLoaded', function(){
    // Nav Context view
    document.querySelectorAll('.btn-view-navcontext').forEach(function(btn){
        btn.addEventListener('click', function(e){
            e.preventDefault();
            var name = btn.getAttribute('data-name') || '';
            var slug = btn.getAttribute('data-slug') || '';
            var description = btn.getAttribute('data-description') || '';
            var active = btn.getAttribute('data-active') == '1' ? 'Yes' : 'No';
            var created = btn.getAttribute('data-created') || '';

            document.getElementById('vc-name').textContent = name;
            document.getElementById('vc-slug').textContent = slug;
            document.getElementById('vc-description').textContent = description;
            document.getElementById('vc-active').textContent = active;
            document.getElementById('vc-created').textContent = created;

            var modal = new bootstrap.Modal(document.getElementById('viewNavContextModal'));
            modal.show();
        });
    });

    // Service Group view
    document.querySelectorAll('.btn-view-servicegroup').forEach(function(btn){
        btn.addEventListener('click', function(e){
            e.preventDefault();
            var name = btn.getAttribute('data-name') || '';
            var slug = btn.getAttribute('data-slug') || '';
            var description = btn.getAttribute('data-description') || '';
            var active = btn.getAttribute('data-active') == '1' ? 'Yes' : 'No';
            var preview = btn.getAttribute('data-preview') || '';
            var created = btn.getAttribute('data-created') || '';
            var createdby = btn.getAttribute('data-createdby') || '';

            document.getElementById('sg-name').textContent = name;
            document.getElementById('sg-slug').textContent = slug;
            document.getElementById('sg-description').textContent = description;
            document.getElementById('sg-active').textContent = active;
            document.getElementById('sg-created').textContent = created;
            document.getElementById('sg-createdby').textContent = createdby;

            var img = document.getElementById('sg-preview-img');
            if (preview) {
                img.src = preview;
                img.style.display = 'block';
            } else {
                img.style.display = 'none';
            }

            var modal = new bootstrap.Modal(document.getElementById('viewServiceGroupModal'));
            modal.show();
        });
    });
});
</script>
<?= $this->endSection();?>