<?= $this->extend('Modules\Admin\Views\index'); ?>

<?= $this->section('styles') ?>
<style>
.icon-preview-wrapper {
    display: flex;
    align-items: center;
    gap: 10px;
    position: relative;
    z-index: 1080;
}

.icon-preview {
    width: 40px;
    height: 40px;
    display: flex;
    align-items: center;
    justify-content: center;
    border: 1px solid #dee2e6;
    border-radius: 4px;
    background: #f8f9fa;
}

.icon-picker-container {
    position: absolute;
    top: 100%;
    left: 0;
    z-index: 1070;
    background: white;
    border: 1px solid #dee2e6;
    border-radius: 4px;
    padding: 1rem;
    box-shadow: 0 2px 10px rgba(0,0,0,0.1);
    max-height: 300px;
    overflow-y: auto;
    width: 320px;
    margin-top: 2px;
}

.icon-grid {
    display: grid;
    grid-template-columns: repeat(8, 1fr);
    gap: 8px;
}

.icon-item {
    width: 32px;
    height: 32px;
    display: flex;
    align-items: center;
    justify-content: center;
    border: 1px solid #dee2e6;
    border-radius: 4px;
    cursor: pointer;
    transition: all 0.2s ease-in-out;
}

.icon-item:hover {
    background: #e9ecef;
    border-color: #adb5bd;
    transform: scale(1.1);
}

.icon-item.selected {
    background: #e7f1ff;
    border-color: #0d6efd;
}

.icon-item i {
    font-size: 1rem;
}

/* Fix modal z-index to ensure picker is visible */
.modal {
    z-index: 1050;
}

.modal-backdrop {
    z-index: 1040;
}
</style>

<?= $this->endSection() ?>

<?= $this->section('head') ?>
<!-- CSRF Token -->
<meta name="csrf-token" content="<?= csrf_hash() ?>">
<?= $this->endSection() ?>

<?= $this->section('content'); ?>
<div class="container-fluid">
    <div class="row mb-md-3">
        <div class="col">
            <h4>Content Blocks Management</h4>
            <nav aria-label="breadcrumb"><small>
                <ol class="breadcrumb mb-0">
                    <li class="breadcrumb-item"><a href="<?= base_url('administrator') ?>">Home</a></li>
                    <li class="breadcrumb-item active" aria-current="page">Blocks</li>
                </ol></small>
            </nav>
        </div>
    </div>

    <!-- Messages -->
    <div class="row">
        <div class="col">
            <?php if(session()->getTempdata('success')): ?>
                <div class="alert alert-success" role="alert"><?= session()->getTempdata('success');?></div>
            <?php endif;?>
            <?php if(session()->getTempdata('error')): ?>
                <div class="alert alert-danger" role="alert"><?= session()->getTempdata('error');?></div>
            <?php endif;?>
            <div id="showMsg"></div>
        </div>
    </div>

    <!-- Tabs Navigation -->
    <ul class="nav nav-tabs" id="blocksTabs" role="tablist">
        <li class="nav-item" role="presentation">
            <button class="nav-link <?= ($activeTab === 'definitions' ? 'active' : '') ?>" id="definitions-tab" data-bs-toggle="tab" data-bs-target="#definitions" type="button" role="tab">
                <i class="bi bi-puzzle"></i> Block Definitions
            </button>
        </li>
        <li class="nav-item" role="presentation">
            <button class="nav-link <?= ($activeTab === 'item-types' ? 'active' : '') ?>" id="item-types-tab" data-bs-toggle="tab" data-bs-target="#item-types" type="button" role="tab">
                <i class="bi bi-tags"></i> Item Types
            </button>
        </li>
        <li class="nav-item" role="presentation">
            <button class="nav-link <?= ($activeTab === 'blocks' ? 'active' : '') ?>" id="blocks-tab" data-bs-toggle="tab" data-bs-target="#blocks" type="button" role="tab">
                <i class="bi bi-grid-3x3"></i> Post Blocks
            </button>
        </li>
        <li class="nav-item" role="presentation">
            <button class="nav-link <?= ($activeTab === 'items' ? 'active' : '') ?>" id="items-tab" data-bs-toggle="tab" data-bs-target="#items" type="button" role="tab">
                <i class="bi bi-list-check"></i> Block Items
            </button>
        </li>
    </ul>

    <!-- Tab Content -->
    <div class="tab-content card card-body" id="blocksTabContent">
        
        <!-- BLOCK DEFINITIONS TAB -->
        <div class="tab-pane fade <?= ($activeTab === 'definitions' ? 'show active' : '') ?>" id="definitions" role="tabpanel">
            <div class="d-flex justify-content-between align-items-center mb-3">
                <div>
                    <button class="btn btn-sm btn-success" data-bs-toggle="modal" data-bs-target="#addDefinitionModal">
                        <i class="bi bi-plus"></i> Add Definition
                    </button>
                </div>
                <div class="text-muted">
                    <small>Total: <?= count($blockDefinitions) ?> definitions</small>
                </div>
            </div>
            
            <div class="table-responsive">
                <table id="definitionsTable" class="table table-hover table-sm">
                    <thead class="bg-primary bg-opacity-10">
                        <tr>
                            <th>#</th>
                            <th>Name</th>
                            <th>Slug</th>
                            <th>Category</th>
                            <th>Icon</th>
                            <th>Repeatable</th>
                            <th>Max Instances</th>
                            <th>Status</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php if(isset($blockDefinitions) && count($blockDefinitions) > 0): ?>
                            <?php foreach($blockDefinitions as $def): ?>
                                <tr>
                                    <td><span class="badge bg-info"><?= $def['id'] ?></span></td>
                                    <td>
                                        <strong><?= esc($def['name']) ?></strong>
                                        <?php if(!empty($def['description'])): ?>
                                            <br><small class="text-muted"><?= esc($def['description']) ?></small>
                                        <?php endif; ?>
                                    </td>
                                    <td><code><?= $def['slug'] ?></code></td>
                                    <td><span class="badge bg-secondary"><?= $def['category'] ?></span></td>
                                    <td>
                                        <?php if(!empty($def['icon'])): ?>
                                            <i class="<?= $def['icon'] ?>" title="<?= $def['icon'] ?>"></i>
                                        <?php else: ?>
                                            <i class="bi bi-square text-muted"></i>
                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <?= $def['is_repeatable'] ?
                                            '<span class="badge bg-success">Yes</span>' :
                                            '<span class="badge bg-secondary">No</span>' ?>
                                    </td>
                                    <td>
                                        <?= $def['max_instances'] ?
                                            '<span class="badge bg-info">'.$def['max_instances'].'</span>' :
                                            '<span class="badge bg-light text-dark">Unlimited</span>' ?>
                                    </td>
                                    <td>
                                        <?= $def['is_active'] ?
                                            '<span class="badge bg-success">Active</span>' :
                                            '<span class="badge bg-secondary">Inactive</span>' ?>
                                    </td>
                                    <td>
                                        <div class="btn-group btn-group-sm">
                                            <button class="btn btn-outline-primary edit-definition" 
                                                    data-id="<?= $def['id'] ?>"
                                                    title="Edit Definition">
                                                <i class="bi bi-pencil"></i>
                                            </button>
                                            <button class="btn btn-outline-danger delete-definition" 
                                                    data-id="<?= $def['id'] ?>" 
                                                    data-name="<?= esc($def['name']) ?>"
                                                    title="Delete Definition">
                                                <i class="bi bi-trash"></i>
                                            </button>
                                        </div>
                                    </td>
                                </tr>
                            <?php endforeach; ?>
                        <?php else: ?>
                            <tr>
                                <td colspan="9" class="text-center py-4">
                                    <i class="bi bi-inbox display-4 text-muted"></i>
                                    <p class="mt-2">No block definitions found</p>
                                    <button class="btn btn-sm btn-success mt-2" data-bs-toggle="modal" data-bs-target="#addDefinitionModal">
                                        <i class="bi bi-plus"></i> Add Your First Definition
                                    </button>
                                </td>
                            </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>

        <!-- ITEM TYPES TAB -->
        <div class="tab-pane fade <?= ($activeTab === 'item-types' ? 'show active' : '') ?>" id="item-types" role="tabpanel">
            <div class="d-flex justify-content-between align-items-center mb-3">
                <div>
                    <button class="btn btn-sm btn-success" data-bs-toggle="modal" data-bs-target="#addItemTypeModal">
                        <i class="bi bi-plus"></i> Add Item Type
                    </button>
                </div>
                <div class="text-muted">
                    <small>Total: <?= count($itemTypeDefinitions ?? []) ?> item types</small>
                </div>
            </div>
            
            <div class="table-responsive">
                <table id="itemTypesTable" class="table table-hover table-sm">
                    <thead class="bg-primary bg-opacity-10">
                        <tr>
                            <th>#</th>
                            <th>Name</th>
                            <th>Slug</th>
                            <th>Description</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php if(isset($itemTypeDefinitions) && count($itemTypeDefinitions) > 0): ?>
                            <?php foreach($itemTypeDefinitions as $itemType): ?>
                                <tr>
                                    <td><span class="badge bg-info"><?= $itemType['id'] ?></span></td>
                                    <td><strong><?= esc($itemType['name']) ?></strong></td>
                                    <td><code><?= $itemType['slug'] ?></code></td>
                                    <td><?= esc($itemType['description'] ?? '-') ?></td>
                                    <td>
                                        <div class="btn-group btn-group-sm">
                                            <button type="button" class="btn btn-outline-info view-item-type"
                                                    data-id="<?= $itemType['id'] ?>"
                                                    title="View Item Type">
                                                <i class="bi bi-eye"></i>
                                            </button>
                                            <button class="btn btn-outline-primary edit-item-type"
                                                    data-id="<?= $itemType['id'] ?>"
                                                    title="Edit Item Type">
                                                <i class="bi bi-pencil"></i>
                                            </button>
                                            <button class="btn btn-outline-danger delete-item-type"
                                                    data-id="<?= $itemType['id'] ?>"
                                                    data-name="<?= esc($itemType['name']) ?>"
                                                    title="Delete Item Type">
                                                <i class="bi bi-trash"></i>
                                            </button>
                                        </div>
                                    </td>
                                </tr>
                            <?php endforeach; ?>
                        <?php else: ?>
                            <tr>
                                <td colspan="5" class="text-center py-4">
                                    <i class="bi bi-tags display-4 text-muted"></i>
                                    <p class="mt-2">No item types found</p>
                                    <button class="btn btn-sm btn-success mt-2" data-bs-toggle="modal" data-bs-target="#addItemTypeModal">
                                        <i class="bi bi-plus"></i> Add Your First Item Type
                                    </button>
                                </td>
                            </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>

        <!-- POST BLOCKS TAB -->
        <div class="tab-pane fade <?= ($activeTab === 'blocks' ? 'show active' : '') ?>" id="blocks" role="tabpanel">
            <div class="row mb-3">
                <div class="col-md-4">
                    <label class="form-label">Filter by Post</label>
                    <select class="form-select" id="filterByPost">
                        <option value="">All Posts</option>
                        <?php if(isset($allPosts)): ?>
                            <?php foreach($allPosts as $post): ?>
                                <option value="<?= $post['id'] ?>"><?= esc($post['title']) ?></option>
                            <?php endforeach; ?>
                        <?php endif; ?>
                    </select>
                </div>
                <div class="col-md-4">
                    <label class="form-label">Filter by Status</label>
                    <select class="form-select" id="filterByStatus">
                        <option value="">All Status</option>
                        <option value="active">Active</option>
                        <option value="inactive">Inactive</option>
                    </select>
                </div>
                <div class="col-md-4 d-flex align-items-end">
                    <button class="btn btn-sm btn-success add-block" data-post-id="">
                        <i class="bi bi-plus"></i> Add Block to Post
                    </button>
                </div>
            </div>
            
            <div class="table-responsive">
                <table id="blocksTable" class="table table-hover table-sm">
                    <thead class="bg-primary bg-opacity-10">
                        <tr>
                            <th>#</th>
                            <th>Post</th>
                            <th>Block Type</th>
                            <th>Category</th>
                            <th>Heading</th>
                            <th>Order</th>
                            <th>Items</th>
                            <th>Status</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php if(isset($postBlocks) && count($postBlocks) > 0): ?>
                            <?php foreach($postBlocks as $block): ?>
                                <tr>
                                    <td><span class="badge bg-info"><?= $block->id ?></span></td>
                                    <td>
                                        <div class="d-flex align-items-center">
                                            <div>
                                                <strong class="d-block"><?= esc($block->post_title ?? 'N/A') ?></strong>
                                                <small class="text-muted">ID: <?= $block->post_id ?></small>
                                            </div>
                                        </div>
                                    </td>
                                    <td>
                                        <code><?= $block->block_type ?></code>
                                        <?php 
                                        // Get definition name if available
                                        $defName = '';
                                        if(isset($blockDefinitions)) {
                                            foreach($blockDefinitions as $def) {
                                                if($def['slug'] == $block->block_type) {
                                                    $defName = $def['name'];
                                                    break;
                                                }
                                            }
                                        }
                                        if($defName): ?>
                                            <br><small class="text-muted"><?= esc($defName) ?></small>
                                        <?php endif; ?>
                                    </td>
                                    <td><span class="badge bg-secondary"><?= $block->block_cat ?></span></td>
                                    <td><?= esc($block->heading ?? '-') ?></td>
                                    <td>
                                        <span class="badge bg-primary"><?= $block->ordering ?></span>
                                        <button class="btn btn-sm btn-outline-secondary ms-1 change-order" 
                                                data-id="<?= $block->id ?>" 
                                                data-current="<?= $block->ordering ?>"
                                                title="Change Order">
                                            <i class="bi bi-arrow-up-down"></i>
                                        </button>
                                    </td>
                                    <td>
                                        <span class="badge bg-success"><?= $block->items_count ?? 0 ?></span>
                                        <?php if(($block->items_count ?? 0) > 0): ?>
                                            <button class="btn btn-sm btn-outline-info ms-1 view-items" 
                                                    data-block-id="<?= $block->id ?>"
                                                    title="View Items">
                                                <i class="bi bi-list"></i>
                                            </button>
                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <?= ($block->status == 'active') ? 
                                            '<span class="badge bg-success">Active</span>' : 
                                            '<span class="badge bg-secondary">Inactive</span>' ?>
                                    </td>
                                    <td>
                                        <div class="btn-group btn-group-sm">
                                            <button type="button" 
                                               class="btn btn-outline-info view-block" 
                                               data-id="<?= $block->id ?>" 
                                               title="View Block">
                                                <i class="bi bi-eye"></i>
                                            </button>
                                            <button class="btn btn-outline-primary edit-block" 
                                                    data-id="<?= $block->id ?>"
                                                    title="Edit Block">
                                                <i class="bi bi-pencil"></i>
                                            </button>
                                            <button class="btn btn-outline-success add-item" 
                                                    data-block-id="<?= $block->id ?>"
                                                    data-block-type="<?= $block->block_type ?>"
                                                    title="Add Item">
                                                <i class="bi bi-plus-circle"></i>
                                            </button>
                                            <button class="btn btn-outline-danger delete-block" 
                                                    data-id="<?= $block->id ?>" 
                                                    data-title="<?= esc($block->post_title ?? 'Block') ?>"
                                                    title="Delete Block">
                                                <i class="bi bi-trash"></i>
                                            </button>
                                        </div>
                                    </td>
                                </tr>
                            <?php endforeach; ?>
                        <?php else: ?>
                            <tr>
                                <td colspan="9" class="text-center py-4">
                                    <i class="bi bi-inbox display-4 text-muted"></i>
                                    <p class="mt-2">No post blocks found</p>
                                    <button class="btn btn-sm btn-success mt-2 add-block" data-post-id="">
                                        <i class="bi bi-plus"></i> Add Your First Block
                                    </button>
                                </td>
                            </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>

        <!-- BLOCK ITEMS TAB -->
        <div class="tab-pane fade <?= ($activeTab === 'items' ? 'show active' : '') ?>" id="items" role="tabpanel">
            <div class="row mb-3">
                <div class="col-md-4">
                    <label class="form-label">Filter by Block</label>
                    <select class="form-select" id="filterByBlock">
                        <option value="">All Blocks</option>
                        <?php if(isset($postBlocks)): ?>
                            <?php foreach($postBlocks as $block): ?>
                                <option value="<?= $block->id ?>">
                                    Block #<?= $block->id ?> - <?= $block->block_type ?>
                                    <?php if(isset($block->post_title)): ?>
                                        (<?= esc($block->post_title) ?>)
                                    <?php endif; ?>
                                </option>
                            <?php endforeach; ?>
                        <?php endif; ?>
                    </select>
                </div>
                <div class="col-md-4">
                    <label class="form-label">Filter by Type</label>
                    <select class="form-select" id="filterByType">
                        <option value="">All Types</option>
                        <option value="cards">Cards</option>
                        <option value="text">Text</option>
                        <option value="image">Image</option>
                        <option value="code">Code</option>
                    </select>
                </div>
                <div class="col-md-4 d-flex align-items-end">
                    <button class="btn btn-sm btn-success" id="addItemBtn">
                        <i class="bi bi-plus"></i> Add New Item
                    </button>
                </div>
            </div>
            
            <div class="table-responsive">
                <table id="itemsTable" class="table table-hover table-sm">
                    <thead class="bg-primary bg-opacity-10">
                        <tr>
                            <th>#</th>
                            <th>Block</th>
                            <th>Type</th>
                            <th>Title</th>
                            <th>Icon</th>
                            <th>Order</th>
                            <th>Status</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php if(isset($blockItems) && count($blockItems) > 0): ?>
                            <?php foreach($blockItems as $item): ?>
                                <tr>
                                    <td><span class="badge bg-info"><?= $item['id'] ?></span></td>
                                    <td>
                                        <span class="badge bg-secondary">#<?= $item['block_id'] ?></span>
                                        <?php 
                                        // Get block type for display
                                        $blockType = '';
                                        if(isset($postBlocks)) {
                                            foreach($postBlocks as $block) {
                                                if($block->id == $item['block_id']) {
                                                    $blockType = $block->block_type;
                                                    break;
                                                }
                                            }
                                        }
                                        if($blockType): ?>
                                            <br><small class="text-muted"><?= $blockType ?></small>
                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <code><?= $item['item_type'] ?></code>
                                    </td>
                                    <td>
                                        <?= esc($item['title'] ?? '-') ?>
                                        <?php if(!empty($item['description'])): ?>
                                            <br><small class="text-muted"><?= esc(substr($item['description'], 0, 50)) ?>...</small>
                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <?php if(!empty($item['icon'])): ?>
                                            <i class="<?= $item['icon'] ?>" title="<?= $item['icon'] ?>"></i>
                                        <?php else: ?>
                                            <span class="text-muted">-</span>
                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <span class="badge bg-primary"><?= $item['ordering'] ?? 0 ?></span>
                                        <button class="btn btn-sm btn-outline-secondary ms-1 change-item-order" 
                                                data-id="<?= $item['id'] ?>" 
                                                data-current="<?= $item['ordering'] ?? 0 ?>"
                                                title="Change Order">
                                            <i class="bi bi-arrow-up-down"></i>
                                        </button>
                                    </td>
                                    <td>
                                        <?= ($item['status'] == 'active') ? 
                                            '<span class="badge bg-success">Active</span>' : 
                                            '<span class="badge bg-secondary">Inactive</span>' ?>
                                    </td>
                                    <td>
                                        <div class="btn-group btn-group-sm">
                                            <button class="btn btn-outline-primary edit-item" 
                                                    data-id="<?= $item['id'] ?>"
                                                    title="Edit Item">
                                                <i class="bi bi-pencil"></i>
                                            </button>
                                            <button class="btn btn-outline-info view-item" 
                                                    data-id="<?= $item['id'] ?>"
                                                    title="View Details">
                                                <i class="bi bi-eye"></i>
                                            </button>
                                            <button class="btn btn-outline-danger delete-item" 
                                                    data-id="<?= $item['id'] ?>" 
                                                    data-title="<?= esc($item['title'] ?? 'Item') ?>"
                                                    title="Delete Item">
                                                <i class="bi bi-trash"></i>
                                            </button>
                                        </div>
                                    </td>
                                </tr>
                            <?php endforeach; ?>
                        <?php else: ?>
                            <tr>
                                <td colspan="8" class="text-center py-4">
                                    <i class="bi bi-inbox display-4 text-muted"></i>
                                    <p class="mt-2">No block items found</p>
                                    <button class="btn btn-sm btn-success mt-2" id="addItemBtn">
                                        <i class="bi bi-plus"></i> Add Your First Item
                                    </button>
                                </td>
                            </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>

<!-- Add Definition Modal -->
<div class="modal fade" id="addDefinitionModal" tabindex="-1">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Add Block Definition</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <form id="addDefinitionForm" method="POST" action="<?= base_url('administrator/posts/blocks/definition/add') ?>">
                <?= csrf_field() ?>
                <div class="modal-body">
                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <label class="form-label">Name <span class="text-danger">*</span></label>
                            <input type="text" class="form-control" name="name" required>
                            <div class="form-text">The display name for this block type</div>
                        </div>
                        <div class="col-md-6 mb-3">
                            <label class="form-label">Slug <span class="text-danger">*</span></label>
                            <input type="text" class="form-control" name="slug"  required>
                            <div class="form-text">Unique identifier used in code (auto-generated)</div>
                        </div>
                        <div class="col-md-6 mb-3">
                            <label class="form-label">Category</label>
                            <select class="form-select" name="category">
                                <?php if(isset($serviceGroups) && !empty($serviceGroups)): ?>
                                    <?php foreach($serviceGroups as $sg): ?>
                                        <option value="<?= esc($sg['slug']) ?>"><?= esc($sg['name']) ?></option>
                                    <?php endforeach; ?>
                                <?php endif; ?>
                            </select>
                        </div>
                        <div class="col-md-6 mb-3">
                            <label class="form-label">Icon</label>
                            <div class="icon-preview-wrapper">
                                <span id="addIconPreview" class="icon-preview"><i class="bi bi-square"></i></span>
                                <input type="hidden" name="icon" id="addDefinitionIcon">
                                <button type="button" class="btn btn-sm btn-outline-secondary" id="showAddIconPicker">Select Icon</button>
                                <div id="addIconPickerContainer" class="icon-picker-container" style="display: none;">
                                    <!-- Icons will be populated by JavaScript -->
                                </div>
                            </div>
                        </div>
                        <div class="col-12 mb-3">
                            <label class="form-label">Description</label>
                            <textarea class="form-control" name="description" rows="2" placeholder="Brief description of this block type"></textarea>
                        </div>
                        <div class="col-md-4 mb-3">
                            <label class="form-label">Repeatable</label>
                            <select class="form-select" name="is_repeatable">
                                <option value="1">Yes - Multiple instances allowed</option>
                                <option value="0">No - Single instance only</option>
                            </select>
                        </div>
                        <div class="col-md-4 mb-3">
                            <label class="form-label">Max Instances</label>
                            <input type="number" class="form-control" name="max_instances" min="0" placeholder="Leave empty for unlimited">
                        </div>
                        <div class="col-md-4 mb-3">
                            <label class="form-label">Status</label>
                            <select class="form-select" name="is_active">
                                <option value="1">Active</option>
                                <option value="0">Inactive</option>
                            </select>
                        </div>
                        <div class="col-12 mb-3">
                            <label class="form-label">Allowed Item Types</label>
                            <div class="row g-2" id="addItemTypesCheckboxes">
                                <?php if(isset($availableItemTypes) && !empty($availableItemTypes)): ?>
                                    <?php foreach($availableItemTypes as $itemType): ?>
                                        <div class="col-md-4 col-sm-6 col-12">
                                            <div class="form-check form-check-inline">
                                                <input class="form-check-input" type="checkbox" name="item_types[]" id="addItemType_<?= esc($itemType['id']) ?>" value="<?= esc($itemType['id']) ?>">
                                                <label class="form-check-label" for="addItemType_<?= esc($itemType['id']) ?>"><?= esc($itemType['name']) ?></label>
                                            </div>
                                        </div>
                                    <?php endforeach; ?>
                                <?php endif; ?>
                            </div>
                            <div class="form-text">Select item types allowed within this block definition.</div>
                         </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                    <button type="submit" class="btn btn-primary">
                        <i class="bi bi-plus-circle"></i> Create Definition
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Edit Definition Modal -->
<div class="modal fade" id="editDefinitionModal" tabindex="-1" role="dialog" aria-modal="true" aria-labelledby="editDefinitionModalTitle">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="editDefinitionModalTitle">Edit Block Definition</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <form id="editDefinitionForm" method="POST" action="<?= base_url('administrator/posts/blocks/definition/update') ?>">
                <?= csrf_field() ?>
                <input type="hidden" name="id">
                <div class="modal-body">
                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <label class="form-label">Name <span class="text-danger">*</span></label>
                            <input type="text" class="form-control" name="name" required>
                            <div class="form-text">The display name for this block type</div>
                        </div>
                        <div class="col-md-6 mb-3">
                            <label class="form-label">Slug <span class="text-danger">*</span></label>
                            <input type="text" class="form-control" name="slug" required>
                            <div class="form-text">Unique identifier used in code (auto-generated)</div>
                        </div>
                        <div class="col-md-6 mb-3">
                            <label class="form-label">Category</label>
                            <select class="form-select" name="category">
                                <?php if(isset($serviceGroups) && !empty($serviceGroups)): ?>
                                    <?php foreach($serviceGroups as $sg): ?>
                                        <option value="<?= esc($sg['slug']) ?>"><?= esc($sg['name']) ?></option>
                                    <?php endforeach; ?>
                                <?php endif; ?>
                            </select>
                        </div>
                        <div class="col-md-6 mb-3">
                            <label class="form-label">Icon</label>
                            <div class="icon-preview-wrapper">
                                <span id="editIconPreview" class="icon-preview"><i class="bi bi-square"></i></span>
                                <input type="hidden" name="icon" id="editDefinitionIcon">
                                <button type="button" class="btn btn-sm btn-outline-secondary" id="showEditIconPicker">Select Icon</button>
                                <div id="editIconPickerContainer" class="icon-picker-container" style="display: none;">
                                    <!-- Icons will be populated by JavaScript -->
                                </div>
                            </div>
                        </div>
                        <div class="col-12 mb-3">
                            <label class="form-label">Description</label>
                            <textarea class="form-control" name="description" rows="2" placeholder="Brief description of this block type"></textarea>
                        </div>
                        <div class="col-md-4 mb-3">
                            <label class="form-label">Repeatable</label>
                            <select class="form-select" name="is_repeatable">
                                <option value="1">Yes - Multiple instances allowed</option>
                                <option value="0">No - Single instance only</option>
                            </select>
                        </div>
                        <div class="col-md-4 mb-3">
                            <label class="form-label">Max Instances</label>
                            <input type="number" class="form-control" name="max_instances" min="0" placeholder="Leave empty for unlimited">
                        </div>
                        <div class="col-md-4 mb-3">
                            <label class="form-label">Status</label>
                            <select class="form-select" name="is_active">
                                <option value="1">Active</option>
                                <option value="0">Inactive</option>
                            </select>
                        </div>
                        <div class="col-12 mb-3">
                            <label class="form-label">Allowed Item Types</label>
                            <div class="row g-2" id="editItemTypesCheckboxes">
                                <?php if(isset($availableItemTypes) && !empty($availableItemTypes)): ?>
                                    <?php foreach($availableItemTypes as $itemType): ?>
                                        <div class="col-md-4 col-sm-6 col-12">
                                            <div class="form-check form-check-inline">
                                                <input class="form-check-input" type="checkbox" name="item_types[]" id="editItemType_<?= esc($itemType['id']) ?>" value="<?= esc($itemType['id']) ?>">
                                                <label class="form-check-label" for="editItemType_<?= esc($itemType['id']) ?>"><?= esc($itemType['name']) ?></label>
                                            </div>
                                        </div>
                                    <?php endforeach; ?>
                                <?php endif; ?>
                            </div>
                            <div class="form-text">Select item types allowed within this block definition.</div>
                         </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                    <button type="submit" class="btn btn-primary">
                        <i class="bi bi-check-circle"></i> Update Definition
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Add Item Type Modal -->
<div class="modal fade" id="addItemTypeModal" tabindex="-1" role="dialog" aria-modal="true" aria-labelledby="addItemTypeModalTitle">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="addItemTypeModalTitle">Add Item Type Definition</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <form id="addItemTypeForm" method="POST" action="<?= base_url('administrator/posts/blocks/item-type/add') ?>">
                <?= csrf_field() ?>
                <div class="modal-body">
                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <label class="form-label">Name <span class="text-danger">*</span></label>
                            <input type="text" class="form-control" name="name" required>
                            <div class="form-text">The display name for this item type</div>
                        </div>
                        <div class="col-md-6 mb-3">
                            <label class="form-label">Slug <span class="text-danger">*</span></label>
                            <input type="text" class="form-control" name="slug" required>
                            <div class="form-text">Unique identifier used in code (auto-generated)</div>
                        </div>
                        <div class="col-12 mb-3">
                            <label class="form-label">Description</label>
                            <textarea class="form-control" name="description" rows="2" placeholder="Brief description of this item type"></textarea>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                    <button type="submit" class="btn btn-primary">
                        <i class="bi bi-plus-circle"></i> Create Item Type
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Edit Item Type Modal -->
<div class="modal fade" id="editItemTypeModal" tabindex="-1">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Edit Item Type Definition</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <form id="editItemTypeForm" method="POST" action="<?= base_url('administrator/posts/blocks/item-type/update') ?>">
                <?= csrf_field() ?>
                <input type="hidden" name="id">
                <div class="modal-body">
                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <label class="form-label">Name <span class="text-danger">*</span></label>
                            <input type="text" class="form-control" name="name" required>
                            <div class="form-text">The display name for this item type</div>
                        </div>
                        <div class="col-md-6 mb-3">
                            <label class="form-label">Slug <span class="text-danger">*</span></label>
                            <input type="text" class="form-control" name="slug" required>
                            <div class="form-text">Unique identifier used in code (auto-generated)</div>
                        </div>
                        <div class="col-12 mb-3">
                            <label class="form-label">Description</label>
                            <textarea class="form-control" name="description" rows="2" placeholder="Brief description of this item type"></textarea>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                    <button type="submit" class="btn btn-primary">
                        <i class="bi bi-check-circle"></i> Update Item Type
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- View Item Type Modal -->
<div class="modal fade" id="viewItemTypeModal" tabindex="-1">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">View Item Type Definition</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <div class="row">
                    <div class="col-md-6">
                        <h6 class="border-bottom pb-2">Item Type Information</h6>
                        <table class="table table-sm">
                            <tr>
                                <th width="30%">ID</th>
                                <td id="viewItemTypeId"></td>
                            </tr>
                            <tr>
                                <th>Name</th>
                                <td id="viewItemTypeName"></td>
                            </tr>
                            <tr>
                                <th>Slug</th>
                                <td><code id="viewItemTypeSlug"></code></td>
                            </tr>
                            <tr>
                                <th>Description</th>
                                <td id="viewItemTypeDescription"></td>
                            </tr>
                            <tr>
                                <th>Created</th>
                                <td id="viewItemTypeCreated"></td>
                            </tr>
                            <tr>
                                <th>Updated</th>
                                <td id="viewItemTypeUpdated"></td>
                            </tr>
                        </table>
                    </div>
                    <div class="col-md-6">
                        <h6 class="border-bottom pb-2">Configuration</h6>
                        <div id="viewItemTypeConfig">
                            <!-- Configuration details will be loaded here -->
                        </div>
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                <button type="button" class="btn btn-primary edit-item-type-btn">
                    <i class="bi bi-pencil"></i> Edit Item Type
                </button>
            </div>
        </div>
    </div>
</div>

<!-- Add Block Modal -->
<div class="modal fade" id="addBlockModal" tabindex="-1">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Add Block to Post</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <form id="addBlockForm" method="POST">
                <?= csrf_field() ?>
                <input type="hidden" name="post_id">
                <div class="modal-body">
                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <label class="form-label">Post <span class="text-danger">*</span></label>
                            <select class="form-select" name="post_id" required>
                                <option value="">Select a Post</option>
                                <?php if(isset($allPosts)): ?>
                                    <?php foreach($allPosts as $post): ?>
                                        <option value="<?= $post['id'] ?>"><?= esc($post['title']) ?></option>
                                    <?php endforeach; ?>
                                <?php endif; ?>
                            </select>
                        </div>
                        <div class="col-md-6 mb-3">
                            <label class="form-label">Block Definition <span class="text-danger">*</span></label>
                            <select class="form-select" name="definition_id" required>
                                <option value="">Select Definition</option>
                                <!-- Will be populated dynamically -->
                            </select>
                        </div>
                        <div class="col-md-6 mb-3">
                            <label class="form-label">Category</label>
                            <select class="form-select" name="block_cat">
                                <option value="content">Content</option>
                                <option value="header">Header</option>
                                <option value="footer">Footer</option>
                                <option value="sidebar">Sidebar</option>
                                <option value="navigation">Navigation</option>
                            </select>
                        </div>
                        <div class="col-md-6 mb-3">
                            <label class="form-label">Heading</label>
                            <input type="text" class="form-control" name="heading" placeholder="Optional block heading">
                        </div>
                        <div class="col-md-6 mb-3">
                            <label class="form-label">Order</label>
                            <input type="number" class="form-control" name="ordering" value="0" min="0">
                        </div>
                        <div class="col-md-6 mb-3">
                            <label class="form-label">Status</label>
                            <select class="form-select" name="status">
                                <option value="active">Active</option>
                                <option value="inactive">Inactive</option>
                            </select>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                    <button type="submit" class="btn btn-primary">
                        <i class="bi bi-plus-circle"></i> Add Block
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Edit Block Modal -->
<div class="modal fade" id="editBlockModal" tabindex="-1">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Edit Block</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <form id="editBlockForm" method="POST">
                <?= csrf_field() ?>
                <input type="hidden" name="id">
                <div class="modal-body">
                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <label class="form-label">Category</label>
                            <select class="form-select" name="block_cat">
                                <option value="content">Content</option>
                                <option value="header">Header</option>
                                <option value="footer">Footer</option>
                                <option value="sidebar">Sidebar</option>
                                <option value="navigation">Navigation</option>
                            </select>
                        </div>
                        <div class="col-md-6 mb-3">
                            <label class="form-label">Heading</label>
                            <input type="text" class="form-control" name="heading" placeholder="Optional block heading">
                        </div>
                        <div class="col-md-6 mb-3">
                            <label class="form-label">Order</label>
                            <input type="number" class="form-control" name="ordering" min="0">
                        </div>
                        <div class="col-md-6 mb-3">
                            <label class="form-label">Status</label>
                            <select class="form-select" name="status">
                                <option value="active">Active</option>
                                <option value="inactive">Inactive</option>
                            </select>
                        </div>
                        <div class="col-12 mb-3">
                            <label class="form-label">Content</label>
                            <textarea class="form-control" name="content" rows="4" placeholder="Block content (if applicable)"></textarea>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                    <button type="submit" class="btn btn-primary">
                        <i class="bi bi-check-circle"></i> Update Block
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Add/Edit Item Modal -->
<div class="modal fade" id="itemModal" tabindex="-1">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Add Block Item</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <form id="itemForm" method="POST">
                <?= csrf_field() ?>
                <input type="hidden" name="id">
                <input type="hidden" name="block_id">
                <div class="modal-body">
                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <label class="form-label">Block <span class="text-danger">*</span></label>
                            <select class="form-select" name="block_id" required>
                                <option value="">Select Block</option>
                                <?php if(isset($postBlocks)): ?>
                                    <?php foreach($postBlocks as $block): ?>
                                        <option value="<?= $block->id ?>" data-type="<?= $block->block_type ?>">
                                            #<?= $block->id ?> - <?= $block->block_type ?>
                                            (<?= esc($block->post_title ?? 'N/A') ?>)
                                        </option>
                                    <?php endforeach; ?>
                                <?php endif; ?>
                            </select>
                            <div class="form-text">Select the block to add an item to</div>
                        </div>
                        <div class="col-md-6 mb-3">
                            <label class="form-label">Item Type <span class="text-danger">*</span></label>
                            <select class="form-select" name="item_type" required>
                                <option value="">Select Item Type</option>
                                <?php if(isset($availableItemTypes)): ?>
                                    <?php foreach($availableItemTypes as $type): ?>
                                        <option value="<?= $type['slug'] ?>" 
                                                data-description="<?= esc($type['description']) ?>"
                                                data-icon="<?= esc($type['icon']) ?>"
                                                data-fields="<?= esc($type['fields_config']) ?>"
                                                data-settings="<?= esc($type['settings_config']) ?>">
                                            <?= esc($type['name']) ?>
                                        </option>
                                    <?php endforeach; ?>
                                <?php endif; ?>
                            </select>
                            <div class="form-text">Available item types based on block definition</div>
                        </div>
                        <div class="col-12 mb-3">
                            <label class="form-label">Title <span class="text-danger">*</span></label>
                            <input type="text" class="form-control" name="title" required placeholder="Item title">
                            <div class="form-text">A descriptive title for this item</div>
                        </div>
                        <div class="col-md-6 mb-3">
                            <label class="form-label">Icon</label>
                            <div class="icon-preview-wrapper">
                                <span class="icon-preview item-icon-preview"><i class="bi bi-square"></i></span>
                                <input type="hidden" name="icon" class="item-icon-input">
                                <button type="button" class="btn btn-sm btn-outline-secondary show-item-icon-picker">Select Icon</button>
                                <div class="icon-picker-container item-icon-picker" style="display: none;">
                                    <!-- Icons will be populated by JavaScript -->
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6 mb-3">
                            <label class="form-label">Link</label>
                            <input type="url" class="form-control" name="link" placeholder="https://example.com">
                            <div class="form-text">Optional link for this item</div>
                        </div>
                        <div class="col-12 mb-3">
                            <label class="form-label">Description</label>
                            <textarea class="form-control" name="description" rows="3" placeholder="Item description"></textarea>
                            <div class="form-text">Additional details about this item</div>
                        </div>
                        <div class="col-md-4 mb-3">
                            <label class="form-label">Order</label>
                            <input type="number" class="form-control" name="ordering" value="0" min="0">
                            <div class="form-text">Display order within the block</div>
                        </div>
                        <div class="col-md-4 mb-3">
                            <label class="form-label">Width</label>
                            <input type="text" class="form-control" name="width" placeholder="e.g., 100%, 300px">
                            <div class="form-text">CSS width value (optional)</div>
                        </div>
                        <div class="col-md-4 mb-3">
                            <label class="form-label">Status</label>
                            <select class="form-select" name="status">
                                <option value="active">Active</option>
                                <option value="inactive">Inactive</option>
                            </select>
                        </div>
                        <div id="dynamicFields" class="col-12">
                            <!-- Dynamic fields based on item type will be inserted here -->
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                    <button type="submit" class="btn btn-primary">
                        <i class="bi bi-check-circle"></i> Save Item
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Change Order Modal -->
<div class="modal fade" id="changeOrderModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Change Order</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <form id="changeOrderForm" method="POST">
                <?= csrf_field() ?>
                <input type="hidden" name="id">
                <input type="hidden" name="type"> <!-- block or item -->
                <div class="modal-body">
                    <div class="mb-3">
                        <label class="form-label">New Order Position</label>
                        <input type="number" class="form-control" name="ordering" min="0" required>
                        <div class="form-text">Lower numbers appear first</div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                    <button type="submit" class="btn btn-primary">Update Order</button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- View Block Details Modal -->
<div class="modal fade" id="viewBlockModal" tabindex="-1">
    <div class="modal-dialog modal-xl">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Block Details</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <div class="row">
                    <div class="col-md-6">
                        <h6 class="border-bottom pb-2">Block Information</h6>
                        <table class="table table-sm">
                            <tr>
                                <th width="30%">Post</th>
                                <td id="blockPostTitle"></td>
                            </tr>
                            <tr>
                                <th>Block Type</th>
                                <td><code id="blockType"></code></td>
                            </tr>
                            <tr>
                                <th>Definition</th>
                                <td>
                                    <span id="blockDefinitionName"></span>
                                    <small id="blockDefinitionDesc" class="text-muted d-block"></small>
                                </td>
                            </tr>
                            <tr>
                                <th>Category</th>
                                <td><span id="blockCategory" class="badge"></span></td>
                            </tr>
                            <tr>
                                <th>Heading</th>
                                <td id="blockHeading"></td>
                            </tr>
                            <tr>
                                <th>Order</th>
                                <td id="blockOrder"></td>
                            </tr>
                            <tr>
                                <th>Status</th>
                                <td id="blockStatus"></td>
                            </tr>
                        </table>
                    </div>
                    <div class="col-md-6">
                        <h6 class="border-bottom pb-2">Block Items</h6>
                        <div id="blockItemsContainer">
                            <!-- Items will be loaded here -->
                        </div>
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                <button type="button" class="btn btn-primary edit-block-btn">
                    <i class="bi bi-pencil"></i> Edit Block
                </button>
            </div>
        </div>
    </div>
</div>

<!-- View Items Modal -->
<div class="modal fade" id="viewItemsModal" tabindex="-1">
    <div class="modal-dialog modal-xl">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Block Items</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <div id="itemsListContainer">
                    <!-- Items will be loaded here via AJAX -->
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
            </div>
        </div>
    </div>
</div>

<!-- Load item manager scripts -->
<script>
// Initialize item manager functionality
const ItemTypeManager = {
    init: function() {
        this.bindEvents();
        this.initItemTypeHandlers();
        this.initItemIconPicker();
    },

    initItemIconPicker: function() {
        // Handle icon picker for items
        $(document).on('click', '.show-item-icon-picker', function(e) {
            e.preventDefault();
            e.stopPropagation();
            const container = $(this).closest('.icon-preview-wrapper').find('.icon-picker-container');

            // Create and populate the icon grid if it doesn't exist
            if (!container.find('.icon-grid').length) {
                let iconGridHtml = '<div class="icon-grid">';
                [
                    { class: 'bi bi-grid', name: 'Grid' },
                    { class: 'bi bi-layout-text-window-reverse', name: 'Text Window' },
                    { class: 'bi bi-image', name: 'Image' },
                    { class: 'bi bi-card-text', name: 'Card Text' },
                    { class: 'bi bi-file-code', name: 'Code' },
                    { class: 'bi bi-list', name: 'List' },
                    { class: 'bi bi-table', name: 'Table' },
                    { class: 'bi bi-calendar', name: 'Calendar' },
                    { class: 'bi bi-person', name: 'Person' },
                    { class: 'bi bi-people', name: 'People' },
                    { class: 'bi bi-gear', name: 'Gear' },
                    { class: 'bi bi-tools', name: 'Tools' },
                    { class: 'bi bi-info-circle', name: 'Info Circle' },
                    { class: 'bi bi-check-circle', name: 'Check Circle' },
                    { class: 'bi bi-x-circle', name: 'X Circle' },
                    { class: 'bi bi-exclamation-triangle', name: 'Warning' },
                    { class: 'bi bi-question-circle', name: 'Question' },
                    { class: 'bi bi-folder', name: 'Folder' },
                    { class: 'bi bi-file-earmark', name: 'File' },
                    { class: 'bi bi-link-45deg', name: 'Link' },
                ].forEach(icon => {
                    iconGridHtml += `<div class="icon-item" data-icon-class="${icon.class}" title="${icon.name}">
                                    <i class="${icon.class}"></i>
                                 </div>`;
                });
                iconGridHtml += '</div>';
                container.html(iconGridHtml);
            }

            // Close other open icon pickers
            $('.icon-picker-container').not(container).slideUp();
            container.slideToggle();
        });

        // Handle icon selection for items
        $(document).on('click', '.item-icon-picker .icon-item', function(e) {
            e.preventDefault();
            e.stopPropagation();
            const iconClass = $(this).data('icon-class');
            const wrapper = $(this).closest('.icon-preview-wrapper');

            wrapper.find('.item-icon-input').val(iconClass);
            wrapper.find('.item-icon-preview').html(`<i class="${iconClass}"></i>`);

            // Update visual state
            $(this).closest('.icon-picker-container').find('.icon-item').removeClass('selected');
            $(this).addClass('selected');
            $(this).closest('.icon-picker-container').slideUp();
        });
    },

    bindEvents: function() {
        // Handle item type change
        $('#itemForm [name="item_type"]').on('change', function() {
            const selectedOption = $(this).find(':selected');
            const description = selectedOption.data('description') || '';
            const icon = selectedOption.data('icon') || '';
            const fields = selectedOption.data('fields');
            const settings = selectedOption.data('settings');

            // Update fields based on selection
            ItemTypeManager.updateDynamicFields(fields, settings);
        });

        // Close icon pickers when clicking outside
        $(document).on('click', function(e) {
            if (!$(e.target).closest('.icon-preview-wrapper').length) {
                $('.icon-picker-container').slideUp();
            }
        });
    },

    initItemTypeHandlers: function() {
        // Initialize any item type-specific handlers
        this.initFieldValidation();
        this.initDependentFields();
    },

    updateDynamicFields: function(fieldsConfig, settingsConfig) {
        const container = $('#dynamicFields');
        container.empty();

        if (!fieldsConfig) return;

        try {
            const fields = JSON.parse(fieldsConfig);
            const settings = settingsConfig ? JSON.parse(settingsConfig) : {};

            fields.forEach(field => {
                container.append(this.createFieldHtml(field, settings));
            });

            // Re-initialize any special field handlers
            this.initSpecialFields();
        } catch (e) {
            console.error('Error parsing fields configuration:', e);
        }
    },

    createFieldHtml: function(field, settings) {
        let html = '';
        const fieldId = `field_${field.name}`;
        
        switch (field.type) {
            case 'text':
            case 'url':
            case 'email':
            case 'number':
                html = `
                    <div class="mb-3">
                        <label class="form-label" for="${fieldId}">
                            ${field.label}
                            ${field.required ? '<span class="text-danger">*</span>' : ''}
                        </label>
                        <input type="${field.type}" 
                               class="form-control" 
                               id="${fieldId}" 
                               name="fields[${field.name}]"
                               ${field.required ? 'required' : ''}
                               ${field.placeholder ? `placeholder="${field.placeholder}"` : ''}>
                        ${field.description ? `<div class="form-text">${field.description}</div>` : ''}
                    </div>`;
                break;

            case 'textarea':
                html = `
                    <div class="mb-3">
                        <label class="form-label" for="${fieldId}">
                            ${field.label}
                            ${field.required ? '<span class="text-danger">*</span>' : ''}
                        </label>
                        <textarea class="form-control" 
                                 id="${fieldId}" 
                                 name="fields[${field.name}]"
                                 rows="${field.rows || 3}"
                                 ${field.required ? 'required' : ''}
                                 ${field.placeholder ? `placeholder="${field.placeholder}"` : ''}></textarea>
                        ${field.description ? `<div class="form-text">${field.description}</div>` : ''}
                    </div>`;
                break;

            case 'select':
                const options = field.options || [];
                html = `
                    <div class="mb-3">
                        <label class="form-label" for="${fieldId}">
                            ${field.label}
                            ${field.required ? '<span class="text-danger">*</span>' : ''}
                        </label>
                        <select class="form-select" 
                                id="${fieldId}" 
                                name="fields[${field.name}]"
                                ${field.required ? 'required' : ''}>
                            <option value="">${field.placeholder || 'Select an option'}</option>
                            ${options.map(opt => `
                                <option value="${opt.value}">${opt.label}</option>
                            `).join('')}
                        </select>
                        ${field.description ? `<div class="form-text">${field.description}</div>` : ''}
                    </div>`;
                break;

            case 'checkbox':
            case 'radio':
                const choices = field.options || [];
                html = `
                    <div class="mb-3">
                        <label class="form-label">
                            ${field.label}
                            ${field.required ? '<span class="text-danger">*</span>' : ''}
                        </label>
                        <div>
                            ${choices.map((choice, idx) => `
                                <div class="form-check">
                                    <input class="form-check-input" 
                                           type="${field.type}" 
                                           id="${fieldId}_${idx}"
                                           name="fields[${field.name}]${field.type === 'checkbox' ? '[]' : ''}"
                                           value="${choice.value}"
                                           ${field.required ? 'required' : ''}>
                                    <label class="form-check-label" for="${fieldId}_${idx}">
                                        ${choice.label}
                                    </label>
                                </div>
                            `).join('')}
                        </div>
                        ${field.description ? `<div class="form-text">${field.description}</div>` : ''}
                    </div>`;
                break;
        }
        
        return html;
    },

    initFieldValidation: function() {
        // Add any field-specific validation logic here
        $('input[type="url"]').on('blur', function() {
            if (this.value && !this.value.match(/^https?:\/\/.+/)) {
                this.value = 'https://' + this.value;
            }
        });
    },

    initDependentFields: function() {
        // Handle any fields that depend on other field values
        $('[data-depends-on]').each(function() {
            const dependentField = $(this);
            const sourceField = $(`#${dependentField.data('depends-on')}`);
            
            sourceField.on('change', function() {
                const shouldShow = $(this).val() === dependentField.data('depends-value');
                dependentField.closest('.mb-3')[shouldShow ? 'show' : 'hide']();
                dependentField.prop('required', shouldShow);
            }).trigger('change');
        });
    },

    initSpecialFields: function() {
        // Initialize special field types (e.g., rich text editors, datepickers)
        // This method would be called after dynamic fields are added
        if (typeof Quill !== 'undefined') {
            $('.wysiwyg-editor').each(function() {
                new Quill(this, {
                    theme: 'snow',
                    modules: {
                        toolbar: [
                            ['bold', 'italic', 'underline', 'strike'],
                            ['blockquote', 'code-block'],
                            [{ 'list': 'ordered'}, { 'list': 'bullet' }],
                            ['link', 'image'],
                            ['clean']
                        ]
                    }
                });
            });
        }
    }
};

// Global base_url variable
var base_url = '<?= base_url() ?>';

// Enhanced Block Management System
const BlockSystem = {
    init: function() {
        this.initDataTables();
        this.bindEvents();
        this.initSlugGeneration();
        this.initIconPicker();
    },

    // Base AJAX method for all requests
    doAjax: function(url, method, data, successCallback, errorCallback) {
        return $.ajax({
            url: url,
            type: method,
            data: data,
            dataType: 'json',
            headers: {
                'X-Requested-With': 'XMLHttpRequest'
            },
            success: successCallback,
            error: (xhr, status, error) => {
                if (xhr.status === 403) {
                    alert('Your session has expired. The page will refresh to restore your session.');
                    window.location.reload();
                    return;
                }
                if (errorCallback) {
                    errorCallback(xhr, status, error);
                } else {
                    this.showAlert('An error occurred: ' + (xhr.responseJSON?.message || error), 'error');
                }
            }
        });
    },

    initDataTables: function() {
        $('#definitionsTable').DataTable();
        $('#blocksTable').DataTable();
        $('#itemsTable').DataTable();
        $('#itemTypesTable').DataTable(); // New line for item types
    },

    initIconPicker: function() {
        const icons = [
            // Bootstrap Icons
            { class: 'bi bi-grid', name: 'Grid' },
            { class: 'bi bi-layout-text-window-reverse', name: 'Text Window' },
            { class: 'bi bi-image', name: 'Image' },
            { class: 'bi bi-card-text', name: 'Card Text' },
            { class: 'bi bi-file-code', name: 'Code' },
            { class: 'bi bi-list', name: 'List' },
            { class: 'bi bi-table', name: 'Table' },
            { class: 'bi bi-calendar', name: 'Calendar' },
            { class: 'bi bi-person', name: 'Person' },
            { class: 'bi bi-people', name: 'People' },
            { class: 'bi bi-gear', name: 'Gear' },
            { class: 'bi bi-tools', name: 'Tools' },
            { class: 'bi bi-info-circle', name: 'Info Circle' },
            { class: 'bi bi-check-circle', name: 'Check Circle' },
            { class: 'bi bi-x-circle', name: 'X Circle' },
            { class: 'bi bi-exclamation-triangle', name: 'Warning' },
            { class: 'bi bi-question-circle', name: 'Question' },
            { class: 'bi bi-folder', name: 'Folder' },
            { class: 'bi bi-file-earmark', name: 'File' },
            { class: 'bi bi-link-45deg', name: 'Link' },

            // Font Awesome Icons (assuming FA is loaded)
            { class: 'fas fa-cubes', name: 'Cubes' },
            { class: 'fas fa-info-circle', name: 'Info Circle' },
            { class: 'fas fa-file-alt', name: 'File Alt' },
            { class: 'fas fa-cogs', name: 'Cogs' },
            { class: 'fas fa-chart-bar', name: 'Chart Bar' },
            { class: 'fas fa-tasks', name: 'Tasks' },
            { class: 'fas fa-comments', name: 'Comments' },
            { class: 'fas fa-star', name: 'Star' },
            { class: 'fas fa-heart', name: 'Heart' },
            { class: 'fas fa-camera', name: 'Camera' },
        ];

        let iconGridHtml = '<div class="icon-grid">';
        icons.forEach(icon => {
            iconGridHtml += `<div class="icon-item" data-icon-class="${icon.class}" title="${icon.name}">
                                <i class="${icon.class}"></i>
                             </div>`;
        });
        iconGridHtml += '</div>';

        // Populate icon pickers for definitions
        $('#addIconPickerContainer').html(iconGridHtml);
        $('#editIconPickerContainer').html(iconGridHtml);

        // Toggle picker visibility for definitions
        $('#showAddIconPicker').on('click', function(e) {
            e.preventDefault();
            e.stopPropagation();
            $('#addIconPickerContainer').slideToggle();
            $('.icon-picker-container').not('#addIconPickerContainer').slideUp();
        });

        $('#showEditIconPicker').on('click', function(e) {
            e.preventDefault();
            e.stopPropagation();
            $('#editIconPickerContainer').slideToggle();
            $('.icon-picker-container').not('#editIconPickerContainer').slideUp();
        });

        // Close icon pickers when clicking outside
        $(document).on('click', function(e) {
            if (!$(e.target).closest('.icon-preview-wrapper').length) {
                $('.icon-picker-container').slideUp();
            }
        });

        // Handle icon selection for definitions
        $('#addIconPickerContainer, #editIconPickerContainer').on('click', '.icon-item', function(e) {
            e.preventDefault();
            e.stopPropagation();
            const iconClass = $(this).data('icon-class');
            const container = $(this).closest('.icon-picker-container');

            // Update hidden input and preview
            if (container.attr('id') === 'addIconPickerContainer') {
                $('#addDefinitionIcon').val(iconClass);
                $('#addIconPreview').html(`<i class="${iconClass}"></i>`);
            } else {
                $('#editDefinitionIcon').val(iconClass);
                $('#editIconPreview').html(`<i class="${iconClass}"></i>`);
            }

            // Highlight selected and hide picker
            container.find('.icon-item').removeClass('selected');
            $(this).addClass('selected');
            container.slideUp();
        });
    },

    bindEvents: function() {
        // Modal focus management
        $('.modal').on('hidden.bs.modal', function () {
            // When modal is hidden, remove aria-hidden
            $(this).removeAttr('aria-hidden');
            // Return focus to the trigger element
            if (this._lastFocusedElement) {
                this._lastFocusedElement.focus();
                delete this._lastFocusedElement;
            }
        });

        $('.modal').on('show.bs.modal', function (e) {
            // Store the element that triggered the modal
            this._lastFocusedElement = $(e.relatedTarget);
        });

        // Block Definition Events
        $(document).on('click', '.edit-definition', this.editDefinition.bind(this));
        $(document).on('submit', '#addDefinitionForm', this.submitDefinitionForm.bind(this));
        $(document).on('submit', '#editDefinitionForm', this.submitDefinitionForm.bind(this));
        $(document).on('click', '.delete-definition', this.deleteDefinition.bind(this));

        // Post Block Events
        $(document).on('click', '.add-block', this.showAddBlockModal.bind(this));
        $(document).on('click', '.edit-block', this.editBlock.bind(this));
        $(document).on('submit', '#addBlockForm', this.submitBlockForm.bind(this));
        $(document).on('submit', '#editBlockForm', this.submitBlockForm.bind(this));
        $(document).on('click', '.delete-block', this.deleteBlock.bind(this));
        $(document).on('change', '#filterByPost, #filterByStatus', this.filterBlocks.bind(this));
        $(document).on('click', '.change-order', this.showChangeOrderModal.bind(this));
        $(document).on('submit', '#changeOrderForm', this.submitOrderChange.bind(this));
        $(document).on('click', '.view-items', this.viewBlockItems.bind(this));
        $(document).on('click', '.view-block', this.viewBlockDetails.bind(this));

        // Block Item Events
        $(document).on('click', '#addItemBtn', this.showAddItemModal.bind(this));
        $(document).on('click', '.add-item', this.showAddItemModal.bind(this)); // For adding item from block list
        $(document).on('click', '.edit-item', this.editItem.bind(this));
        $(document).on('submit', '#itemForm', this.submitItemForm.bind(this));
        $(document).on('click', '.delete-item', this.deleteItem.bind(this));
        $(document).on('change', '#filterByBlock, #filterByType', this.filterItems.bind(this));
        $(document).on('click', '.change-item-order', this.showChangeOrderModal.bind(this));

        // Item Type Events
        $(document).on('click', '#itemTypesTable .view-item-type', this.viewItemType.bind(this));
        $(document).on('click', '#itemTypesTable .edit-item-type', this.editItemType.bind(this));
        $(document).on('submit', '#addItemTypeForm', this.submitItemTypeForm.bind(this));
        $(document).on('submit', '#editItemTypeForm', this.submitItemTypeForm.bind(this));
        $(document).on('click', '.delete-item-type', this.deleteItemType.bind(this));
    },

    initSlugGeneration: function() {
        $('#addDefinitionModal input[name="name"], #editDefinitionModal input[name="name"], #addItemTypeModal input[name="name"], #editItemTypeModal input[name="name"]').on('keyup change', function() {
            const $slugField = $(this).closest('form').find('input[name="slug"]');
            const slug = $(this).val()
                .toLowerCase()
                .replace(/[^a-z0-9-]/g, '-')
                .replace(/-+/g, '-')
                .replace(/^-|-$/g, '');
            $slugField.val(slug);
        });
    },

    // ... (rest of the BlockSystem object)

    // Definition Methods
    editDefinition: function(e) {
        const id = $(e.currentTarget).data('id');
        this.loadDefinition(id);
    },

    loadDefinition: function(id) {
        $.ajax({
            url: base_url + 'administrator/posts/blocks/definition/' + id,
            type: 'GET',
            success: (response) => {
                if (response.success) {
                    const def = response.data;
                    const form = $('#editDefinitionForm');
                    
                    // Reset any previous form state
                    form[0].reset();
                    $('#editIconPickerContainer .icon-item').removeClass('selected');
                    $('#editIconPreview').html('<i class="bi bi-square"></i>');
                    
                    // Set form values
                    form.find('[name="id"]').val(def.id);
                    form.find('[name="name"]').val(def.name);
                    form.find('[name="slug"]').val(def.slug);
                    form.find('[name="category"]').val(def.category);
                    
                    // Handle icon with improved preview
                    if (def.icon) {
                        form.find('[name="icon"]').val(def.icon);
                        $('#editIconPreview').html(`<i class="${def.icon}"></i>`);
                        $(`#editIconPickerContainer .icon-item[data-icon-class="${def.icon}"]`).addClass('selected');
                    }

                    form.find('[name="description"]').val(def.description || '');
                    form.find('[name="is_repeatable"]').val(def.is_repeatable || '0');
                    form.find('[name="max_instances"]').val(def.max_instances || '');
                    form.find('[name="is_active"]').val(def.is_active || '1');

                    // Pre-select item types (checkboxes)
                    $('#editItemTypesCheckboxes input[type="checkbox"]').prop('checked', false); // Deselect all first
                    if (def.item_types && def.item_types.length > 0) {
                        def.item_types.forEach(rel => {
                            $(`#editItemTypesCheckboxes input[type="checkbox"][value="${rel.item_type_definition_id}"]`).prop('checked', true);
                        });
                    }

                    // Show modal
                    $('#editDefinitionModal').modal('show');

                    // Ensure icon picker container is hidden initially
                    $('#editIconPickerContainer').hide();
                } else {
                    this.showAlert(response.message || 'Error loading definition', 'error');
                }
            },
            error: () => {
                this.showAlert('Error loading definition', 'error');
            }
        });
    },

    deleteDefinition: function(e) {
        const id = $(e.currentTarget).data('id');
        const name = $(e.currentTarget).data('name');
        
        if(confirm(`Are you sure you want to delete the definition "${name}"? This action cannot be undone.`)) {
            window.location.href = base_url + 'administrator/posts/blocks/definition/delete/' + id;
        }
    },

    submitDefinitionForm: function(e) {
        e.preventDefault();
        const form = $(e.target);
        const isEdit = form.find('[name="id"]').val();
        const url = isEdit ? 
            base_url + 'administrator/posts/blocks/definition/update' :
            base_url + 'administrator/posts/blocks/definition/add';

        $.ajax({
            url: url,
            type: 'POST',
            data: form.serialize(),
            success: (response) => {
                if (response.success) {
                    const currentTab = localStorage.getItem('blocksActiveTab') || 'definitions';
                    window.location.href = `${window.location.pathname}?tab=${currentTab}`;
                } else {
                    this.showAlert(response.message || 'Error saving definition', 'error');
                }
            },
            error: () => {
                this.showAlert('Error saving definition', 'error');
            }
        });
    },

    // Item Type Methods
    editItemType: function(e) {
        const id = $(e.currentTarget).data('id');
        this.loadItemType(id);
    },

    loadItemType: function(id) {
        $.ajax({
            url: base_url + 'administrator/posts/blocks/item-type/' + id,
            type: 'GET',
            success: (response) => {
                if (response.success) {
                    const itemType = response.data;
                    const form = $('#editItemTypeForm');
                    
                    form[0].reset(); // Reset any previous form state
                    
                    form.find('[name="id"]').val(itemType.id);
                    form.find('[name="name"]').val(itemType.name);
                    form.find('[name="slug"]').val(itemType.slug);
                    form.find('[name="description"]').val(itemType.description || '');

                    $('#editItemTypeModal').modal('show');
                } else {
                    this.showAlert(response.message || 'Error loading item type', 'error');
                }
            },
            error: () => {
                this.showAlert('Error loading item type', 'error');
            }
        });
    },

    deleteItemType: function(e) {
        const id = $(e.currentTarget).data('id');
        const name = $(e.currentTarget).data('name');
        
        if(confirm(`Are you sure you want to delete the item type "${name}"? This action cannot be undone.`)) {
            window.location.href = base_url + 'administrator/posts/blocks/item-type/delete/' + id;
        }
    },

    viewItemType: function(e) {
        const id = $(e.currentTarget).data('id');
        this.loadItemTypeForView(id);
    },

    loadItemTypeForView: function(id) {
        $.ajax({
            url: base_url + 'administrator/posts/blocks/item-type/view/' + id,
            type: 'GET',
            success: (response) => {
                if (response.success) {
                    const data = response.data;
                    const itemType = data.itemType;

                    // Populate view modal
                    $('#viewItemTypeId').text(itemType.id);
                    $('#viewItemTypeName').text(itemType.name);
                    $('#viewItemTypeSlug').text(itemType.slug);
                    $('#viewItemTypeDescription').text(itemType.description || 'No description');
                    $('#viewItemTypeCreated').text(itemType.created_at || 'N/A');
                    $('#viewItemTypeUpdated').text(itemType.updated_at || 'N/A');

                    // Show configuration details
                    let configHtml = '';
                    if (itemType.fields_config) {
                        try {
                            const fields = JSON.parse(itemType.fields_config);
                            configHtml += '<h6>Fields Configuration:</h6><ul>';
                            fields.forEach(field => {
                                configHtml += `<li><strong>${field.label}</strong> (${field.type})`;
                                if (field.required) configHtml += ' <span class="text-danger">*</span>';
                                configHtml += '</li>';
                            });
                            configHtml += '</ul>';
                        } catch (e) {
                            configHtml += '<p class="text-muted">Invalid fields configuration</p>';
                        }
                    }

                    if (itemType.settings_config) {
                        try {
                            const settings = JSON.parse(itemType.settings_config);
                            configHtml += '<h6>Settings Configuration:</h6><pre class="bg-light p-2 rounded"><code>' + JSON.stringify(settings, null, 2) + '</code></pre>';
                        } catch (e) {
                            configHtml += '<p class="text-muted">Invalid settings configuration</p>';
                        }
                    }

                    if (itemType.icon) {
                        configHtml += '<h6>Icon:</h6><p><i class="' + itemType.icon + '"></i> ' + itemType.icon + '</p>';
                    }

                    // Add usage statistics
                    if (data.usageCount !== undefined) {
                        configHtml += '<h6>Usage Statistics:</h6>';
                        configHtml += '<p>Used in <strong>' + data.usageCount + '</strong> block items</p>';
                    }

                    // Add associated blocks
                    if (data.associatedBlocks && data.associatedBlocks.length > 0) {
                        configHtml += '<h6>Associated Block Definitions:</h6><ul>';
                        data.associatedBlocks.forEach(block => {
                            configHtml += `<li><strong>${block.name}</strong> (${block.slug})</li>`;
                        });
                        configHtml += '</ul>';
                    }

                    $('#viewItemTypeConfig').html(configHtml || '<p class="text-muted">No configuration details available</p>');

                    // Set up edit button
                    $('.edit-item-type-btn').off('click').on('click', () => {
                        $('#viewItemTypeModal').modal('hide');
                        this.editItemType({ currentTarget: $(`.edit-item-type[data-id="${id}"]`)[0] });
                    });

                    $('#viewItemTypeModal').modal('show');
                } else {
                    this.showAlert(response.message || 'Error loading item type', 'error');
                }
            },
            error: () => {
                this.showAlert('Error loading item type', 'error');
            }
        });
    },

    submitItemTypeForm: function(e) {
        e.preventDefault();
        const form = $(e.target);
        const isEdit = form.find('[name="id"]').val();
        const url = isEdit ?
            base_url + 'administrator/posts/blocks/item-type/update' :
            base_url + 'administrator/posts/blocks/item-type/add';

        $.ajax({
            url: url,
            type: 'POST',
            data: form.serialize(),
            success: (response) => {
                if (response.success) {
                    location.reload();
                } else {
                    this.showAlert(response.message || 'Error saving item type', 'error');
                }
            },
            error: () => {
                this.showAlert('Error saving item type', 'error');
            }
        });
    },

    // Block Methods
    showAddBlockModal: function(e) {
        const postId = $(e.currentTarget).data('post-id');
        
        // Load active definitions
        $.ajax({
            url: base_url + 'administrator/posts/blocks/definitions/active',
            type: 'GET',
            success: (response) => {
                if (response.success) {
                    const select = $('#addBlockForm [name="definition_id"]');
                    select.empty().append('<option value="">Select Definition</option>');
                    
                    response.data.forEach((def) => {
                        select.append(`<option value="${def.id}">${def.name} (${def.slug})</option>`);
                    });

                    if (postId) {
                        $('#addBlockForm [name="post_id"]').val(postId);
                    }
                    $('#addBlockModal').modal('show');
                } else {
                    this.showAlert(response.message || 'Error loading definitions', 'error');
                }
            },
            error: () => {
                this.showAlert('Error loading definitions', 'error');
            }
        });
    },

    editBlock: function(e) {
        const id = $(e.currentTarget).data('id');
        this.loadBlock(id);
    },

    loadBlock: function(id) {
        $.ajax({
            url: base_url + 'administrator/posts/blocks/' + id,
            type: 'GET',
            success: (response) => {
                if (response.success) {
                    const block = response.data;
                    const form = $('#editBlockForm');
                    
                    form.find('[name="id"]').val(block.id);
                    form.find('[name="block_cat"]').val(block.block_cat);
                    form.find('[name="heading"]').val(block.heading);
                    form.find('[name="ordering"]').val(block.ordering);
                    form.find('[name="status"]').val(block.status);
                    form.find('[name="content"]').val(block.content);

                    $('#editBlockModal').modal('show');
                } else {
                    this.showAlert(response.message || 'Error loading block', 'error');
                }
            },
            error: () => {
                this.showAlert('Error loading block', 'error');
            }
        });
    },

    deleteBlock: function(e) {
        const id = $(e.currentTarget).data('id');
        const title = $(e.currentTarget).data('title');
        
        if(confirm(`Are you sure you want to delete the block "${title}"? All associated items will also be deleted.`)) {
            window.location.href = base_url + 'administrator/posts/blocks/delete/' + id;
        }
    },

    submitBlockForm: function(e) {
        e.preventDefault();
        const form = $(e.target);
        const isEdit = form.attr('id') === 'editBlockForm';
        const url = isEdit ? 
            base_url + 'administrator/posts/blocks/update' :
            base_url + 'administrator/posts/blocks/add';
            
        this.handleFormSubmit(form, {
            url: url,
            successMessage: `Block ${isEdit ? 'updated' : 'added'} successfully`,
            errorMessage: `Error ${isEdit ? 'updating' : 'adding'} block`
        });
            
        // Ensure CSRF token is present and up to date
        const csrfToken = $('meta[name="csrf-token"]').attr('content');
        form.find('input[name="csrf_token"]').val(csrfToken);

        // Clear previous error messages
        form.find('.is-invalid').removeClass('is-invalid');
        form.find('.invalid-feedback').remove();

        // Show loading state
        const submitBtn = form.find('[type="submit"]');
        const originalBtnText = submitBtn.html();
        submitBtn.prop('disabled', true).html('<i class="spinner-border spinner-border-sm"></i> Saving...');

        $.ajax({
            url: url,
            type: 'POST',
            data: form.serialize(),
            success: (response) => {
                if (response.success) {
                    this.showAlert('Block ' + (isEdit ? 'updated' : 'added') + ' successfully', 'success');
                    const currentTab = localStorage.getItem('blocksActiveTab') || 'definitions';
                    setTimeout(() => window.location.href = `${window.location.pathname}?tab=${currentTab}`, 1000);
                } else {
                    if (response.errors) {
                        // Handle validation errors
                        Object.keys(response.errors).forEach(field => {
                            const input = form.find(`[name="${field}"]`);
                            input.addClass('is-invalid');
                            input.after(`<div class="invalid-feedback">${response.errors[field]}</div>`);
                        });
                    }
                    this.showAlert(response.message || 'Error saving block', 'error');
                }
            },
            error: (xhr) => {
                let errorMsg = 'Error saving block';
                if (xhr.responseJSON && xhr.responseJSON.message) {
                    errorMsg = xhr.responseJSON.message;
                } else if (xhr.status === 403) {
                    errorMsg = 'You do not have permission to perform this action';
                } else if (xhr.status === 419 || xhr.status === 401) {
                    errorMsg = 'Your session has expired. Please refresh the page and try again.';
                }
                this.showAlert(errorMsg, 'error');
            },
            complete: () => {
                // Restore button state
                submitBtn.prop('disabled', false).html(originalBtnText);
            }
        });
    },

    // Item Methods
    showAddItemModal: function(e) {
        const form = $('#itemForm');
        form[0].reset();

        // Clear icon preview
        form.find('.item-icon-preview').html('<i class="bi bi-square"></i>');
        form.find('.item-icon-input').val('');

        if (e && $(e.currentTarget).data('block-id')) {
            const blockId = $(e.currentTarget).data('block-id');
            const blockType = $(e.currentTarget).data('block-type');
            form.find('[name="block_id"]').val(blockId);
            $('#itemModal .modal-title').html(`Add Item to <small class="text-muted">${blockType}</small>`);
        } else {
            $('#itemModal .modal-title').text('Add Block Item');
        }

        form.find('[name="id"]').val('');
        $('#itemModal').modal('show');
    },

    editItem: function(e) {
        const id = $(e.currentTarget).data('id');
        this.loadItem(id);
    },

    loadItem: function(id) {
        $.ajax({
            url: base_url + 'administrator/posts/blocks/item/' + id,
            type: 'GET',
            success: (response) => {
                if (response.success) {
                    const item = response.data;
                    const form = $('#itemForm');

                    form.find('[name="id"]').val(item.id);
                    form.find('[name="block_id"]').val(item.block_id);
                    form.find('[name="item_type"]').val(item.item_type);
                    form.find('[name="title"]').val(item.title);
                    form.find('[name="icon"]').val(item.icon);
                    form.find('[name="description"]').val(item.description);
                    form.find('[name="link"]').val(item.link);
                    form.find('[name="ordering"]').val(item.ordering);
                    form.find('[name="width"]').val(item.width);
                    form.find('[name="status"]').val(item.status);

                    // Set icon preview if icon exists
                    if (item.icon) {
                        form.find('.item-icon-preview').html(`<i class="${item.icon}"></i>`);
                        form.find('.item-icon-input').val(item.icon);
                    } else {
                        form.find('.item-icon-preview').html('<i class="bi bi-square"></i>');
                        form.find('.item-icon-input').val('');
                    }

                    $('#itemModal .modal-title').text('Edit Block Item');
                    $('#itemModal').modal('show');
                } else {
                    this.showAlert(response.message || 'Error loading item', 'error');
                }
            },
            error: () => {
                this.showAlert('Error loading item', 'error');
            }
        });
    },

    deleteItem: function(e) {
        const id = $(e.currentTarget).data('id');
        const title = $(e.currentTarget).data('title');
        
        if(confirm(`Are you sure you want to delete the item "${title}"?`)) {
            window.location.href = base_url + 'administrator/posts/blocks/item/delete/' + id;
        }
    },

    submitItemForm: function(e) {
        e.preventDefault();
        const form = $(e.target);
        const isEdit = form.find('[name="id"]').val();
        const url = isEdit ? 
            base_url + 'administrator/posts/blocks/item/update' :
            base_url + 'administrator/posts/blocks/item/add';

        $.ajax({
            url: url,
            type: 'POST',
            data: form.serialize(),
            success: (response) => {
                if (response.success) {
                    location.reload();
                } else {
                    this.showAlert(response.message || 'Error saving item', 'error');
                }
            },
            error: () => {
                this.showAlert('Error saving item', 'error');
            }
        });
    },

    // Order Management
    showChangeOrderModal: function(e) {
        const id = $(e.currentTarget).data('id');
        const currentOrder = $(e.currentTarget).data('current');
        const type = $(e.currentTarget).hasClass('change-item-order') ? 'item' : 'block';
        
        $('#changeOrderForm [name="id"]').val(id);
        $('#changeOrderForm [name="type"]').val(type);
        $('#changeOrderForm [name="ordering"]').val(currentOrder);
        
        $('#changeOrderModal').modal('show');
    },

    submitOrderChange: function(e) {
        e.preventDefault();
        const form = $(e.target);
        const type = form.find('[name="type"]').val();
        
        const url = type === 'item' ? 
            base_url + 'administrator/posts/blocks/item/update-order' :
            base_url + 'administrator/posts/blocks/update-order';

        // Show loading state
        const submitBtn = form.find('[type="submit"]');
        const originalBtnText = submitBtn.html();
        submitBtn.prop('disabled', true).html('<i class="spinner-border spinner-border-sm"></i> Updating...');

        $.ajax({
            url: url,
            type: 'POST',
            data: form.serialize(),
            dataType: 'json',
            success: (response) => {
                if (response.success) {
                    window.location.reload();
                } else {
                    this.showAlert(response.message || 'Error updating order', 'error');
                    submitBtn.prop('disabled', false).html(originalBtnText);
                }
            },
            error: (xhr) => {
                this.showAlert('Error updating order. Please try again.', 'error');
                submitBtn.prop('disabled', false).html(originalBtnText);
                if (xhr.status === 403) {
                    window.location.reload();
                }
            }
        });
    },

    // View Methods
    viewBlockDetails: function(e) {
        e.preventDefault();
        const blockId = $(e.currentTarget).data('id');
        
        $.ajax({
            url: base_url + 'administrator/posts/block/' + blockId,
            type: 'GET',
            success: (response) => {
                if (response.success) {
                    const block = response.data.block;
                    const items = response.data.items;

                    // Update block information
                    $('#blockPostTitle').text(block.post_title || 'N/A');
                    $('#blockType').text(block.block_type);
                    $('#blockDefinitionName').text(block.definition_name || 'N/A');
                    $('#blockDefinitionDesc').text(block.definition_description || '');
                    $('#blockCategory').text(block.block_cat).addClass('bg-secondary');
                    $('#blockHeading').text(block.heading || 'N/A');
                    $('#blockOrder').html(`<span class="badge bg-primary">${block.ordering}</span>`);
                    $('#blockStatus').html(block.status === 'active' ? 
                        '<span class="badge bg-success">Active</span>' : 
                        '<span class="badge bg-secondary">Inactive</span>'
                    );

                    // Update block items
                    if (items && items.length > 0) {
                        let itemsHtml = '<div class="table-responsive"><table class="table table-sm">';
                        itemsHtml += '<thead><tr><th>Title</th><th>Type</th><th>Order</th><th>Status</th></tr></thead>';
                        itemsHtml += '<tbody>';
                        
                        items.forEach(item => {
                            itemsHtml += `<tr>
                                <td>${item.title || 'N/A'}</td>
                                <td><code>${item.item_type}</code></td>
                                <td><span class="badge bg-primary">${item.ordering}</span></td>
                                <td>${item.status === 'active' ? 
                                    '<span class="badge bg-success">Active</span>' : 
                                    '<span class="badge bg-secondary">Inactive</span>'}</td>
                            </tr>`;
                        });
                        
                        itemsHtml += '</tbody></table></div>';
                        $('#blockItemsContainer').html(itemsHtml);
                    } else {
                        $('#blockItemsContainer').html('<div class="alert alert-info">No items found in this block.</div>');
                    }

                    // Set up edit button
                    $('.edit-block-btn').off('click').on('click', () => {
                        $('#viewBlockModal').modal('hide');
                        this.editBlock({ currentTarget: $(`.edit-block[data-id="${blockId}"]`)[0] });
                    });

                    $('#viewBlockModal').modal('show');
                } else {
                    this.showAlert(response.message || 'Error loading block details', 'error');
                }
            },
            error: () => {
                this.showAlert('Error loading block details', 'error');
            }
        });
    },

    viewBlockItems: function(e) {
        const blockId = $(e.currentTarget).data('block-id');
        
        $.ajax({
            url: base_url + 'administrator/posts/blocks/items/' + blockId,
            type: 'GET',
            success: (response) => {
                if (response.success) {
                    $('#itemsListContainer').html(response.html);
                    $('#viewItemsModal').modal('show');
                } else {
                    this.showAlert(response.message || 'Error loading items', 'error');
                }
            },
            error: () => {
                this.showAlert('Error loading items', 'error');
            }
        });
    },

    // Filter Methods
    filterBlocks: function() {
        const postId = $('#filterByPost').val();
        const status = $('#filterByStatus').val();
        const table = $('#blocksTable').DataTable();
        
        table.column(1).search(postId);
        table.column(7).search(status);
        table.draw();
    },

    filterItems: function() {
        const blockId = $('#filterByBlock').val();
        const type = $('#filterByType').val();
        const table = $('#itemsTable').DataTable();
        
        table.column(1).search(blockId);
        table.column(2).search(type);
        table.draw();
    },

    // Utility Methods
    showAlert: function(message, type = 'info') {
        const alertClass = type === 'error' ? 'alert-danger' : (type === 'success' ? 'alert-success' : 'alert-info');
        const alertHtml = `
            <div class="alert ${alertClass} alert-dismissible fade show" role="alert">
                ${message}
                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
            </div>
        `;
        $('#showMsg').html(alertHtml);
        
        // Auto-dismiss after 5 seconds
        setTimeout(() => {
            $('.alert').alert('close');
        }, 5000);
    },

    handleFormSubmit: function(form, options) {
        // Ensure CSRF token is up to date
        const csrfToken = $('meta[name="csrf-token"]').attr('content');
        form.find('input[name="csrf_token"]').val(csrfToken);

        // Clear previous error messages
        form.find('.is-invalid').removeClass('is-invalid');
        form.find('.invalid-feedback').remove();

        // Show loading state
        const submitBtn = form.find('[type="submit"]');
        const originalBtnText = submitBtn.html();
        submitBtn.prop('disabled', true).html('<i class="spinner-border spinner-border-sm"></i> Saving...');

        // Add CSRF token to form if not present
        if (!form.find('input[name="csrf_token"]').length) {
            form.append(`<input type="hidden" name="csrf_token" value="${csrfToken}">`);
        }

        this.doAjax(
            options.url,
            'POST',
            form.serialize(),
            (response) => {
                if (response.success) {
                    this.showAlert(options.successMessage || 'Saved successfully', 'success');
                    if (options.onSuccess) {
                        options.onSuccess(response);
                    } else {
                        const currentTab = localStorage.getItem('blocksActiveTab') || 'definitions';
                        setTimeout(() => {
                            window.location.href = `${window.location.pathname}?tab=${currentTab}`;
                        }, 1000);
                    }
                } else {
                    if (response.errors) {
                        Object.keys(response.errors).forEach(field => {
                            const input = form.find(`[name="${field}"]`);
                            input.addClass('is-invalid');
                            input.after(`<div class="invalid-feedback">${response.errors[field]}</div>`);
                        });
                    }
                    this.showAlert(response.message || options.errorMessage || 'Error saving data', 'error');
                }
            },
            (xhr) => {
                let errorMsg = options.errorMessage || 'Error occurred';
                if (xhr.responseJSON?.message) {
                    errorMsg = xhr.responseJSON.message;
                } else if (xhr.status === 403) {
                    errorMsg = 'You do not have permission to perform this action';
                } else if (xhr.status === 419 || xhr.status === 401) {
                    errorMsg = 'Your session has expired. Please refresh the page and try again.';
                }
                this.showAlert(errorMsg, 'error');
            }
        ).always(() => {
            submitBtn.prop('disabled', false).html(originalBtnText);
        });
    }
};

// Tab persistence functionality
const TabManager = {
    init: function() {
        // Set initial active tab from localStorage or default to first tab
        const activeTab = localStorage.getItem('blocksActiveTab') || 'definitions';
        this.activateTab(activeTab);
        
        // Listen for tab changes
        $('button[data-bs-toggle="tab"]').on('shown.bs.tab', (e) => {
            const tabId = $(e.target).attr('id');
            const tabName = tabId.replace('-tab', '');
            localStorage.setItem('blocksActiveTab', tabName);
        });
    },

    activateTab: function(tabName) {
        // Activate the correct tab
        $(`#${tabName}-tab`).tab('show');
    }
};

// Initialize when document is ready
$(document).ready(function() {
    // Setup CSRF handling for AJAX requests
    $.ajaxSetup({
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content'),
            'X-Requested-With': 'XMLHttpRequest'
        },
        error: function(xhr, status, error) {
            if (xhr.status === 403) {
                // CSRF token mismatch or session expired
                alert('Your session has expired. The page will refresh to restore your session.');
                window.location.reload();
            }
        }
    });

    // Add CSRF token to all forms
    $('form').each(function() {
        if (!$(this).find('input[name="csrf_token"]').length) {
            $(this).append('<input type="hidden" name="csrf_token" value="' + $('meta[name="csrf-token"]').attr('content') + '">');
        }
    });

    ItemTypeManager.init();
    BlockSystem.init();
    TabManager.init();
    
    // Update URLs with tab information
    const updateUrlWithTab = () => {
        const urlParams = new URLSearchParams(window.location.search);
        const activeTab = localStorage.getItem('blocksActiveTab');
        if (activeTab) {
            urlParams.set('tab', activeTab);
            const newUrl = `${window.location.pathname}?${urlParams.toString()}`;
            history.replaceState({}, '', newUrl);
        }
    };
    
    // Update URL when tab changes
    $('button[data-bs-toggle="tab"]').on('shown.bs.tab', updateUrlWithTab);
    
    // Set initial URL
    updateUrlWithTab();
});
</script>

<?= $this->endSection(); ?>