<?= $this->extend('Modules\Admin\Views\index'); ?>
<?= $this->section('content');?>
<div class="container-fluid">
<div class="row mb-md-3">
	<div class="col">
		<h4>Add Block Post</h4>
		<!-- Breadcrumb !-->
		<nav aria-label="breadcrumb"><small>
			<ol class="breadcrumb mb-0">
				<li class="breadcrumb-item"><a href="<?= base_url('administrator') ?> ">Home</a></li>
                <li class="breadcrumb-item"><a href="<?= base_url('administrator/posts') ?> ">All Posts</a></li>
				<li class="breadcrumb-item active" aria-current="page"><?= esc($bcrumb) ?> </li>
			</ol></small>
		</nav>
		<!-- End Breadcrumb !-->
	</div>
</div>
<!-- print success message !-->
<div class="row">
    <div class="col">

			<!-- print success message !-->
			<?php if(session()->getTempdata('success')): ?>
				<div class="alert alert-success" role="alert"><?= session()->getTempdata('success');?></div>
				<?php endif;?>
			<!-- print failure message !-->
			<?php if(session()->getTempdata('error')): ?>
				<div class="alert alert-danger" role="alert"><?= session()->getTempdata('error');?></div>
			<?php endif;?>
            <?php if(isset($validation)): ?>
			<div class="alert alert-danger">
			<?= $validation->listErrors()?>
			</div>
            <?php endif;?>
            <div id="showMsg"></div>
</div></div>
<!-- Create/Post !-->
<form method="POST" action="<?= base_url('administrator/posts/block-post/add')?>" enctype="multipart/form-data">
    <?= csrf_field();?>
    <div class="card rounded-0 shadow-sm">
        <div class="card-header bg-light bg-opacity-100">
            <!-- Save/New/Cancel Btns !-->
            <div class="d-flex bd-highlight align-items-center">
                <div class="p-1 bd-highlight align-items-center">
                    <div class="btn-group border shadow-sm">
                    <button type="button" class="btn bg-success rounded-0"><i class="bi bi-plus-lg text-white"></i></button>
                    <button type="submit" class="btn btn-sm btn-success align-items-center"> Save & Close</button>
                    </div>
                </div>
                <div class="p-1 bd-highlight d-none d-md-block">
                    <div class="btn-group border shadow-sm">
                    <button type="button" class="btn bg-secondary bg-opacity-25 rounded-0"><i class="bi bi-plus-lg"></i></button>
                    <a href="#" class="btn btn-sm btn-light">Save & New</a>
                    </div>
                </div>
                <div class="p-1 bd-highlight">
                    <div class="btn-group border shadow-sm">
                    <button type="button" class="btn bg-danger bg-opacity-25 rounded-0"><i class="bi bi-x-lg"></i></button>
                    <button type="reset" class="btn btn-sm btn-danger">Reset</button>
                    </div>
                </div>
                <div class="p-1 bd-highlight">
                    <div class="btn-group border shadow-sm">
                    <button type="button" class="btn bg-primary bg-opacity-25 rounded-0"><i class="bi bi-x-lg"></i></button>
                    <a href="<?= base_url('administrator/posts/block-posts') ?>" class="btn btn-sm btn-primary">Back to Posts</a>
                    </div>
                </div>
            </div>
            <!-- END Save/New/Cancel Btns !-->
        </div>
        <div class="card-body">
            <div class="row">
                <div class="col-md-7">
                    <div class="mb-3">
                    <label class="form-label"><strong>Title</strong></label>
                    <input type="text" name="title" class="form-control" required>
                    </div>
                </div>
                <div class="col-md-5">
                    <div class="mb-3">
                    <label class="form-label"><strong>Alias</strong></label>
                    <input type="text" name="alias" placeholder="Automatically generated" class="form-control bg-secondary bg-opacity-10" readonly>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-lg-9">
                  <!-- Main post content !-->
                  <div class="mb-3">
                    <label class="form-label"><strong>Content</strong></label>
                    
                    <div class="alert alert-primary">To view the <strong>Add Block</strong> button, you will have to first save the post with Title and other paramenters Available.</div>

                    
                
                
                  </div>
                  <div class="mb-3">
                    <label class="form-label"><strong>Excerpt text</strong></label>
                    <textarea name="excerpt" class="form-control"  rows="2" placeholder="Write summary text here.." maxlength="300" required></textarea>
                  </div>
                  
                  <!-- END Main post content  !-->
                </div>
                <div class="col-lg-3">
                 <!-- Main post params !-->
                 <div class="mb-3">
                    <label class="form-label" for="start_date"><strong>Start Publishing</strong></label>
                    <div class="row g-2">
                    <div class="col-8"><input type="date" name="pdate" class="form-control" id="start_date" value="<?= date('Y-m-d'); ?>"/></div><div class="col-4">
                    <input type="time" name="ptime" class="form-control" id="start_date" value="<?= date('H:i:s') ?>"/></div>
                    </div>
                 </div><!-- Set Publish Date !-->
                 <div class="mb-3">
                    <?php function generateSelectOptions($categories, $indent = '') { ?>
                        <?php foreach ($categories as $category) { ?>
                            <option value="<?= $category['id'] ?>"><?= $indent . $category['name'] ?></option>
                            <?php if (isset($category['subcategories']) && is_array($category['subcategories'])) { ?>
                                <?php generateSelectOptions($category['subcategories'], $indent . '- '); ?>
                            <?php } ?>
                        <?php } ?>
                    <?php } ?>
                    <label class="form-label"><strong>Category</strong></label>
                    <select name="category_id" class="form-select" required>
                        <option value="">Select Category</option>
                        <?php generateSelectOptions($categoryTree); ?>
                    </select>
                </div>


                  <div class="mb-3">
                    <label class="form-label"><strong>Status</strong></label>
                    <select name="status" class="form-select bg-success bg-opacity-75 text-white" >
                        <option value="Published" >Published</option>
                        <option value="Unpublished">Unpublished</option>
                        <option value="Archived">Archived</option>
                        <option value="Trashed">Trashed</option>
                    </select>
                  </div>
                  <div class="mb-3">
                    <label class="form-label"><strong>Access</strong></label>
                    <select name="access" class="form-select">
                        <option value="Public" >Public</option>
                        <option value="Private">Private</option>
                        <option value="Users">Users</option>
                    </select>
                  </div>
                  <div class="mb-3">
                    <div style="height: 150px; background: #F2F9FF; border-radius: 5px;">
                    <div id="postImgPreview"></div>
                    <small class="d-flex text-muted p-2">Add Photo to post</small>
                    </div>
                    <input type="file" name="photo" id="post_image" class="postImg upload-photo" accept=".jpg, .gif, .png, .tiff, .jpeg, .webp">
                  </div>
                  <div class="mb-3">
                    <label for="tags-input" class="form-label">Tags</label>
                    <select  class="" id="tags-input" name="tags[]" autocomplete="off" placeholder="Enter Tags separated by comma" multiple></select>
                    <span class="d-flex text-danger" onclick="addPostTag()" style="cursor: pointer"><small>Add New Tag</small></span>
                  </div>
                  <div class="mb-3">
                    <label class="form-label"><strong>Author</strong></label>
                    <select name="author_id" class="form-select" required>
                        <option value="" >Select Author</option>
                        <?php foreach($authors as $a): ?>
                            <option value="<?= $a->id;?>"><?= $a->first_name.' '.$a->last_name;?></option>
                        <?php endforeach;?>
                    </select>
                  </div>
                <!-- END Main post params  !-->
                </div>
            </div>
            <div class="row mb-4">
                <div class="accordion accordion-flush" id="accordionFlushExample">
                    <div class="accordion-item">
                        <h2 class="accordion-header" id="flush-headingOne">
                        <button class="accordion-button collapsed bg-info bg-opacity-10                                    " type="button" data-bs-toggle="collapse" data-bs-target="#flush-collapseOne" aria-expanded="false" aria-controls="flush-collapseOne">
                           Add SEO meta description and keywords
                        </button>
                        </h2>
                        <div id="flush-collapseOne" class="accordion-collapse collapse" aria-labelledby="flush-headingOne" data-bs-parent="#accordionFlushExample">
                        <div class="accordion-body">
                            <div class="row">
                <div class="col">
                    <div class="mb-3">
                    <label class="form-label"><strong>SEO Description</strong></label>
                    <textarea name="metadesc" class="form-control"   placeholder="Provide description(150 words) for SEO experience" maxlength="150"></textarea>
                  </div>
                </div>
                <div class="col">
                    <div class="mb-3">
                    <label class="form-label"><strong>SEO Keywords</strong></label>
                    <textarea name="metakey" class="form-control"   placeholder="SEO Keywords separated by comma" maxlength="200"></textarea>
                  </div>
                </div>
            </div>
                        </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</form>
<!-- End Create/Post !-->
<?= view('Modules\Posts\Views\tags\modals\\addTag_Modal') ?>
<!---- JS --->
<script src="<?= base_url();?>/assets/admin_assets/js/modules/tags.js"></script> 
<script src="<?= base_url();?>/assets/admin_assets/js/modules/posts.js"></script>  
<?= $this->endSection();?>