<?= $this->extend('Modules\Admin\Views\index'); ?>
<?= $this->section('content');?>
<div class="container-fluid">
<div class="row mb-md-3">
	<div class="col">
		<h4>Posts</h4>
		<!-- Breadcrumb !-->
		<nav aria-label="breadcrumb"><small>
			<ol class="breadcrumb mb-0">
				<li class="breadcrumb-item"><a href="<?= base_url('administrator') ?> ">Home</a></li>
				<li class="breadcrumb-item active" aria-current="page"><?= esc($bcrumb) ?> </li>
			</ol></small>
		</nav>
		<!-- End Breadcrumb !-->
	</div>
</div>
<!-- print success message !-->
<div class="row">
    <div class="col">
		<!-- print success message !-->
		<?php if(session()->getTempdata('success')): ?>
			<div class="alert alert-success" role="alert"><?= session()->getTempdata('success');?></div>
		<?php endif;?>
		<!-- print failure message !-->
		<?php if(session()->getTempdata('error')): ?>
			<div class="alert alert-danger" role="alert"><?= session()->getTempdata('error');?></div>
		<?php endif;?>
        <?php if(isset($validation)): ?>
			<div class="alert alert-danger">
		<?= $validation->listErrors()?>
		</div>
        <?php endif;?>
        <div id="showMsg"></div>
</div></div>

<!-- Tab Content -->
<div class="tab-content" id="contentTabContent">
  <!-- ALL CONTENT TAB -->
  <div class="tab-pane fade show active" id="all" role="tabpanel">
<!-- Show All Posts !-->
<div class="card card-body">
    <div class="d-flex bd-highlight mb-3">
        <div class="p-2 bd-highlight">
        <a href="<?= base_url('administrator/posts/add'); ?>" class="btn btn-sm btn-success w-100"><i class="bi bi-plus"></i> Add New</a>
        </div>
        <div class="p-2 bd-highlight">
        <a href="<?= base_url('administrator/posts/categories'); ?>" class="btn btn-sm btn-primary w-100"><i class="bi bi-plus"></i> Categories</a>
        </div>
        <div class="p-2 bd-highlight">
            <div class="btn-group border">
                <button type="button" class="btn bg-secondary bg-opacity-25 rounded-0"><i class="bi bi-pencil-square"></i></button>
                <a href="#" class="btn btn-sm btn-light">Edit</a>
            </div>
        </div>
        <div class="p-2 bd-highlight">
            <div class="btn-group border">
                <button type="button" class="btn bg-secondary bg-opacity-25 rounded-0"><i class="bi bi-check-lg text-success"></i></button>
                <a href="#" class="btn btn-sm btn-light">Publish</a>
            </div>
        </div>
        <div class="p-2 bd-highlight">
            <div class="btn-group border">
                <button type="button" class="btn bg-secondary bg-opacity-25 rounded-0"><i class="bi bi-x-circle-fill text-danger"></i></button>
                <a href="#" class="btn btn-sm btn-light">Unpublish</a>
            </div>
        </div>
        <div class="p-2 bd-highlight">
            <div class="btn-group border">
                <button type="button" class="btn bg-secondary bg-opacity-25 rounded-0"><i class="bi bi-hdd-fill"></i></button>
                <a href="#" class="btn btn-sm btn-light">Arhived</a>
            </div>
        </div>
        <div class="p-2 bd-highlight">
            <div class="btn-group border">
                <button type="button" class="btn bg-secondary bg-opacity-25 rounded-0"><i class="bi bi-trash-fill"></i></button>
                <a href="#" class="btn btn-sm btn-light">Trashed</a>
            </div>
        </div>
        <div class="p-2 bd-grow-1 bd-highlight"> &nbsp;</div>
    </div>
    <div class="table-responsive">
        <table id="postslist" class="table table-stripped table-hover">
            <thead class="bg-primary bg-opacity-10" style="font-size: 14px"><tr>
                <th>#</th>
                <th></th>
                <th>Title</th>
                <th>Access</th>
                <th>Author</th>
                <th>Date Published</th>
                <th>Hits</th>
                <th>Views</th>
                <th>Status</th>
                <th></th>
            </tr></thead>
            <tbody>
            <?php foreach($posts as $p): ?>
                    <tr>
                    <td><span class="badge rounded-pill bg-info"> <?= $p->id; ?> </span></td>
                    <td>
                        <?php if($p->photo):?>
                            <img src="<?= $p->photo; ?>" width="50px">
                        <?php endif;?>
                    </td>
                    <td><a href="<?= base_url('administrator/posts/edit/').'/'.$p->id.'-'.$p->alias; ?>" style="font-size: 15px;"><?= $p->title; ?></a> <small class="text-muted"> (<?= $p->alias; ?>)</small><br> category: <a href="<?= base_url('posts/categories'); ?>"><?= $p->category_name; ?></a></td>
                    <td><?= $p->access; ?></td>
                    <td><small><a href="#"><?= $p->first_name.' '.$p->last_name; ?></a></small></td>
                    <td><small><?= date('jS M Y', strtotime($p->published_date)); ?></small></td>
                    <td> <span class="badge rounded-pill bg-warning"> <?= $p->hits ?> </span> </td>
                    <td> <span class="badge rounded-pill bg-secondary"> <?= $p->views; ?> </span> </td>
                    <td>
                        <?php if($p->status == 'published'):?>
                            <span class="badge rounded-pill bg-success"><?= $p->status ?></span> 
                        <?php elseif($p->status == 'unpublished'):?>
                            <span class="badge rounded-pill bg-danger"><?= $p->status ?></span>
                        <?php elseif($p->status == 'archived'):?>
                            <span class="badge rounded-pill bg-info"><?= $p->status ?></span>
                        <?php else:?>
                            <span class="badge rounded-pill bg-secodary"><?= $p->status ?></span>
                        <?php endif;?>
                    </td>
                    <td>
                    <div class="btn-group dropstart">
                    <button type="button" class="btn btn-white p-1" data-bs-toggle="dropdown" aria-expanded="false">
                    <i class="bi bi-three-dots-vertical"></i>
                    </button>
                    <ul class="dropdown-menu">
                        <li><a class="dropdown-item" href="<?= base_url('administrator/posts/view/').$p->id.'-'.$p->alias; ?>"><small>View</small></a></li>
                        <li><a class="dropdown-item" href="<?= base_url('administrator/posts/edit/').$p->id.'-'.$p->alias; ?>"><small>Edit</small></a></li>
                        <li><a class="dropdown-item"  onclick="delete_post(<?= $p->id ?>, '<?= $p->title ?>')" style="cursor: pointer"><small>Delete</small></a></li>
                        <li><a class="dropdown-item"  href="<?= base_url('administrator/posts/comments/').$p->id.'-'.$p->alias; ?>"><small>Comments</small></a></li>
                    </ul>
                    </div>
                    </td>
                    </tr>
                    <?php endforeach;?>
            </tbody>
        </table>
    </div>
</div>
</div> <!-- Container!-->         
<!---- Modals --->
<?= view('Modules\Posts\Views\\modals\\del_postsModal') ?>
<!---- JS --->
<script type="text/javascript">
      $(document).ready(function () {
          $('#postslist').DataTable({
            pageLength: 10,
            order: [[0, "Desc"]],
          });
          $('.pagesTable').DataTable({
            pageLength: 10,
            order: [[0, "Desc"]],
          });
          $('.blogTable').DataTable({
            pageLength: 10,
            order: [[0, "Desc"]],
          });
      });

</script>               
<script src="<?= base_url();?>/assets/admin_assets/js/modules/posts.js"></script>   
<?= $this->endSection();?>