<?php

namespace Modules\Posts\Models;

use CodeIgniter\Model;

class PostTagsModel extends Model
{

  protected $table = 'post_tags';
    protected $primaryKey = 'id';

    protected $allowedFields = ['tag_id', 'post_id', 'updated_at'];

    protected $returnType     = 'array';
    protected $useTimestamps  = true;
    protected $useSoftDeletes = true;
    
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';
    protected $deletedField  = 'deleted_at';

    public function getAll()
    {
        $builder = $this->db->table('post_tags');
        $builder->where('deleted_at', null);
        $results = $builder->get()->getResult();
        return $results;
    }

    //Get Tags matching the post
    public function getPostTags($post)
    {
        $builder = $this->db->table('post_tags as pt');
        $builder->select('pt.*, t.name as tag, t.alias as tag_alias,');
        $builder->join('tags as t', 't.id=pt.tag_id');
        $builder->join('posts as p', 'p.id=pt.post_id');
        $builder->where('pt.deleted_at', null);
        $builder->where('pt.post_id', $post);
        $builder->orWhere('p.alias', $post);
        $results = $builder->get()->getResult();
        return $results;
    }

    //Display TAGS within Posts
    public function getTagsInPosts()
    {
      $builder = $this->db->table('post_tags as pt');
      $builder->select('pt.*, t.name as tag, t.alias as tag_alias,');
      $builder->join('tags as t', 't.id=pt.tag_id');
      $builder->groupBy('pt.tag_id');
      $builder->orderBy('RAND()');
      $builder->limit(25);
      $results = $builder->get()->getResult();
      return $results;
    }

    //Get single Tag attached to Posts
    public function getSingleTagsInPosts($tag)
    {
      $builder = $this->db->table('post_tags as pt');
      $builder->select('p.*,pt.post_id, pt.tag_id,t.name as tag_name, pc.name as category, pc.alias as category_alias, pmc.master_category_id, pmc.name as master_category, pmc.alias as master_category_alias');
      $builder->join('tags as t', 't.id=pt.tag_id');
      $builder->join('posts as p', 'p.id=pt.post_id');
      $builder->join('post_category as pc', 'pc.id=p.category_id');
      $builder->join('post_category as pmc', 'pmc.id=pc.master_category_id');
      $builder->where('pt.tag_id', $tag);
      $builder->orWhere('t.alias', $tag);
      $results = $builder->get()->getRow();
      return $results;
    }

    public function getSingleTagsAllPosts($tag)
    {
      $builder = $this->db->table('post_tags as pt');
      $builder->select('p.*,pt.post_id, pt.tag_id,t.name as tag_name, pc.name as category, pc.alias as category_alias, pmc.master_category_id, pmc.name as master_category, pmc.alias as master_category_alias');
      $builder->join('tags as t', 't.id=pt.tag_id');
      $builder->join('posts as p', 'p.id=pt.post_id');
      $builder->join('post_category as pc', 'pc.id=p.category_id');
      $builder->join('post_category as pmc', 'pmc.id=pc.master_category_id');
      $builder->where('pt.tag_id', $tag);
      $builder->orWhere('t.alias', $tag);
      $results = $builder->get()->getResult();
      return $results;
    }
    /**
     * Remove all tags from a post
     */
    public function clearPostTags($postId)
    {
        return $this->where('post_id', $postId)->delete();
    }

    /**
     * Update post tags
     */
    public function updatePostTags($postId, $tagIds)
    {
        // Clear existing tags
        $this->clearPostTags($postId);
        
        // Add new tags
        foreach ($tagIds as $tagId) {
            $this->insert([
                'post_id' => $postId,
                'tag_id' => $tagId
            ]);
        }
        
        return true;
    }
}