<?php

namespace Modules\Posts\Models;

use CodeIgniter\Model;

class PostBlockItemsModel extends Model
{
    protected $table = 'usc_post_block_items';
    protected $primaryKey = 'id';

    protected $allowedFields = [
        'block_id', 'item_type', 'title', 'icon', 'value', 'description', 
        'width', 'photo', 'caption', 'link', 'ordering', 'status'
    ];

    protected $returnType     = 'array';
    protected $useTimestamps  = true;
    protected $useSoftDeletes = true;
    
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';
    protected $deletedField  = 'deleted_at';

    public function singleBlockItem($id)
    {
      $builder = $this->db->table('usc_post_block_items');
      $builder->select('usc_post_block_items.*, usc_post_blocks.post_id, usc_posts.alias as post_alias ')
              ->join('usc_post_blocks', 'usc_post_blocks.id=usc_post_block_items.block_id', 'left')
              ->join('usc_posts', 'usc_posts.id=usc_post_blocks.post_id', 'left')
              ->where('usc_post_block_items.id', $id);
      return $result = $builder->get()->getRow();
    }

/**
 * Get next ordering number for a given block_id
 */
public function getNextOrdering($block_id)
{
    $maxOrder = $this->where('block_id', $block_id)
                     ->selectMax('ordering')
                     ->first();

    return isset($maxOrder['ordering']) ? ($maxOrder['ordering'] + 1) : 1;
}

/**
 * Insert a new item with auto-ordering
 */
public function insertWithOrdering($data)
{
    if (!isset($data['block_id'])) {
        throw new \Exception("block_id is required.");
    }

    $data['ordering'] = $this->getNextOrdering($data['block_id']);

    return $this->insert($data);
}

/**
 * Get items grouped by item_type for a block
 */
public function getItemsGroupedByType($blockId)
{
    $items = $this->where('block_id', $blockId)
                  ->where('deleted_at', null)
                  ->orderBy('item_type', 'ASC')
                  ->orderBy('ordering', 'ASC')
                  ->findAll();

    $grouped = [];
    foreach ($items as $item) {
        $grouped[$item['item_type']][] = $item;
    }

    return $grouped;
}
}