<?php

namespace Modules\Posts\Models;

use CodeIgniter\Model;

class PageTemplatesModel extends Model
{
    protected $table = 'page_templates';
    protected $primaryKey = 'id';
    
    protected $allowedFields = [
        'name', 'slug', 'description', 'preview_image', 'template_file',
        'allowed_blocks', 'layout_type', 'category', 'settings', 'is_active',
        'service_group', 'nav_contexts', 'banner_variants', 'template_group',
        'service_group_id', 'created_by'
    ];
    
    protected $returnType = 'array';
    protected $useTimestamps = true;
    protected $useSoftDeletes = true;
    
    protected $createdField = 'created_at';
    protected $updatedField = 'updated_at';
    protected $deletedField = 'deleted_at';
    
    /**
     * Get all active templates
     */
    public function getActiveTemplates()
    {
        return $this->where('is_active', 1)
                    ->where('deleted_at', null)
                    ->findAll();
    }
    
    /**
     * Get templates by service group
     */
    public function getByServiceGroup($serviceGroup)
    {
        return $this->where('service_group', $serviceGroup)
                    ->where('is_active', 1)
                    ->where('deleted_at', null)
                    ->findAll();
    }
    
    /**
     * Get template by slug
     */
    public function getBySlug($slug)
    {
        return $this->where('slug', $slug)
                    ->where('deleted_at', null)
                    ->first();
    }
}
