<?php

namespace Modules\Posts\Models;

use CodeIgniter\Model;

class NavContextsModel extends Model
{
    protected $table = 'usc_nav_contexts';
    protected $primaryKey = 'id';
    protected $allowedFields = ['name', 'slug', 'description', 'is_active', 'created_at', 'updated_at', 'deleted_at'];
    protected $returnType = 'array';
    protected $useTimestamps = true;
    protected $createdField = 'created_at';

    public function getAll()
    {
        return $this->where('is_active', 1)->orderBy('name', 'ASC')->findAll();
    }

    public function getAllRaw()
    {
        return $this->orderBy('name', 'ASC')->findAll();
    }

    public function getBySlug($slug)
    {
        return $this->where('slug', $slug)->first();
    }
}
