<?php

namespace Modules\Posts\Models;

use CodeIgniter\Model;

class ItemTypeDefinitionsModel extends Model
{
    protected $table = 'usc_item_type_definitions';
    protected $primaryKey = 'id';

    protected $allowedFields = [
        'name', 'slug', 'description', 'icon', 'category', 
        'fields_config', 'settings_config', 
        'is_repeatable', 'max_instances', 'preview_image', 
        'is_active', 'created_by'
    ];

    protected $returnType = 'array';
    protected $useTimestamps = true;
    protected $useSoftDeletes = true;
    
    protected $createdField = 'created_at';
    protected $updatedField = 'updated_at';
    protected $deletedField = 'deleted_at';

    /**
     * Get active item type definitions
     */
    public function getActiveItemTypes()
    {
        return $this->where('is_active', 1)
                    ->where('deleted_at', null)
                    ->orderBy('name', 'ASC')
                    ->findAll();
    }

    /**
     * Get item types by category
     */
    public function getByCategory($category)
    {
        return $this->where('category', $category)
                    ->where('is_active', 1)
                    ->where('deleted_at', null)
                    ->orderBy('name', 'ASC')
                    ->findAll();
    }

    /**
     * Get item type by slug
     */
    public function getBySlug($slug)
    {
        return $this->where('slug', $slug)
                    ->where('deleted_at', null)
                    ->first();
    }

    /**
     * Get item types allowed for a block definition
     */
    public function getByBlockDefinition($blockDefinitionId)
    {
        return $this->select('itd.*, rel.is_default, rel.max_items, rel.ordering')
                    ->from('usc_item_type_definitions itd')
                    ->join('usc_block_item_type_relationships rel', 'rel.item_type_definition_id = itd.id')
                    ->where('rel.block_definition_id', $blockDefinitionId)
                    ->where('itd.is_active', 1)
                    ->where('itd.deleted_at', null)
                    ->orderBy('rel.ordering', 'ASC')
                    ->findAll();
    }
}