<?php

namespace Modules\Posts\Models;

use CodeIgniter\Model;

class BlockItemTypeRelationshipsModel extends Model
{
    protected $table = 'usc_block_item_type_relationships';
    protected $primaryKey = 'id';

    protected $allowedFields = [
        'block_definition_id', 'item_type_definition_id', 
        'is_default', 'max_items', 'ordering'
    ];

    protected $returnType = 'array';
    protected $useTimestamps = true;
    
    protected $createdField = 'created_at';
    protected $updatedField = 'updated_at';

    /**
     * Get relationships for a block definition
     */
    public function getByBlockDefinition($blockDefinitionId)
    {
        return $this->where('block_definition_id', $blockDefinitionId)
                    ->orderBy('ordering', 'ASC')
                    ->findAll();
    }

    /**
     * Get relationships for an item type
     */
    public function getByItemType($itemTypeDefinitionId)
    {
        return $this->where('item_type_definition_id', $itemTypeDefinitionId)
                    ->findAll();
    }

    /**
     * Check if relationship exists
     */
    public function relationshipExists($blockDefinitionId, $itemTypeDefinitionId)
    {
        return $this->where('block_definition_id', $blockDefinitionId)
                    ->where('item_type_definition_id', $itemTypeDefinitionId)
                    ->first();
    }
}