<?php

namespace Modules\Posts\Models;

use CodeIgniter\Model;

class BlockDefinitionsModel extends Model
{
    protected $table = 'block_definitions';
    protected $primaryKey = 'id';

    protected $allowedFields = [
        'name', 'slug', 'description', 'icon', 'category', 
        'fields_config', 'settings_config', 'template_file', 
        'is_repeatable', 'max_instances', 'preview_image', 
        'is_active', 'created_by'
    ];

    protected $returnType     = 'array';
    protected $useTimestamps  = true;
    protected $useSoftDeletes = true;
    
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';
    protected $deletedField  = 'deleted_at';

    /**
     * Get active block definitions
     */
    public function getActiveBlocks()
    {
        return $this->where('is_active', 1)
                    ->where('deleted_at', null)
                    ->orderBy('name', 'ASC')
                    ->findAll();
    }

    /**
     * Get blocks by category
     */
    public function getByCategory($category)
    {
        return $this->where('category', $category)
                    ->where('is_active', 1)
                    ->where('deleted_at', null)
                    ->orderBy('name', 'ASC')
                    ->findAll();
    }

    /**
     * Get block definition by slug
     */
    public function getBySlug($slug)
    {
        return $this->where('slug', $slug)
                    ->where('deleted_at', null)
                    ->first();
    }
}
