<?php
namespace Modules\Posts\Controllers;

use App\Controllers\Auth\AuthController;
use Modules\Posts\Models\NavContextsModel;
use Modules\Posts\Models\ServiceGroupsModel;

class ContextManagerController extends AuthController
{
    public function index()
    {
        $navContextsModel = new NavContextsModel();
        $serviceGroupsModel = new ServiceGroupsModel();
        // Use AuthController's $this->data for notifications and user info
        $this->data['nav_contexts'] = $navContextsModel->getAllRaw();
        $this->data['service_groups'] = $serviceGroupsModel->getAll();
        $this->data['title'] = 'Context Manager';
        $this->data['bcrumb'] = 'Context Manager';
        return view('Modules\\Posts\\Views\\context_manager\\index', $this->data);
    }

    /** Nav Contexts CRUD */
    public function createNavContext()
    {
        if ($this->request->getMethod() != 'post') {
            return redirect()->to('administrator/posts/context-manager');
        }
        $name = $this->request->getVar('name');
        if (empty($name)) {
            session()->setTempdata('error', 'Name required', 3);
            return redirect()->back();
        }
        $slug = preg_replace('/[^a-z0-9]+/i', '-', trim(strtolower($name)));
        $navContextsModel = new NavContextsModel();
        $data = [
            'name' => $name,
            'slug' => $slug,
            'description' => $this->request->getVar('description'),
            'is_active' => 1,
            'created_at' => date('Y-m-d H:i:s')
        ];
        if ($navContextsModel->save($data)) {
            session()->setTempdata('success', 'Nav Context added', 3);
        }
        return redirect()->to('administrator/posts/context-manager');
    }

    public function editNavContext($id = null)
    {
        $navContextsModel = new NavContextsModel();
        $this->data['singleNavContext'] = $navContextsModel->where('id', $id)->first();
        // load index with singleNavContext to show edit form
        return $this->index();
    }

    public function updateNavContext()
    {
        if ($this->request->getMethod() != 'post') {
            return redirect()->to('administrator/posts/context-manager');
        }
        $id = $this->request->getVar('id');
        $name = $this->request->getVar('name');
        if (empty($name) || empty($id)) {
            session()->setTempdata('error', 'Invalid data', 3);
            return redirect()->back();
        }
        $slug = preg_replace('/[^a-z0-9]+/i', '-', trim(strtolower($name)));
        $navContextsModel = new NavContextsModel();
        $data = [
            'name' => $name,
            'slug' => $slug,
            'description' => $this->request->getVar('description'),
            'updated_at' => date('Y-m-d H:i:s')
        ];
        if ($navContextsModel->update($id, $data)) {
            session()->setTempdata('success', 'Nav Context updated', 3);
        }
        return redirect()->to('administrator/posts/context-manager');
    }

    public function deleteNavContext($id)
    {
        $navContextsModel = new NavContextsModel();
        if ($navContextsModel->delete($id)) {
            session()->setTempdata('success', 'Nav Context deleted', 3);
        }
        return redirect()->to('administrator/posts/context-manager');
    }

    /** Service Groups CRUD */
    public function createServiceGroup()
    {
        if ($this->request->getMethod() != 'post') {
            return redirect()->to('administrator/posts/context-manager');
        }
        $name = $this->request->getVar('name');
        if (empty($name)) {
            session()->setTempdata('error', 'Name required', 3);
            return redirect()->back();
        }
        $slug = preg_replace('/[^a-z0-9]+/i', '-', trim(strtolower($name)));
        $serviceGroupsModel = new ServiceGroupsModel();
        $data = [
            'name' => $name,
            'slug' => $slug,
            'description' => $this->request->getVar('description'),
            'is_active' => 1,
            'created_at' => date('Y-m-d H:i:s'),
            'created_by' => $this->userdata->user_id ?? null,
        ];
        if ($serviceGroupsModel->insert($data)) {
            $newId = $serviceGroupsModel->getInsertID();
            $selected = $this->request->getVar('nav_contexts');
            $serviceGroupsModel->setNavContexts($newId, is_array($selected) ? $selected : []);
            session()->setTempdata('success', 'Service Group added', 3);
        }
        return redirect()->to('administrator/posts/context-manager');
    }

    public function editServiceGroup($id = null)
    {
        $serviceGroupsModel = new ServiceGroupsModel();
        $this->data['singleServiceGroup'] = $serviceGroupsModel->where('id', $id)->first();
        // load nav context selections
        $db = \Config\Database::connect();
        $rows = $db->table('usc_service_group_nav_contexts')->where('service_group_id', $id)->get()->getResultArray();
        $this->data['singleServiceGroupNavs'] = array_column($rows, 'nav_context_id');
        return $this->index();
    }

    public function updateServiceGroup()
    {
        if ($this->request->getMethod() != 'post') {
            return redirect()->to('administrator/posts/context-manager');
        }
        $id = $this->request->getVar('id');
        $name = $this->request->getVar('name');
        if (empty($name) || empty($id)) {
            session()->setTempdata('error', 'Invalid data', 3);
            return redirect()->back();
        }
        $slug = preg_replace('/[^a-z0-9]+/i', '-', trim(strtolower($name)));
        $serviceGroupsModel = new ServiceGroupsModel();
        $data = [
            'name' => $name,
            'slug' => $slug,
            'description' => $this->request->getVar('description'),
            'updated_at' => date('Y-m-d H:i:s')
        ];
        if ($serviceGroupsModel->update($id, $data)) {
            $selected = $this->request->getVar('nav_contexts');
            $serviceGroupsModel->setNavContexts($id, is_array($selected) ? $selected : []);
            session()->setTempdata('success', 'Service Group updated', 3);
        }
        return redirect()->to('administrator/posts/context-manager');
    }

    public function deleteServiceGroup($id)
    {
        $serviceGroupsModel = new ServiceGroupsModel();
        if ($serviceGroupsModel->delete($id)) {
            session()->setTempdata('success', 'Service Group deleted', 3);
        }
        return redirect()->to('administrator/posts/context-manager');
    }

    /** AJAX: groups for nav context */
    public function groupsByNavContext($slug = null)
    {
        $out = [];
        if (empty($slug)) {
            return $this->response->setJSON($out);
        }
        try {
            $serviceGroupsModel = new ServiceGroupsModel();
            $groups = $serviceGroupsModel->getByNavContext($slug);
            return $this->response->setJSON($groups);
        } catch (\Exception $e) {
            return $this->response->setStatusCode(500)->setJSON(['error' => $e->getMessage()]);
        }
    }
}
