<?php

namespace Modules\Posts\Config;

use Config;
// Create a new instance of our RouteCollection class.
$routes = Config\Services::routes();

// Load the system's routing file first, so that the app and ENVIRONMENT
// can override as needed.
if (is_file(SYSTEMPATH . 'Config/Routes.php')) {
    require SYSTEMPATH . 'Config/Routes.php';
}

// =====================================================================
// BLOCKS ROUTES (OUTSIDE PERMISSION SCOPE FOR TESTING)
// =====================================================================
$routes->group('administrator/posts', ['namespace' => 'Modules\Posts\Controllers'], static function($routes){
    // Main blocks management page
    $routes->GET('blocks', 'BlocksController::index');

    // Block Definitions
    $routes->GET('blocks/definitions/active', 'BlocksController::getActiveDefinitions');
    $routes->GET('blocks/definition/(:num)', 'BlocksController::getBlockDefinition/$1');
    $routes->POST('blocks/definition/add', 'BlocksController::addBlockDefinition');
    $routes->POST('blocks/definition/update', 'BlocksController::updateBlockDefinition');
    $routes->POST('blocks/definition/delete/(:num)', 'BlocksController::deleteBlockDefinition/$1');

    // Blocks
    $routes->POST('blocks/add', 'BlocksController::addBlock');
    $routes->GET('blocks/(:num)', 'BlocksController::getBlock/$1');
    $routes->GET('block/(:num)', 'BlocksController::viewBlock/$1'); // New route for viewing block details
    $routes->POST('blocks/update', 'BlocksController::updateBlock');
    $routes->POST('blocks/update-order', 'BlocksController::updateBlockOrder');
    $routes->POST('blocks/delete/(:num)', 'BlocksController::deleteBlock/$1');

    // Block Items
    $routes->GET('blocks/items/(:num)', 'BlocksController::getBlockItems/$1');
    $routes->GET('blocks/item/(:num)', 'BlocksController::getBlockItem/$1');
    $routes->POST('blocks/item/add', 'BlocksController::addBlockItem');
    $routes->POST('blocks/item/update', 'BlocksController::updateBlockItem');
    $routes->POST('blocks/item/update-order', 'BlocksController::updateItemOrder');
    $routes->POST('blocks/item/delete/(:num)', 'BlocksController::deleteBlockItem/$1');

    // Item Type Definitions
    $routes->GET('blocks/item-type/(:num)', 'BlocksController::getItemType/$1');
    $routes->GET('blocks/item-type/view/(:num)', 'BlocksController::viewItemType/$1');
    $routes->POST('blocks/item-type/add', 'BlocksController::addItemType');
    $routes->POST('blocks/item-type/update', 'BlocksController::updateItemType');
    $routes->POST('blocks/item-type/delete/(:num)', 'BlocksController::deleteItemType/$1');
});

// =====================================================================
// POSTS ROUTES (WITH PERMISSION FILTERS)
// =====================================================================
$routes->group('administrator/posts', ['filter' => ['isLoggedIn',  'checkPermission'], 'namespace' => 'Modules\Posts\Controllers'], static function($routes){

    $routes->GET('/', 'Posts::index');
    $routes->GET('add', 'Posts::addPost');
    $routes->POST('add', 'Posts::addPost');
    $routes->GET('edit/(:any)', 'Posts::editPost/$1');
    $routes->POST('update', 'Posts::updatePost');
    $routes->GET('view/(:any)', 'Posts::viewPost/$1');
    $routes->GET('delete/(:any)', 'Posts::delPost/$1');

    // Block Posts (posts using block editor)
    $routes->GET('block-posts', 'Posts::allBlockPosts');
    $routes->GET('block-post/add', 'Posts::addBlockPost');
    $routes->POST('block-post/add', 'Posts::addBlockPost');
    $routes->GET('block-post/edit/(:any)', 'Posts::editBlockPost/$1');
    $routes->POST('block-post/update', 'Posts::updateBlockPost');
    $routes->GET('block-post/view/(:any)', 'Posts::viewBlockPost/$1');
    $routes->GET('block-post/delete/(:any)', 'Posts::delBlockPost/$1');

    $routes->POST('block/save', 'BlockPosts::saveBlock');
    $routes->GET('block/get-block/(:any)', 'BlockPosts::getBlock/$1');
    $routes->GET('block/delete/(:any)', 'BlockPosts::deleteBlock/$1');

    $routes->POST('block/items/save', 'BlockPosts::saveChildItem');
    $routes->GET('block/items/get-block/(:any)', 'BlockPosts::getChildItem/$1');
    $routes->GET('block/items/delete/(:any)', 'BlockPosts::deleteChildItem/$1');


    $routes->GET('block-post/text/edit/(:num)', 'BlockPosts::editTextBlock/$1');
    $routes->GET('block-post/heading/edit/(:num)', 'BlockPosts::editHeadingBlock/$1');
    $routes->GET('block-post/list/edit/(:num)', 'BlockPosts::editListBlock/$1');
    $routes->GET('block-post/image/edit/(:num)', 'BlockPosts::editImageBlock/$1');
    $routes->GET('block-post/video/edit/(:num)', 'BlockPosts::editVideoBlock/$1');
    $routes->GET('block-post/code/edit/(:num)', 'BlockPosts::editCodeBlock/$1');
    $routes->GET('block-post/advertcode/edit/(:num)', 'BlockPosts::editAdvertCodeBlock/$1');

    $routes->POST('block-post/text/update', 'BlockPosts::updateTextBlock');
    $routes->POST('block-post/heading/update', 'BlockPosts::updateHeadingBlock');
    $routes->POST('block-post/list/update', 'BlockPosts::updateListBlock');
    $routes->POST('block-post/image/update', 'BlockPosts::updateImageBlock');
    $routes->POST('block-post/video/update', 'BlockPosts::updateVideoBlock');
    $routes->POST('block-post/code/update', 'BlockPosts::updateCodeBlock');
    $routes->POST('block-post/advertcode/update', 'BlockPosts::updateAdvertCodeBlock');

    $routes->GET('block-post/text/delete/(:num)', 'BlockPosts::deleteTextBlock/$1');
    $routes->GET('block-post/heading/delete/(:num)', 'BlockPosts::deleteHeadingBlock/$1');
    $routes->GET('block-post/list/delete/(:num)', 'BlockPosts::deleteListBlock/$1');
    $routes->GET('block-post/image/delete/(:num)', 'BlockPosts::deleteImageBlock/$1');
    $routes->GET('block-post/video/delete/(:num)', 'BlockPosts::deleteVideoBlock/$1');
    $routes->GET('block-post/code/delete/(:num)', 'BlockPosts::deleteCodeBlock/$1');
    $routes->GET('block-post/advertcode/delete/(:num)', 'BlockPosts::deleteAdvertCodeBlock/$1');

    $routes->GET('categories', 'Posts::postCategories');
    $routes->POST('categories/add', 'Posts::addCategory');
    $routes->GET('categories/edit/(:any)', 'Posts::editCategory/$1');
    $routes->POST('categories/update',  'Posts::updateCategory');
    $routes->GET('categories/delete/(:any)', 'Posts::delCategory/$1');

    // Comments
    $routes->GET('comments', 'Posts::allPostComments');
    $routes->POST('comments/add', 'Posts::addPostComment');
    $routes->GET('comments/edit/(:num)', 'Posts::editPostComment/$1');
    $routes->POST('comments/update', 'Posts::updatePostComment');
    $routes->GET('comments/delete/(:num)', 'Posts::deletePostComment/$1');

    // Tags
    $routes->GET('tags', 'Tags::index');
    $routes->GET('tags/list', 'Tags::getTagsList');
    $routes->GET('tags/search', 'Tags::searchTags');
    $routes->POST('tags/add', 'Tags::addTag');
    $routes->GET('tags/edit/(:any)', 'Tags::editTag/$1');
    $routes->POST('tags/update', 'Tags::updateTag');
    $routes->GET('tags/delete/(:any)', 'Tags::delTag/$1');

    // Context Manager unified route
    $routes->GET('context-manager', 'ContextManagerController::index');
    // Nav Contexts
    $routes->POST('context-manager/nav-contexts/add', 'ContextManagerController::createNavContext');
    $routes->GET('context-manager/nav-contexts/edit/(:num)', 'ContextManagerController::editNavContext/$1');
    $routes->POST('context-manager/nav-contexts/update', 'ContextManagerController::updateNavContext');
    $routes->GET('context-manager/nav-contexts/delete/(:num)', 'ContextManagerController::deleteNavContext/$1');
    // Service Groups
    $routes->POST('context-manager/service-groups/add', 'ContextManagerController::createServiceGroup');
    $routes->GET('context-manager/service-groups/edit/(:num)', 'ContextManagerController::editServiceGroup/$1');
    $routes->POST('context-manager/service-groups/update', 'ContextManagerController::updateServiceGroup');
    $routes->GET('context-manager/service-groups/delete/(:num)', 'ContextManagerController::deleteServiceGroup/$1');
    // AJAX
    $routes->GET('context-manager/nav-context-groups/(:any)', 'ContextManagerController::groupsByNavContext/$1');

});

// =====================================================================
// STANDALONE ROUTES FOR TAGS (OUTSIDE PERMISSION GROUP FOR AJAX ACCESS)
// =====================================================================
$routes->group('administrator', ['filter' => 'isLoggedIn', 'namespace' => 'Modules\Posts\Controllers'], function($routes) {
    $routes->GET('tags/list', 'Tags::getTagsList');
    $routes->GET('tags/search', 'Tags::searchTags');
    $routes->POST('tags/add', 'Tags::addTag');
});

// =====================================================================
// API ROUTES (OUTSIDE PERMISSION GROUP FOR AJAX ACCESS)
// =====================================================================
$routes->group('administrator/posts/api', ['namespace' => 'Modules\Posts\Controllers'], function ($routes) {
    // Block Item Types API
    $routes->GET('blocks/(:num)/item-types', 'BlocksController::getAvailableItemTypes/$1');
    $routes->GET('icons', 'BlocksController::getIcons');

    // Block-specific item types
    $routes->GET('blocks/(:num)/available-item-types', 'BlocksController::getAvailableItemTypes/$1');
});

// =====================================================================
// PAGES ROUTES (WITH PERMISSION FILTERS)
// =====================================================================
$routes->group('administrator/pages', ['filter' => ['isLoggedIn',  'checkPermission'], 'namespace' => 'Modules\Posts\Controllers'], static function($routes){

    $routes->GET('/', 'Pages::index');
    $routes->GET('add', 'Pages::addPage');
    $routes->POST('add', 'Pages::addPage');
    $routes->GET('edit/(:any)', 'Pages::editPage/$1');
    $routes->POST('update', 'Pages::updatePage');
    $routes->GET('view/(:any)', 'Pages::viewPage/$1');
    $routes->GET('delete/(:any)', 'Pages::delPage/$1');

    $routes->GET('block-pages', 'Pages::viewBlockPages');
    $routes->GET('block-page/add', 'Pages::addBlockPage');

    // AJAX endpoint for service groups filtering (now handled by ContextManager)
    $routes->GET('nav-context-groups/(:any)', 'ContextManagerController::groupsByNavContext/$1');

});