<?= $this->extend('Modules\Admin\Views\index'); ?>
<?= $this->section('content');?>
<div class="container-fluid">
    <div class="row mb-md-3">
        <div class="col">
            <h4>Edit Menu Item</h4>
            <nav aria-label="breadcrumb"><small>
                <ol class="breadcrumb mb-0">
                    <li class="breadcrumb-item"><a href="<?= base_url('administrator') ?>">Home</a></li>
                    <li class="breadcrumb-item"><a href="<?= base_url('administrator/menu/group/'.$menuItem->category_alias); ?>"><?= $menuItem->menu_category ?></a></li>
                    <li class="breadcrumb-item active" aria-current="page"><?= esc($bcrumb) ?></li>
                </ol></small>
            </nav>
        </div>
    </div>

    <div class="row">
        <div class="col">
            <?php if(session()->getTempdata('success')): ?>
                <div class="alert alert-success" role="alert"><?= session()->getTempdata('success');?></div>
            <?php endif;?>
            <?php if(session()->getTempdata('error')): ?>
                <div class="alert alert-danger" role="alert"><?= session()->getTempdata('error');?></div>
            <?php endif;?>
            <div id="showMsg"></div>
        </div>
    </div>

    <div class="card card-body">
        <div class="mb-2">
            <h5>&nbsp; 
                <span class="float-end">
                    <a href="<?= base_url('administrator/menu/groups'); ?>" class="btn btn-sm btn-dark rounded-0 float-sm-end">Back to Groups</a> 
                    <a href="<?= base_url('administrator/menu/group/'.$menuItem->category_alias); ?>" class="btn btn-sm btn-warning rounded-0 float-sm-end">Back to <?= $menuItem->menu_category; ?></a>
                </span>
            </h5>
        </div>
        
        <div class="alert alert-success">
            <strong>Edit Menu</strong>:  
            <small>Edit menus based on content types from your database. The available options will change dynamically based on your selection.</small>
        </div>
        
        <?= form_open('administrator/menu/item/edit/'.$menuItem->id, ['id' => 'menuForm']); ?>
        <div class="row g-md-5">
            <div class="col-lg-6 col-md-7">
                <div class="mb-3">
                    <label class="form-label fw-bold" for="name">Name *</label>
                    <input type="text" class="form-control" name="title" value="<?= $menuItem->title; ?>" placeholder="Add Menu Name" required/>
                </div>
                
                <div class="mb-3">
                    <label class="form-label fw-bold" for="menuType">Content Type</label>
                <select class="form-select" name="menu_type" id="menuType" required>
                    <option value="">Select Content Type</option>
                    <?php foreach($contentTypes as $type): ?>
                        <?php
                        // Map database slugs back to legacy slugs for JS compatibility
                        $jsSlug = $type['slug'];
                        if ($type['slug'] === 'blog') {
                            $jsSlug = 'post'; // JS expects 'post' for blog content
                        }
                        $selected = '';
                        if ($menuItem->menu_type == $jsSlug || ($menuItem->menu_type == 'post' && $type['slug'] == 'blog')) {
                            $selected = 'selected';
                        }
                        ?>
                        <option value="<?= $jsSlug ?>" <?= $selected ?>>
                            <?= $type['name'] ?>
                        </option>
                    <?php endforeach; ?>
                    <option value="category" <?= $menuItem->menu_type == 'category' ? 'selected' : '' ?>>Category</option>
                    <option value="custom" <?= $menuItem->menu_type == 'custom' ? 'selected' : '' ?>>Custom Link</option>
                </select>
                </div>

                <!-- Dynamic Content Selection -->
                <div id="contentOptions" class="mb-3" style="display: none;">
                    <label class="form-label fw-bold">Select Content</label>
                    <div id="contentDropdown">
                        <!-- Will be populated dynamically -->
                    </div>
                </div>

                <!-- Custom Link Input -->
                <div id="customLinkOptions" class="mb-3" style="display: none;">
                    <label class="form-label fw-bold">Custom Link</label>
                    <input type="text" name="custom" value="<?= $menuItem->menu_type == 'custom' ? $menuItem->link : '' ?>" class="form-control" placeholder="https://example.com/page" />
                </div>
            </div>

            <div class="col-lg-4 col-md-5">
                <div class="mb-3">
                    <label class="form-label fw-bold">Menu Category</label>
                    <select class="form-select" name="category_id" id="menuCategory" required>
                        <option value="">Select Menu Category</option>
                        <?php foreach($menuGroups as $group):?>
                        <option value="<?= $group->id ?>" <?= $menuItem->category_id == $group->id ? 'selected' : '' ?>>
                            <?= $group->name ?>
                        </option>
                        <?php endforeach; ?>
                    </select>
                </div>

                <div class="mb-3">
                    <label class="form-label fw-bold">Parent Menu Item</label>
                    <select class="form-select" name="parent_id" id="parentMenu">
                        <option value="">Select Parent</option>
                        <?php foreach($menus as $m):?>
                        <option value="<?= $m->id ?>" <?= $menuItem->parent_id == $m->id ? 'selected' : '' ?>>
                            <?= $m->title ?> (Level <?= $m->level ?>)
                        </option>
                        <?php endforeach; ?>
                    </select>
                </div>

                <div class="mb-3">
                    <label class="form-label fw-bold">Level</label>
                    <select class="form-select" name="level">
                        <option value="1" <?= $menuItem->level == 1 ? 'selected' : '' ?>>Level 1</option>
                        <option value="2" <?= $menuItem->level == 2 ? 'selected' : '' ?>>Level 2</option>
                        <option value="3" <?= $menuItem->level == 3 ? 'selected' : '' ?>>Level 3</option>
                        <option value="4" <?= $menuItem->level == 4 ? 'selected' : '' ?>>Level 4</option>
                    </select>
                </div>

                <div class="mb-3">
                    <label class="form-label fw-bold">Status</label>
                    <div class="form-check form-switch">
                        <input class="form-check-input" type="checkbox" name="status_toggle" id="statusToggle" 
                            value="1" <?= $menuItem->status == 1 ? 'checked' : '' ?>>
                        <label class="form-check-label" for="statusToggle">
                            <span id="statusText"><?= $menuItem->status == 1 ? 'Active' : 'Inactive' ?></span>
                        </label>
                    </div>
                    <input type="hidden" name="status" id="statusValue" value="<?= (int)$menuItem->status ?>">
                </div>

                <div class="mb-3">
                    <label class="form-label fw-bold">Access</label>
                    <select name="access" class="form-select">
                        <option value="Public" <?= $menuItem->access == 'Public' ? 'selected' : '' ?>>Public</option>
                        <option value="Private" <?= $menuItem->access == 'Private' ? 'selected' : '' ?>>Private</option>
                        <option value="Users" <?= $menuItem->access == 'Users' ? 'selected' : '' ?>>Users</option>
                    </select>
                </div>
            </div>
            
            <div class="col-lg-2 col-md-2 col-sm-12 d-none d-lg-block">
                <div class="alert alert-primary">
                    <h5>NOTE</h5>
                    <p>To edit a menu, ensure the Menu category is selected and proper menu type picked. Levels are critically important in menu structure.</p>
                </div>
            </div>
        </div>

        <div class="row">
            <div class="col-lg-12 col-md-12 col-sm-12 mb-3">
                <label class="form-label fw-bold">Menu Link</label>
                <input type="text" class="form-control form-control-lg" name="link" id="menu_link_preview" 
                    value="<?= $menuItem->link ?>" placeholder="Link will be generated automatically" readonly/>
            </div>
            
            <div class="col-lg-12 col-md-12 col-sm-12">
                <input type="hidden" name="id" value="<?= $menuItem->id; ?>" />
                <button type="reset" class="btn btn-lg btn-secondary">Reset</button>
                <button type="submit" class="btn btn-lg btn-danger">Update Menu Item</button>
            </div>
        </div>
        <?= form_close(); ?>
    </div>
</div>

<script>
window.baseUrl = '<?= base_url() ?>';
</script>

<script>
// Initialize menu item data for JavaScript
window.menuItemData = {
    menu_type: '<?= $menuItem->menu_type ?>',
    post_id: '<?= $menuItem->post_id ?>',
    post_cat: '<?= $menuItem->post_cat ?>',
    parent_id: '<?= $menuItem->parent_id ?>',
    link: '<?= $menuItem->link ?>'
};
</script>

<script src="<?= base_url();?>/assets/admin_assets/js/modules/admin-menu.js"></script>  
<?= $this->endSection();?>