<?= $this->extend('Modules\Admin\Views\index'); ?>
<?= $this->section('content');?>
<div class="container-fluid">
<div class="row mb-md-3">
	<div class="col">
		<h4>Menu Groups</h4>
		<!-- Breadcrumb !-->
		<nav aria-label="breadcrumb"><small>
			<ol class="breadcrumb mb-0">
				<li class="breadcrumb-item"><a href="<?= base_url('administrator') ?> ">Home</a></li>
				<li class="breadcrumb-item active" aria-current="page"><?= esc($bcrumb) ?> </li>
			</ol></small>
		</nav>
		<!-- End Breadcrumb !-->
	</div>
</div>
<!-- Menu Types ADD/EDIT/DELETE/Detailed List !-->
<div class="row">
    <div class="col">
		<!-- print success message !-->
		<?php if(session()->getTempdata('success')): ?>
			<div class="alert alert-success" role="alert"><?= session()->getTempdata('success');?></div>
		<?php endif;?>
		<!-- print failure message !-->
		<?php if(session()->getTempdata('error')): ?>
			<div class="alert alert-danger" role="alert"><?= session()->getTempdata('error');?></div>
		<?php endif;?>
        <div id="showMsg"></div>
</div></div>
<div class="row">
    <div class="col-lg-4"> 
        <div class="card">
                <?php if(!isset($singleGroup)):?>
				<div class="card-header"><h6 class="card-title fw-bold">Add Menu Group</h6></div>
				<div class="card-body ">
                <!-- Add Category  !-->
                <form method="POST" action="<?= base_url('administrator/menu/group/add');?>">
                <?= csrf_field();?>
                <div class="row">
                    <div class="mb-3">
                        <label class="form-label">Category Name</label>
                        <input type="text" class="form-control" name="name">
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Description</label>
                        <textarea class="form-control" name="description" style="height: 80px;"></textarea>
                    </div>
                    <div class="mb-3">
                        <button type="submit" class="btn btn-outline-danger w-100" >Save</button>
                    </div>
                </div>
                </form>
            </div>
                <!-- End Add Category  !-->
                <?php else:?>
                <div class="card-header"><h6 class="card-title fw-bold">Edit Menu Group</h6></div>
                <div class="card-body ">
                <!-- Edit Category  !-->
                    <form method="POST" action="<?= base_url('administrator/menu/group/update');?>">
                    <?= csrf_field(); ?>
                    <div class="row">
                        <div class="mb-3">
                            <label class="form-label">Category Name</label>
                            <input type="text" class="form-control" name="name" value="<?= $singleGroup['name']; ?>">
                        </div>
                        <div class="mb-3">
                            <label class="form-label">Description</label>
                            <textarea class="form-control" name="description" style="height: 80px;"><?= $singleGroup['description']; ?></textarea>
                        </div>
                        <div class="mb-3">
                            <input type="hidden" name="id" value="<?= $singleGroup['id']; ?>" >
                            <button type="submit" class="btn btn-outline-danger w-100" >Edit</button>
                        </div>
                    </div>
                    </form>
                <!-- End Edit Category  !-->
                </div>
                <?php endif; ?>
        </div>
    </div>
    <div class="col-lg-8 "> 
        <!-- Display all categories !-->
        <div class="card">
        <div class="card-header"><h6 class="card-title fw-bold">Menu Groups <a href="<?= base_url('administrator/menu/item/add') ?>" class="btn btn-sm btn-primary float-sm-end">Add Menu</a></span></h6></div> 
            <div class="card-body">
        <div class="table-responsive">
            <table id="catlist" class="table table-hover">
                <thead class="bg-primary bg-opacity-10" style="font-size: 14px;">
                    <tr>
                    <th>#</th>
                    <th>Type</th>
                    <th><i class="bi bi-check-lg text-success fw-bold"></i></th>
                    <th><i class="bi bi-x-circle-fill text-danger"></i></th>
                    <th><i class="bi bi-hdd-fill"></i></th>
                    <th><i class="bi bi-trash"></i></th>
                    <th>Menu Items</th>
                    <th></th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach($menu_types as $mt): ?>
                        <tr>
                        <td><?= $mt->id; ?></td>
                        <td><a href="<?= base_url('administrator/menu/group/').'/'.$mt->alias; ?>"><?= $mt->name; ?></a> <small class="text-muted"> (<?= $mt->alias; ?>)</small></td>
                        <?php 
                        // Get menu statistics for this group using MenusModel
                        $menuStats = model('Modules\Menu\Models\MenusModel')->getMenuStats($mt->id);
                        ?>
                        <td> <span class="badge rounded-pill bg-success"><?= $menuStats->active ?? 0 ?></span> </td>
                        <td> <span class="badge rounded-pill bg-danger"><?= $menuStats->inactive ?? 0 ?></span> </td>
                        <td> <span class="badge rounded-pill bg-secondary"><?= $menuStats->total_items ?? 0 ?></span> </td>
                        <td> <span class="badge rounded-pill bg-dark"><?= $menuStats->deleted ?? 0 ?></span> </td>
                        <td>
                        <a href="<?= base_url('administrator/menu/group/').$mt->alias; ?>" class="btn btn-sm btn-warning">Menu Items</a>
                        </td>
                        <td>
                            <div class="btn-group dropstart">
                            <button type="button" class="btn btn-white p-1" data-bs-toggle="dropdown" aria-expanded="false">
                            <i class="bi bi-three-dots-vertical"></i>
                            </button>
                            <ul class="dropdown-menu">
                                <li><a class="dropdown-item" href="<?= base_url('administrator/menu/group/edit/').$mt->id; ?>"><small>Edit</small></a></li>
                                <!--<li><a  class="dropdown-item" onclick="delete_menuType(<?= $mt->id ?>, '<?= $mt->name ?>')"><small>Delete</small></a></li>!-->
                            </ul>
                            </div>
                        </td>
                        </tr>
                    <?php endforeach;?>
                </tbody>
            </table>
        </div>
    </div></div>
            
<!-- END Menu Category ADD/EDIT/DELETE/Detailed List !-->
<!-- Modals !-->
<?= view('Modules\Menu\Views\\modals\\del_menuCatModal') ?>
<!---- JS --->  
<!-- Initialize DataTable before loading admin-menu.js -->
<script type="text/javascript">
    // Destroy existing DataTable instance if it exists
    if ($.fn.DataTable.isDataTable('#catlist')) {
        $('#catlist').DataTable().destroy();
    }
    // Initialize new DataTable
    $('#catlist').DataTable({
        pageLength: 10,
        order: [[0, "desc"]],
        language: {
            search: "_INPUT_",
            searchPlaceholder: "Search..."
        }
    });
</script>        
<script src="<?= base_url();?>/assets/admin_assets/js/modules/admin-menu.js"></script>  
<?= $this->endSection();?>