<?php

namespace Modules\Menu\Models;

use CodeIgniter\Model;

class MenusModel extends Model
{

    protected $table = 'usc_menu';
    protected $primaryKey = 'id';

    protected $allowedFields = ['title', 'alias', 'photo', 'category_id', 'menutype_id', 'menu_type', 'description', 'parent_id', 'ordering', 'status', 'path', 'post_id', 'post_cat', 'link', 'level',  'created_by', 'updated_at', 'updated_by'];

    protected $useTimestamps  = true;
    protected $useSoftDeletes = true;
    
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';
    protected $deletedField  = 'deleted_at';

    private $menu = "usc_menu";
    public function __construct()
    {
        parent::__construct();
        $this->db = db_connect();
        //ini_set('max_execution_time', 44540);
        //ini_set('memory_limit', '2048M');

    }

    //Get all Menus
    public function getAll()
    {
      $builder = $this->db->table('usc_menu');
      $builder->where('deleted_at', null);
      $builder->orderBy('id', 'DESC');
		  $result = $builder->get()->getResult();
		  return $result;
    }

    //Get Single Menu Item
     public function singleMenuItem($item)
    {
        $builder = $this->db->table('usc_menu as m');
        $builder->select('m.*, mt.name as menu_category, mt.alias as category_alias');
        $builder->join('usc_menu_type as mt', 'mt.id = m.category_id');
        $builder->where('m.id', $item);
        return $builder->get()->getRow();
    }

    //Get Menu Items by Type and Context
   // Get menu items by type and context
    public function getMenuByType($menuType = 'main-menu', $context = 'header')
    {
        $builder = $this->db->table('usc_menu as m');
        $builder->select('m.*, mt.name as menu_category, mt.alias as category_alias');
        $builder->join('usc_menu_type as mt', 'mt.id = m.category_id');
        $builder->where('m.deleted_at', null);
        $builder->where('m.status', 1);
        $builder->where('mt.alias', $menuType);
        $builder->orderBy('m.ordering', 'asc');
        return $builder->get()->getResult();
    }

    //Get Top Bar Menu Items
    public function getTopBarMenu()
    {
        return $this->getMenuByType('personal-menu', 'header');
    }

    //Get Main Navigation Menu Items
    public function getMainNavMenu($menuType = 'personal-menu')
    {
        return $this->getMenuByType($menuType, 'header');
    }

    //Get Footer Menu Items
    public function getFooterMenu()
    {
        return $this->getMenuByType('footer-quick-links', 'footer');
    }

    //Get Business Menu Items
    public function getBusinessMenu()
    {
        return $this->getMenuByType('business-menu', 'header');
    }

    //Get Social Media Menu Items
    public function getSocialMediaMenu()
    {
        return $this->getMenuByType('social-media', 'footer');
    }

    //Get Menu Items by Parent ID (for submenus)
    public function getSubMenu($parentId)
    {
        return $this->where('deleted_at', null)
                   ->where('status', 1)
                   ->where('parent_id', $parentId)
                   ->orderBy('ordering', 'asc')
                   ->findAll();
    }

    //Get Menu Tree Structure
    public function getMenuTree($menuType = 'main-nav')
    {
        $menuItems = $this->getMenuByType($menuType);

        $menuTree = [];
        foreach ($menuItems as $item) {
            if ($item->level == 1) {
                $menuTree[$item->id] = $item;
                $menuTree[$item->id]->children = $this->getSubMenu($item->id);
            }
        }

        return $menuTree;
    }

    //Get Menu Tree Structure by Type (returns array format)
    public function getMenuTreeByType($menuType = 'personal-menu')
    {
        $builder = $this->db->table('usc_menu as m');
        $builder->select('m.*, mt.name as menu_category, mt.alias as category_alias');
        $builder->join('usc_menu_type as mt', 'mt.id=m.menutype_id');
        $builder->where('m.deleted_at', null);
        $builder->where('m.status', 1);
        $builder->where('mt.alias', $menuType);
        $builder->orderBy('m.ordering', 'asc');
        $menuItems = $builder->get()->getResultArray();

        if (empty($menuItems)) return [];

        // Build tree structure
        $menuTree = [];
        $children = [];

        // Separate parents and children
        foreach ($menuItems as $item) {
            if ($item['parent_id'] == 0 || $item['parent_id'] == null) {
                $menuTree[$item['id']] = $item;
                $menuTree[$item['id']]['children'] = [];
            } else {
                $children[$item['parent_id']][] = $item;
            }
        }

        // Attach children to parents
        foreach ($menuTree as $parentId => &$parent) {
            if (isset($children[$parentId])) {
                $parent['children'] = $children[$parentId];
            }
        }

        return $menuTree;
    }

    //Get Active Menu Items by Context
    public function getActiveMenus($context = 'header')
    {
        $builder = $this->db->table('usc_menu as m');
        $builder->select('m.*, mt.name as menu_category, mt.alias as category_alias');
        $builder->join('usc_menu_type as mt', 'mt.id=m.menutype_id');
        $builder->where('m.deleted_at', null);
        $builder->where('m.status', 1);
        $builder->where('m.level', 1);
        $builder->where('mt.alias', $context . '-menu');
        $builder->orderBy('m.ordering', 'asc');
        return $result = $builder->get()->getResult();
    }

    //Get Menu Items by Menu Type ID or Alias
    // Get menu group items
    public function getGroupMenu($menuTypeIdOrAlias)
    {
        $builder = $this->db->table('usc_menu as m');
        $builder->select('m.*, mt.name as menu_category, mt.alias as category_alias, pm.title as parent_item');
        $builder->join('usc_menu_type as mt', 'mt.id = m.category_id', 'left');
        $builder->join('usc_menu as pm', 'pm.id = m.parent_id', 'left');
        $builder->where('m.deleted_at', null);
        
        if (is_numeric($menuTypeIdOrAlias)) {
            $builder->where('m.category_id', $menuTypeIdOrAlias);
        } else {
            $builder->where('mt.alias', $menuTypeIdOrAlias);
        }
        
        $builder->orderBy('m.ordering', 'asc');
        return $builder->get()->getResult();
    }
/**
 * Get menus by category for parent dropdown filtering
 */
public function getMenusByCategory($categoryId)
    {
        $builder = $this->db->table('usc_menu as m');
        $builder->select('m.id, m.title, m.alias, m.level');
        $builder->where('m.category_id', $categoryId);
        $builder->where('m.deleted_at', null);
        $builder->where('m.status', 1);
        $builder->orderBy('m.level', 'ASC');
        $builder->orderBy('m.title', 'ASC');
        return $builder->get()->getResult();
    }
/**
 * Get all menu items with status for admin display
 */
 // Get all menus with status badges
    public function getAllWithStatus()
    {
        $builder = $this->db->table('usc_menu as m');
        $builder->select('m.*, mt.name as menu_category, mt.alias as category_alias, pm.title as parent_item');
        $builder->join('usc_menu_type as mt', 'mt.id = m.category_id', 'left');
        $builder->join('usc_menu as pm', 'pm.id = m.parent_id', 'left');
        $builder->where('m.deleted_at', null);
        $builder->orderBy('m.id', 'DESC');
        return $builder->get()->getResult();
    }
  
    /**
     * Get menu statistics for a specific menu group
     * 
     * @param int $groupId The menu group ID
     * @return object Statistics object with active, inactive, deleted, and total counts
     */
    public function getMenuStats($groupId)
    {
        $builder = $this->db->table('usc_menu');
        
        // Get active items (status = 1 and not deleted)
        $active = $builder->where('category_id', $groupId)
                         ->where('status', 1)
                         ->where('deleted_at', null)
                         ->countAllResults();
                         
        // Get inactive items (status = 0 and not deleted)
        $inactive = $builder->where('category_id', $groupId)
                          ->where('status', 0)
                          ->where('deleted_at', null)
                          ->countAllResults();
                          
        // Get deleted items
        $deleted = $builder->where('category_id', $groupId)
                         ->where('deleted_at !=', null)
                         ->countAllResults();
                         
        // Get total items (excluding deleted)
        $totalItems = $builder->where('category_id', $groupId)
                            ->where('deleted_at', null)
                            ->countAllResults();
        
        return (object)[
            'active' => $active,
            'inactive' => $inactive,
            'deleted' => $deleted,
            'total_items' => $totalItems
        ];
    }

}
