<?php

namespace Modules\Menu\Controllers;

use App\Controllers\Auth\AuthController;
use Modules\Posts\Models\PostsCategoryModel;
use Modules\Posts\Models\PostsModel;
use Modules\Posts\Models\ContentTypesModel;
use Modules\Menu\Models\MenusCategoryModel;
use Modules\Menu\Models\MenusModel;


class Menus extends AuthController
{
public $contentTypesModel;
    public $menusModel;
    public $menuscategoryModel;
    public $postsModel;
    public $postscategoryModel;

     public function initController($request, $response, $logger)
    {
        parent::initController($request, $response, $logger);
        $this->contentTypesModel = new ContentTypesModel();
        $this->menusModel = new MenusModel();
        $this->menuscategoryModel = new MenusCategoryModel();
        $this->postsModel = new PostsModel();
        $this->postscategoryModel = new PostsCategoryModel();
    }

  public function index()
  {

  }

/**========================================================================
 * MENU TYPES /ADD/EDIT/DELETE
 ==========================================================================*/
 public function menuTypes()
 {

   // display header information
   $this->data['title'] = "Menu Groups";
   $this->data['bcrumb'] = "Menus";

   $this->data['menu_types'] = $this->menuscategoryModel->getAll();

   return view('Modules\Menu\Views\category', $this->data);
 }
 public function addType()
 {
  $this->data['menu_types'] = $this->menuscategoryModel->getAll();
   
    if($this->request->getMethod() == 'POST'){
        $rules = [
          'name' => ['label'=>'Group Name', 'rules'=>'required'],
      ];

      if($this->validate($rules))
      {
          $slug = preg_replace('/[^a-z0-9]+/i', '-', trim(strtolower($this->request->getVar('name'))));
          $menuData = [
              'name'          => $this->request->getVar("name"),
              'alias'         => $slug,
              'description'   => $this->request->getVar("description"),
              'created_by'    => $this->userdata->user_id,
          ];
          
          if($this->menuscategoryModel->save($menuData))
          {
              session()->setTempdata('success', 'Menu Group added successfully', 3);
              return redirect()->to('administrator/menu/groups');
          }else{
              session()->setTempdata('error', 'Menu Group NOT added', 3);
              return redirect()->to('administrator/menu/groups');
          }
      }else{
        session()->setTempdata('error', 'Group Name can not be empty', 3);
        return redirect()->to('Menu Group');
      }
    }
    return view('Modules\Menu\Views\category', $this->data);
 }
 public function editType($id = null)
  {
    $this->data['title'] = "Edit Group";
    $this->data['bcrumb'] = "Edit Group Menu";

    $this->data['menu_types'] = $this->menuscategoryModel->getAll();
    $this->data['singleGroup'] = $this->menuscategoryModel->where('id', $id)->first($id);

    return view('Modules\Menu\Views\category', $this->data);
  }
  public function updateType()
 {
  $this->data['menu_types'] = $this->menuscategoryModel->getAll();
   
    if($this->request->getMethod() == 'POST'){
        $rules = [
          'name' => ['label'=>'Group Name', 'rules'=>'required'],
      ];

      if($this->validate($rules))
      {
          $id = $this->request->getVar("id");
          $slug = preg_replace('/[^a-z0-9]+/i', '-', trim(strtolower($this->request->getVar('name'))));
          $menuData = [
              'name'          => $this->request->getVar("name"),
              'alias'         => $slug,
              'description'   => $this->request->getVar("description"),
              'created_by'    => $this->userdata->user_id,
          ];
          
          if($this->menuscategoryModel->update($id, $menuData))
          {
              session()->setTempdata('success', 'Menu Group updated successfully', 3);
              return redirect()->to('administrator/menu/groups');
          }else{
              session()->setTempdata('error', 'Menu Group NOT updated', 3);
              return redirect()->to('administrator/menu/groups');
          }
      }else{
        session()->setTempdata('error', 'Group Name can not be empty', 3);
        return redirect()->to('Menu Group');
      }
    }
    return view('Modules\Menu\Views\category', $this->data);
 }
 public function delType($id)
  {
    $this->menuscategoryModel->where('id', $id)->delete($id);
    if($this->request->isAJAX())
    {
      $response = [
        'error' => true,
        'msg' =>'Menu Group deleted successfully',	   
      ];
      return $this->response->setJSON($response);
    }else{
      session()->setFlashdata('success', 'Menu Group deleted successfully', 3);
			return redirect()->to('menus');
    }
  }
 /**========================================================================
     * MENU ITEMS /ADD/EDIT/DELETE
     ==========================================================================*/
    public function viewMenu($id)
    {
        $menuGroup = $this->menuscategoryModel->getSingleGroup($id);
        $this->data['title'] = $menuGroup->name." Items";
        $this->data['bcrumb'] = $menuGroup->name." Items";
        $this->data['post_categories'] = $this->postscategoryModel->getAll();
        $this->data['singleGroup'] = $menuGroup;
        $this->data['menu_items'] = $this->menusModel->getGroupMenu($id);

        return view('Modules\Menu\Views\all_menus', $this->data);
    }

    public function addMenu()
    {
        $this->data['title'] = "Add Menu Item";
        $this->data['bcrumb'] = "Add Menu Item";
        $this->data['menuGroups'] = $this->menuscategoryModel->getAll();
        $this->data['menus'] = $this->menusModel->getAll();
        
        // Get content types from database
        $this->data['contentTypes'] = $this->contentTypesModel->getActiveTypes();
        
        if($this->request->getMethod() == 'POST') {
            return $this->processMenuSave();
        }
        
        return view('Modules\Menu\Views\add_menu', $this->data);
    }

    public function editMenu($item = null)
    {
        $menuItem = $this->menusModel->singleMenuItem($item);
        $this->data['title'] = "Edit ".$menuItem->title." Item";
        $this->data['bcrumb'] = "Edit ".$menuItem->title;
        $this->data['menuGroups'] = $this->menuscategoryModel->getAll();
        $this->data['menus'] = $this->menusModel->getAll();
        $this->data['menuItem'] = $menuItem;
        
        // Get content types from database
        $this->data['contentTypes'] = $this->contentTypesModel->getActiveTypes();

        if($this->request->getMethod() == 'POST') {
            return $this->processMenuSave($item);
        }
        
        return view('Modules\Menu\Views\edit_menu', $this->data);
    }

    /**
     * Process menu saving with dynamic link generation
     */
    private function processMenuSave($id = null)
    {
        $rules = [
            'title' => ['label'=>'Menu Title', 'rules'=>'required'],
            'category_id' => ['label'=>'Menu Category', 'rules'=>'required'],
            'menu_type' => ['label'=>'Menu Type', 'rules'=>'required'],
        ];

        if($this->validate($rules)) {
            $link = $this->generateMenuLink();
            $slug = preg_replace('/[^a-z0-9]+/i', '-', trim(strtolower($this->request->getVar('title'))));
            
            // Get parent level to calculate current level
            $parentId = $this->request->getVar("parent_id") ?: null;
            $level = 1;
            if ($parentId) {
                $parentMenu = $this->menusModel->find($parentId);
                $level = $parentMenu ? ($parentMenu->level + 1) : 1;
            }

            $menuData = [
                'title' => $this->request->getVar("title"),
                'alias' => $slug,
                'category_id' => $this->request->getVar("category_id"),
                'menu_type' => $this->request->getVar("menu_type"),
                'parent_id' => $parentId,
                'ordering' => $this->request->getVar("ordering") ?: 0,
                'level' => $level,
                'access' => $this->request->getVar("access") ?: 'Public',
                'status' => (int)($this->request->getVar("status") ?: 1),
                'link' => $link,
                'post_id' => $this->request->getVar("post_id") ?: null,
                'post_cat' => $this->request->getVar("post_category") ?: null,
                'created_by' => $this->userdata->user_id,
            ];
            
            if ($id) {
                // Update existing menu
                if($this->menusModel->update($id, $menuData)) {
                    session()->setTempdata('success', 'Menu Item updated successfully', 3);
                    return redirect()->to('administrator/menu/item/edit/'.$id.'-'.$slug);
                }
            } else {
                // Create new menu
                if($this->menusModel->save($menuData)) {
                    $menuId = $this->menusModel->getInsertID();
                    session()->setTempdata('success', 'Menu Item added successfully', 3);
                    return redirect()->to('administrator/menu/item/edit/'.$menuId.'-'.$slug);
                }
            }
            
            session()->setTempdata('error', 'Menu Item NOT saved', 3);
        } else {
            session()->setTempdata('error', 'Please check required fields', 3);
        }
        
        return $id ? redirect()->to('administrator/menu/item/edit/'.$id) : redirect()->to('administrator/menu/item/add');
    }

    /**
     * Generate menu link based on content type selection
     */
    private function generateMenuLink()
    {
        $menuType = $this->request->getVar('menu_type');
        $customLink = $this->request->getVar('custom');

        // Handle custom links
        if ($menuType === 'custom' || !empty($customLink)) {
            return $customLink ?: '#';
        }

        // Map legacy slugs to database slugs for consistency
        $slugMapping = [
            'post' => 'blog',
            'page' => 'page',
            'service' => 'service'
        ];

        $mappedType = isset($slugMapping[$menuType]) ? $slugMapping[$menuType] : $menuType;

        // Handle different content types
        switch ($mappedType) {
            case 'page':
                $pageId = $this->request->getVar('page_id');
                if ($pageId) {
                    $page = $this->postsModel->where('id', $pageId)->first();
                    return $page ? ($page['menu_link'] ?? $page['alias'] ?? '#') : '#';
                }
                break;

            case 'blog':
                $postId = $this->request->getVar('post_id');
                if ($postId) {
                    $post = $this->postsModel->where('id', $postId)->first();
                    return $post ? ($post['menu_link'] ?? 'blog/' . ($post['alias'] ?? '#')) : '#';
                }
                break;

            case 'service':
                $serviceId = $this->request->getVar('service_id');
                if ($serviceId) {
                    $service = $this->postsModel->where('id', $serviceId)->first();
                    return $service ? ($service['menu_link'] ?? 'services/' . ($service['alias'] ?? '#')) : '#';
                }
                break;

            case 'category':
                $categoryId = $this->request->getVar('post_category');
                if ($categoryId) {
                    $category = $this->postscategoryModel->where('id', $categoryId)->first();
                    return $category ? ('category/' . ($category['alias'] ?? '#')) : '#';
                }
                break;
        }

        return '#';
    }

    /**
     * AJAX method to get content by type
     */
    public function getContentByType()
    {
        $contentTypeSlug = $this->request->getVar('content_type');
        $content = [];

        if (!$contentTypeSlug) {
            return $this->response->setJSON([]);
        }

        // Use a switch statement to handle content fetching based on the slug.
        // This approach is consistent with other working parts of the application
        // and avoids issues with the ContentTypesModel or slug resolution.
        switch ($contentTypeSlug) {
            case 'page':
                // Fetch all posts with content_type_id = 1 (Pages)
                $content = $this->postsModel->getByContentType(1, false);
                break;

            case 'post':
                // Fetch all posts with content_type_id = 2 (Blog Posts)
                $content = $this->postsModel->getByContentType(2, false);
                break;

            case 'service':
                // Fetch all posts with content_type_id = 3 (Services)
                $content = $this->postsModel->getByContentType(3, false);
                break;

            case 'category':
                // Handle 'category' as a special case, as it's a taxonomy.
                $categories = $this->postscategoryModel->getAll();
                $formattedContent = [];
                foreach ($categories as $cat) {
                    $formattedContent[] = [
                        'id' => $cat->id,
                        'title' => $cat->name,
                        'alias' => $cat->alias,
                        'menu_link' => 'category/' . $cat->alias
                    ];
                }
                $content = $formattedContent;
                break;

            default:
                // If the content type is unknown, return an empty array.
                $content = [];
                break;
        }

        return $this->response->setJSON($content);
    }

    /**
     * AJAX method to get menus by category
     */
    public function getMenusByCategory()
    {
        $categoryId = $this->request->getVar('category_id');
        
        if (!$categoryId) {
            return $this->response->setJSON([]);
        }
        
        $menus = $this->menusModel->getMenusByCategory($categoryId);
        return $this->response->setJSON($menus);
    }

    public function delMenu($id)
    {
        $group = $this->menusModel->singleMenuItem($id);
        $this->menusModel->where('id', $id)->delete($id);
        if($this->request->isAJAX()) {
            $response = ['error' => true, 'msg' =>'Menu Item deleted successfully'];
            return $this->response->setJSON($response);
        } else {
            session()->setTempdata('error', 'Menu Item deleted successfully', 3);
            return redirect()->to('administrator/menu/group/'.$group->category_alias);
        }
    }




public function updateMenu()
{
  $this->data['title'] = "Add Menu Item";
  $this->data['bcrumb'] = "Add Menu Item";

  // Initialize post_cat & post_id as null
  $post_id = null;
  $post_cat = null;

  $this->data['menuGroups'] = $this->menuscategoryModel->getAll();
  $this->data['menus'] = $this->menusModel->getAll();
  //Get Pages / Categories / Posts
  $this->data['getPages'] = $this->postsModel->getAllPages();
  $this->data['getPosts'] = $this->postsModel->getAllPosts();
  $this->data['categoryTree'] = $this->postscategoryModel->getCategoryList();

  if($this->request->getMethod() == 'POST')
  {
    $id = $this->request->getVar('id');
    $postId = $this->request->getVar('post_id');
    $pageId = $this->request->getVar('page_id');
    $catId  = $this->request->getVar('post_category');

    //Find the  Page link
    if($pageId){
      $getPage = $this->postsModel->where('id', $pageId)->first($pageId);
      $page_link = $getPage['menu_link'];
      $post_id = $pageId;
    }
  
    //Find the Post link
    if($postId){
      $getPost = $this->postsModel->where('id', $postId)->first($postId);
      $post_link = $getPost['menu_link'];
      $post_id = $postId;
    }

    // Generate Parent category alias for Menu Link
    if($catId){
      $parent_catId = $this->postscategoryModel->getParentCategory($catId);
      $parent_catAlias = preg_replace('/[^a-z0-9]+/i', '-', trim(strtolower($parent_catId->name)));

      // Generate Category alias for Menu Link
      $categoryName = $this->postscategoryModel->getSingleCategory($catId); 
      $category_alias = preg_replace('/[^a-z0-9]+/i', '-', trim(strtolower($categoryName->name)));

      //Determining the link for the Category with or without Parent Category
      if(empty($parent_catId)){
        $catLink = $category_alias;
      }else{
        $catLink = $parent_catAlias.'/'.$category_alias;
      }
    }

    //Basing on the menu_type, can determine right menu link to save with Menu.
    $menuType = $this->request->getVar('menu_type');
    if($menuType == "page")
    {
      $link = $page_link;
    }elseif($menuType == "post"){
      $link = $post_link;
    }elseif($menuType == "category"){
      $link = $catLink;
    }else{
      $link = $this->request->getVar('custom');
    }

    //Get Menu Alias
    $slug = preg_replace('/[^a-z0-9]+/i', '-', trim(strtolower($this->request->getVar('title'))));

    $rules = [
      'title'         => ['label'=>'Menu Title', 'rules'=>'required'],
      'category_id'   => ['label'=>'Menu Category', 'rules'=>'required'],
    ];

    if($this->validate($rules))
    {
      
        $slug = preg_replace('/[^a-z0-9]+/i', '-', trim(strtolower($this->request->getVar('title'))));
        $menuData = [
            'title'         => $this->request->getVar("title"),
            'alias'         => $slug,
            'category_id'   => $this->request->getVar("category_id"),
            'menu_type'     => $this->request->getVar("menu_type"),
            'parent_id'     => $this->request->getVar("parent_id"),
            'ordering'      => $this->request->getVar("ordering"),
            'level'         => $this->request->getVar("level"),
            'access'         => $this->request->getVar("access"),
            'status'         => (int)$this->request->getVar("status"),
            'link'          => $link,
            'post_id'       => $post_id,
            'post_cat'      => $catId,
            'created_by'    => $this->userdata->user_id,
        ];
        
        if($this->menusModel->update($id, $menuData))
        {
            $menuId = $this->menusModel->getInsertID();
            session()->setTempdata('success', 'Menu Item Updated successfully', 3);
            return redirect()->to('administrator/menu/item/edit/'.$id.'-'.$slug);
        }else{
            session()->setTempdata('error', 'Menu Item NOT added', 3);
            return redirect()->to('administrator/menu/item/add');
        }
    }else{
      session()->setTempdata('error', 'Group Name & Category can not be empty', 3);
      return redirect()->to('administrator/menu//item/add');
    }
  }
  return view('Modules\Menu\Views\edit_menu', $this->data);
}



}
