<?php

namespace Modules\Menu\Config;

$routes->group('administrator/menu', ['namespace' => 'Modules\Menu\Controllers'], static function ($routes) {
    // Menu Groups (Types)
    $routes->GET('groups', 'Menus::menuTypes');
    $routes->match(['GET', 'POST'], 'group/add', 'Menus::addType');
    $routes->match(['GET', 'POST'], 'group/edit/(:num)', 'Menus::editType/$1');
    $routes->POST('group/update', 'Menus::updateType');
    $routes->GET('group/delete/(:num)', 'Menus::delType/$1');
    $routes->GET('group/(:any)', 'Menus::viewMenu/$1');

    // Menu Items
    $routes->match(['GET', 'POST'], 'item/add', 'Menus::addMenu');
    $routes->match(['GET', 'POST'], 'item/edit/(:any)', 'Menus::editMenu/$1');
    $routes->GET('item/delete/(:num)', 'Menus::delMenu/$1');

    // AJAX routes
    $routes->GET('getContentByType', 'Menus::getContentByType');
    $routes->GET('getMenusByCategory', 'Menus::getMenusByCategory');
});