<?php

namespace Modules\Media\Config;

use Config;
// Create a new instance of our RouteCollection class.
$routes = Config\Services::routes();

// Load the system's routing file first, so that the app and ENVIRONMENT
// can override as needed.
if (is_file(SYSTEMPATH . 'Config/Routes.php')) {
    require SYSTEMPATH . 'Config/Routes.php';
}

//setting up Media routes.
$routes->group('administrator/media', ['filter' => ['isLoggedIn'], 'namespace' => 'Modules\Media\Controllers'],   static function($routes){

    $routes->GET('', 'FileManagerController::index');
    $routes->POST('getFileTags', 'FileManagerController::getFileTags');
    $routes->POST('renameFile', 'FileManagerController::renameFile');
    $routes->POST('deleteFile', 'FileManagerController::deleteFile');
    $routes->POST('uploadFiles', 'FileManagerController::uploadFiles');
    $routes->POST('bulkDelete', 'FileManagerController::bulkDelete');
    $routes->GET('serve/(:any)', 'FileManagerController::serveFile/$1', ['filter' => []]);

});
