<?= $this->extend('Modules\Admin\Views\index'); ?>
<?= $this->section('content');?>
<div class="row">
    <div class="col">
        <?php if(session()->getTempdata('success')): ?>
            <div class="alert alert-success" role="alert"><?= session()->getTempdata('success');?></div>
        <?php endif;?>
        <?php if(session()->getTempdata('error')): ?>
            <div class="alert alert-danger" role="alert"><?= session()->getTempdata('error');?></div>
        <?php endif;?>
        <?php if(isset($validation)): ?>
            <div class="alert alert-danger">
                <?= $validation->listErrors()?>
            </div>
        <?php endif;?>
        <div id="showMsg"></div>
    </div>
</div>

<div class="card card-body">
    <div class="d-flex bd-highlight mb-3">
        <div class="p-2 bd-highlight">
            <a href="<?= base_url('administrator/jobs/categories/add'); ?>" class="btn btn-sm btn-success w-100"><i class="bi bi-plus"></i> Add New</a>
        </div>
        <div class="p-2 bd-highlight">
            <a href="<?= base_url('administrator/jobs/dashboard'); ?>" class="btn btn-sm btn-info w-100"><i class="bi bi-briefcase"></i> Back to Jobs</a>
        </div>
        <div class="p-2 bd-highlight">
            <div class="btn-group border">
                <button type="button" class="btn bg-secondary bg-opacity-25 rounded-0"><i class="bi bi-pencil-square"></i></button>
                <a href="#" class="btn btn-sm btn-light">Edit</a>
            </div>
        </div>
        <div class="p-2 bd-highlight">
            <div class="btn-group border">
                <button type="button" class="btn bg-secondary bg-opacity-25 rounded-0"><i class="bi bi-trash-fill"></i></button>
                <a href="#" class="btn btn-sm btn-light">Delete</a>
            </div>
        </div>
        <div class="p-2 bd-grow-1 bd-highlight"> &nbsp;</div>
    </div>
    <div class="table-responsive">
        <table id="categorieslist" class="table table-stripped table-hover">
            <thead class="bg-primary bg-opacity-10" style="font-size: 14px">
                <tr>
                    <th>#</th>
                    <th>Name</th>
                    <th>Alias</th>
                    <th>Parent</th>
                    <th></th>
                </tr>
            </thead>
            <tbody>
                <?php foreach($categories as $c): ?>
                    <tr>
                        <td><span class="badge rounded-pill bg-info"><?= $c->id; ?></span></td>
                        <td><a href="<?= base_url('administrator/jobs/categories/edit/').$c->id; ?>" style="font-size: 15px;"><?= $c->name; ?></a></td>
                        <td><?= $c->alias; ?></td>
                        <td>
                            <?php 
                                $parentName = 'None';
                                foreach($categories as $parent) {
                                    if ($parent->id == $c->parent_id) {
                                        $parentName = $parent->name;
                                        break;
                                    }
                                }
                                echo $parentName;
                            ?>
                        </td>
                        <td>
                            <div class="btn-group dropstart">
                                <button type="button" class="btn btn-white p-1" data-bs-toggle="dropdown" aria-expanded="false">
                                    <i class="bi bi-three-dots-vertical"></i>
                                </button>
                                <ul class="dropdown-menu">
                                    <li><a class="dropdown-item" href="<?= base_url('administrator/jobs/categories/edit/').$c->id; ?>"><small>Edit</small></a></li>
                                    <li><a class="dropdown-item" onclick="delete_category(<?=$c->id ?>, '<?=$c->name ?>')"><small>Delete</small></a></li>
                                </ul>
                            </div>
                        </td>
                    </tr>
                <?php endforeach;?>
            </tbody>
        </table>
    </div>
</div>

<script type="text/javascript">
    $(document).ready(function () {
        $('#categorieslist').DataTable({
            pageLength: 10,
            order: [[0, "desc"]],
        });
    });

    function delete_category(id, name) {
        var confirmation = confirm('Are you sure you want to delete the category: '+name+'?');
        if(confirmation == true){
            window.location.href = base_url+"administrator/jobs/categories/delete/"+id;
        }
    }
</script>
<?= $this->endSection();?>