<?php

namespace Modules\Jobs\Models;

use CodeIgniter\Model;

class JobCategoryModel extends Model
{
    protected $table = 'usc_jobs_category';
    protected $primaryKey = 'id';

    protected $allowedFields = ['name', 'alias', 'parent_id', 'created_at', 'updated_at', 'deleted_at'];

    protected $returnType = 'array';
    protected $useTimestamps = true;
    protected $useSoftDeletes = true;

    protected $createdField = 'created_at';
    protected $updatedField = 'updated_at';
    protected $deletedField = 'deleted_at';

    // Get all categories
    public function getAll()
    {
        $builder = $this->db->table($this->table . ' as c');
        $builder->select('c.*');
        $builder->where('c.deleted_at', null);
        $builder->orderBy('c.name', 'ASC');
        $result = $builder->get()->getResult();
        return $result;
    }

    // Get category by ID
    public function getCategory($id)
    {
        $builder = $this->db->table($this->table . ' as c');
        $builder->select('c.*');
        $builder->where('c.id', $id);
        $builder->where('c.deleted_at', null);
        $result = $builder->get()->getRow();
        return $result;
    }

    // Get categories for dropdown
    public function getForDropdown()
    {
        $categories = $this->getAll();
        $dropdown = ['' => 'Select Category'];
        foreach ($categories as $category) {
            $dropdown[$category->id] = $category->name;
        }
        return $dropdown;
    }

    // Generate slug from name
    public function generateSlug($name)
    {
        return preg_replace('/[^a-z0-9]+/i', '-', trim(strtolower($name)));
    }
}