<?= $this->extend('Modules\Admin\Views\index'); ?>
<?= $this->section('content');?>
<!-- Forex Rates ADD/EDIT/DELETE/Detailed List !-->
<div class="container">
<div class="row">
    <div class="col">

		<!-- print success message !-->
		<?php if(session()->getTempdata('success')): ?>
			<div class="alert alert-success" role="alert"><?= session()->getTempdata('success');?></div>
		<?php endif;?>
		<!-- print failure message !-->
		<?php if(session()->getTempdata('error')): ?>
			<div class="alert alert-danger" role="alert"><?= session()->getTempdata('error');?></div>
		<?php endif;?>
        <?php if(isset($validation)): ?>
		    <div class="alert alert-danger">
			<?= $validation->listErrors()?>
			</div>
        <?php endif;?>
        <div id="showMsg"></div>
</div></div>
<div class="row">
    <div class="col-lg-4"> 
        <div class="card">
                <?php if(!isset($singlerate)):?>
				<div class="card-header d-flex justify-content-between align-items-center">
                    <h6 class="card-title fw-bold mb-0">Add Rate</h6>
                    <nav aria-label="breadcrumb">
                        <ol class="breadcrumb mb-0">
                            <li class="breadcrumb-item"><a href="<?= base_url('administrator/dashboard') ?>">Dashboard</a></li>
                            <li class="breadcrumb-item"><a href="<?= base_url('administrator/forex/rates') ?>">Forex Rates</a></li>
                            <li class="breadcrumb-item active" aria-current="page">Add Rate</li>
                        </ol>
                    </nav>
                </div>
				<div class="card-body ">
                <!-- Add Category  !-->
                <form method="POST" action="<?= base_url('administrator/forex/add');?>">
                <?= csrf_field();?>
                <div class="row">
                    <div class="mb-3">
                        <label class="form-label">Choose Currency</label>
                        <?= view('Modules\ForexExchange\Views\partials\currency_selector', [
                            'currentValue' => '',
                            'inputName' => 'currency_id',
                            'required' => true
                        ]) ?>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Buying</label>
                        <div class="input-group">
                            <span class="input-group-text" id="buying-addon">UGX</span>
                            <input type="number"
                                   class="form-control"
                                   name="buying"
                                   step=".01"
                                   required
                                   aria-describedby="buying-addon">
                        </div>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Selling</label>
                        <div class="input-group">
                            <span class="input-group-text" id="selling-addon">UGX</span>
                            <input type="number"
                                   class="form-control"
                                   name="selling"
                                   step=".01"
                                   required
                                   aria-describedby="selling-addon">
                        </div>
                    </div>
                    <div class="mb-3">
                        <div class="form-check form-switch">
                            <input class="form-check-input" type="checkbox" id="status" name="status" value="1" checked>
                            <label class="form-check-label" for="status">
                                Active
                            </label>
                        </div>
                    </div>
                    <div class="accordion accordion-flush mb-3 " id="accordionFlushExample">
                    <div class="accordion-item">
                        <h2 class="accordion-header" id="flush-headingOne">
                        <button class="accordion-button collapsed bg-primary bg-opacity-10" type="button" data-bs-toggle="collapse" data-bs-target="#flush-collapseOne" aria-expanded="false" aria-controls="flush-collapseOne">
                            Add T/T Rates
                        </button>
                        </h2>
                        <div id="flush-collapseOne" class="accordion-collapse collapse" aria-labelledby="flush-headingOne" data-bs-parent="#accordionFlushExample">
                        <div class="accordion-body">
                            <div class="mb-3">
                                <label class="form-label">T/T Buying</label>
                                <div class="input-group">
                                    <span class="input-group-text" id="tt-buying-addon">UGX</span>
                                    <input type="number"
                                           class="form-control"
                                           name="tt_buying"
                                           step=".01"
                                           aria-describedby="tt-buying-addon">
                                </div>
                            </div>
                            <div class="mb-3">
                                <label class="form-label">T/T Selling</label>
                                <div class="input-group">
                                    <span class="input-group-text" id="tt-selling-addon">UGX</span>
                                    <input type="number"
                                           class="form-control"
                                           name="tt_selling"
                                           step=".01"
                                           aria-describedby="tt-selling-addon">
                                </div>
                            </div>
                        </div>
                        </div>
                    </div>
                    </div>
                    <div class="mb-3 d-flex gap-2">
                        <button type="submit" class="btn btn-outline-danger">Save</button>
                        <a href="<?= base_url('administrator/forex/rates') ?>" class="btn btn-outline-secondary">Cancel</a>
                    </div>
                </div>
                </form>
            </div>
                <!-- End Add Category  !-->
                <?php else:?>
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h6 class="card-title fw-bold mb-0">Edit Rate</h6>
                    <nav aria-label="breadcrumb">
                        <ol class="breadcrumb mb-0">
                            <li class="breadcrumb-item"><a href="<?= base_url('administrator/dashboard') ?>">Dashboard</a></li>
                            <li class="breadcrumb-item"><a href="<?= base_url('administrator/forex/rates') ?>">Forex Rates</a></li>
                            <li class="breadcrumb-item active" aria-current="page">Edit Rate</li>
                        </ol>
                    </nav>
                </div>
                <div class="card-body ">
                <!-- Edit Category  !-->
                    <form method="POST" action="<?= base_url('administrator/forex/update');?>">
                    <?= csrf_field();?>
                    <div class="row">
                    <div class="mb-3">
                        <label class="form-label">Choose Currency</label>
                        <?= view('Modules\ForexExchange\Views\partials\currency_selector', [
                            'currentValue' => $singlerate->currency_id,
                            'inputName' => 'currency_id',
                            'required' => true
                        ]) ?>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Buying Rate</label>
                        <div class="input-group">
                            <span class="input-group-text" id="buying-addon">
                                <?= isset($singlerate->symbol) ? $singlerate->symbol : '' ?>
                            </span>
                            <input type="number"
                                   class="form-control <?= session('errors.buying') ? 'is-invalid' : '' ?>"
                                   name="buying"
                                   value="<?= $singlerate->buying; ?>"
                                   step=".01"
                                   aria-describedby="buying-addon">
                            <?php if (session('errors.buying')): ?>
                                <div class="invalid-feedback">
                                    <?= session('errors.buying') ?>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Selling Rate</label>
                        <div class="input-group">
                            <span class="input-group-text" id="selling-addon">
                                <?= isset($singlerate->symbol) ? $singlerate->symbol : '' ?>
                            </span>
                            <input type="number"
                                   class="form-control <?= session('errors.selling') ? 'is-invalid' : '' ?>"
                                   name="selling"
                                   value="<?= $singlerate->selling; ?>"
                                   step=".01"
                                   aria-describedby="selling-addon">
                            <?php if (session('errors.selling')): ?>
                                <div class="invalid-feedback">
                                    <?= session('errors.selling') ?>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                    <div class="mb-3">
                        <div class="form-check form-switch">
                            <input class="form-check-input" type="checkbox" id="status" name="status" value="1" <?= $singlerate->status == 1 ? 'checked' : '' ?>>
                            <label class="form-check-label" for="status">
                                Active
                            </label>
                        </div>
                    </div>
                    <div class="accordion accordion-flush mb-3 " id="accordionFlushExample">
                    <div class="accordion-item">
                        <h2 class="accordion-header" id="flush-headingOne">
                        <button class="accordion-button collapsed bg-primary bg-opacity-10" type="button" data-bs-toggle="collapse" data-bs-target="#flush-collapseOne" aria-expanded="false" aria-controls="flush-collapseOne">
                            Add T/T Rates
                        </button>
                        </h2>
                        <div id="flush-collapseOne" class="accordion-collapse collapse" aria-labelledby="flush-headingOne" data-bs-parent="#accordionFlushExample">
                        <div class="accordion-body">
                            <div class="mb-3">
                                <label class="form-label">T/T Buying Rate</label>
                                <div class="input-group">
                                    <span class="input-group-text" id="tt-buying-addon">
                                        <?= isset($singlerate->symbol) ? $singlerate->symbol : '' ?>
                                    </span>
                                    <input type="number"
                                           class="form-control <?= session('errors.tt_buying') ? 'is-invalid' : '' ?>"
                                           name="tt_buying"
                                           value="<?= $singlerate->tt_buying; ?>"
                                           step=".01"
                                           aria-describedby="tt-buying-addon">
                                    <?php if (session('errors.tt_buying')): ?>
                                        <div class="invalid-feedback">
                                            <?= session('errors.tt_buying') ?>
                                        </div>
                                    <?php endif; ?>
                                </div>
                            </div>
                            <div class="mb-3">
                                <label class="form-label">T/T Selling Rate</label>
                                <div class="input-group">
                                    <span class="input-group-text" id="tt-selling-addon">
                                        <?= isset($singlerate->symbol) ? $singlerate->symbol : '' ?>
                                    </span>
                                    <input type="number"
                                           class="form-control <?= session('errors.tt_selling') ? 'is-invalid' : '' ?>"
                                           name="tt_selling"
                                           value="<?= $singlerate->tt_selling; ?>"
                                           step=".01"
                                           aria-describedby="tt-selling-addon">
                                    <?php if (session('errors.tt_selling')): ?>
                                        <div class="invalid-feedback">
                                            <?= session('errors.tt_selling') ?>
                                        </div>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                        </div>
                    </div>
                    </div>
                        <div class="mb-3 d-flex gap-2">
                            <input type="hidden" name="id" value="<?= $singlerate->id; ?>" >
                            <button type="submit" class="btn btn-outline-danger">Update</button>
                            <a href="<?= base_url('administrator/forex/rates') ?>" class="btn btn-outline-secondary">Cancel</a>
                        </div>
                    </div>
                    </form>
                <!-- End Edit Category  !-->
                </div>
                <?php endif; ?>
        </div>
    </div>
    <div class="col-lg-8 "> 
        <!-- Display all categories !-->
        <div class="card">
        <div class="card-header">
            <h6 class="card-title fw-bold">Rates List</h6>
        </div> 
        <div class="card-body">
            <div class="table-responsive">
                <table id="rates-table" class="table table-hover">
                <thead class="bg-primary bg-opacity-10" style="font-size: 14px;">
                    <tr>
                    <th>Currency</th>
                    <th>Buying (UGX)</th>
                    <th>Selling (UGX)</th>
                    <th>T/T Buying</th>
                    <th>T/T Selling</th>
                    <th>Status</th>
                    <th>Action</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach($forex_rates as $r): ?>
                        <tr>
                        <td>
                            <div class="d-flex align-items-center">
                                <img src="https://flagcdn.com/w20/<?= strtolower($r->sortname); ?>.png" 
                                     alt="<?= $r->currency_code; ?>" 
                                     class="me-2"
                                     style="width: 20px; height: 15px; object-fit: cover;"
                                     onerror="this.onerror=null; this.src='https://flagcdn.com/w20/xx.png'">
                                <div>
                                    <strong><?= $r->currency_code; ?></strong>
                                    <?php if($r->currency_symbol): ?>
                                        <small class="text-muted">(<?= $r->currency_symbol; ?>)</small>
                                    <?php endif; ?>
                                    <br>
                                    <small class="text-muted"><?= $r->currency_name; ?></small>
                                </div>
                            </div>
                        </td>
                        <td><?= number_format($r->buying, 2); ?></td>
                        <td><?= number_format($r->selling, 2); ?></td>
                        <td><?= number_format($r->tt_buying, 2); ?></td>
                        <td><?= number_format($r->tt_selling, 2); ?></td>
                        <td>
                            <span class="badge <?= $r->status == 1 ? 'bg-success' : 'bg-secondary' ?>">
                                <?= $r->status == 1 ? 'Active' : 'Inactive' ?>
                            </span>
                        </td>
                        <td>
                        <div class="btn-group" role="group" aria-label="Rate actions">
                        <a href="<?= base_url('administrator/forex/edit/').$r->id; ?>"
                           class="btn btn-success btn-sm"
                           title="Edit rate">
                            <i class="bi bi-pencil-square"></i>
                        </a>
                        <?php if($userdata->group_id==1):?>
                            <button type="button"
                                    class="btn btn-danger btn-sm"
                                    onclick="delete_forex(<?=$r->id ?>, '<?=$r->currency_code; ?>')"
                                    title="Delete rate">
                                <i class="bi bi-trash"></i>
                            </button>
                        <?php endif;?>
                        </div>
                        </td>
                        </tr>
                    <?php endforeach;?>
                </tbody>
            </table>
        </div>
    </div></div>
            
<!---- JS --->  
<script type="text/javascript">
    $(document).ready(function () {
        $('#rates-table').DataTable({
            pageLength: 10,
            order: [[0, "asc"]],
            columnDefs: [
                { orderable: false, targets: -1 } // Disable sorting on action column
            ],
            initComplete: function () {
                // Add status filter dropdown
                this.api().columns(5).every(function () {
                    var column = this;
                    var select = $('<select class="form-select form-select-sm"><option value="">All Status</option><option value="1">Active</option><option value="0">Inactive</option></select>')
                        .appendTo($(column.header()).empty())
                        .on('change', function () {
                            var val = $.fn.dataTable.util.escapeRegex($(this).val());
                            column.search(val ? '^' + val + '$' : '', true, false).draw();
                        });
                });
            }
        });
    });

    function delete_forex(id, code) {
        Swal.fire({
            title: 'Delete Rate?',
            text: `Are you sure you want to delete the ${code} exchange rate?`,
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#d33',
            cancelButtonColor: '#3085d6',
            confirmButtonText: 'Yes, delete it!'
        }).then((result) => {
            if (result.isConfirmed) {
                window.location.href = base_url + "administrator/forex/delete/" + id;
            }
        });
    }
</script>
<?= $this->endSection();?>