<?php

namespace Modules\ForexExchange\Config;

use Config;
// Create a new instance of our RouteCollection class.
$routes = Config\Services::routes();

// Load the system's routing file first, so that the app and ENVIRONMENT
// can override as needed.
if (is_file(SYSTEMPATH . 'Config/Routes.php')) {
    require SYSTEMPATH . 'Config/Routes.php';
}


//setting up Forex Rates routes.
$routes->group('administrator/forex', ['filter' => 'isLoggedIn', 'filter' => 'checkPermission',  'namespace' => 'Modules\ForexExchange\Controllers'],   static function($routes){

    $routes->GET('rates', 'ForexExchange::index');
    $routes->POST('add', 'ForexExchange::addForex');
    $routes->GET('edit/(:any)', 'ForexExchange::editForex/$1');
    $routes->POST('update',  'ForexExchange::updateForex');
    $routes->GET('delete/(:any)', 'ForexExchange::delForex/$1');
});

// AJAX routes for currency selector (no filters needed for AJAX calls)
$routes->GET('administrator/forex/search-currencies', '\Modules\ForexExchange\Controllers\ForexExchange::searchCurrencies');
$routes->GET('administrator/forex/get-currency/(:any)', '\Modules\ForexExchange\Controllers\ForexExchange::getCurrency/$1');
