<?= $this->extend('Modules\Admin\Views\index'); ?>
<?= $this->section('content');?>
<!-- print success message !-->
<div class="row">
    <div class="col">
		<!-- print success message !-->
		<?php if(session()->getTempdata('success')): ?>
			<div class="alert alert-success" role="alert"><?= session()->getTempdata('success');?></div>
		<?php endif;?>
		<!-- print failure message !-->
		<?php if(session()->getTempdata('error')): ?>
			<div class="alert alert-danger" role="alert"><?= session()->getTempdata('error');?></div>
		<?php endif;?>
        <?php if(isset($validation)): ?>
			<div class="alert alert-danger">
		<?= $validation->listErrors()?>
		</div>
        <?php endif;?>
        <div id="showMsg"></div>
</div></div>
<!-- Create/Post !-->
<form method="POST" action="<?= base_url('posts/update')?>" enctype="multipart/form-data" id="post-form">
    <div class="card rounded-0 shadow-sm">
        <div class="card-header bg-light bg-opacity-100">
            <!-- Save/New/Cancel Btns !-->
            <div class="d-flex bd-highlight align-items-center">
                <div class="p-1 bd-highlight align-items-center">
                    <div class="btn-group border shadow-sm">
                    <button type="button" class="btn bg-success rounded-0"><i class="bi bi-plus-lg text-white"></i></button>
                    <button type="submit" class="btn btn-sm btn-success align-items-center"> &nbsp; Save &nbsp;</button>
                    </div>
                </div>
                <div class="p-1 bd-highlight d-none d-md-block">
                    <div class="btn-group border shadow-sm">
                    <button type="button" class="btn bg-secondary bg-opacity-25 rounded-0"><i class="bi bi-check-lg text-success"></i></button>
                    <a href="#" class="btn btn-sm btn-light">Save & Close</a>
                    </div>
                </div>
                <div class="p-1 bd-highlight d-none d-md-block">
                    <div class="btn-group border shadow-sm">
                    <button type="button" class="btn bg-secondary bg-opacity-25 rounded-0"><i class="bi bi-plus-lg"></i></button>
                    <a href="<?= base_url('posts/add') ?>" class="btn btn-sm btn-light">Add New</a>
                    </div>
                </div>
                <div class="p-1 bd-highlight">
                    <div class="btn-group border shadow-sm">
                    <button type="button" class="btn bg-danger  text-white rounded-0"><i class="bi bi-x-lg"></i></button>
                    <button type="button" class="btn btn-sm bg-danger text-white" onclick="location.href = '<?= base_url('posts')?>'">Close</button>
                    </div>
                </div>
            </div>
            <!-- END Save/New/Cancel Btns !-->
        </div>
        <div class="card-body">
            <div class="row">
                <div class="col-md-7">
                    <div class="mb-3">
                    <label class="form-label"><strong>Title</strong></label>
                    <input type="text" name="title" value="<?= $singlePost['title'] ?>" class="form-control">
                    </div>
                </div>
                <div class="col-md-5">
                    <div class="mb-3">
                    <label class="form-label"><strong>Alias</strong></label>
                    <input type="text" name="alias" value="<?= $singlePost['alias'] ?>" class="form-control bg-secondary bg-opacity-10" readonly>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-lg-9">
                  <!-- Main post content !-->
                  <div class="mb-3">
                    <label class="form-label"><strong>Content</strong></label>
                    <textarea id="tiny" name="content" class="form-control" cols="10" rows="10" placeholder="Write full text here.."><?= $singlePost['content'] ?></textarea>
                  </div>
                  <div class="mb-3">
                    <label class="form-label"><strong>Excerpt text</strong></label>
                    <textarea name="excerpt" class="form-control"  rows="2" placeholder="Write summary text here.."><?= $singlePost['excerpt'] ?></textarea>
                  </div>
                  <input type="hidden" name="id" value="<?= $singlePost['id'] ?>">
                  <!-- END Main post content  !-->
                </div>
                <div class="col-lg-3">
                 <!-- Main post params !-->
                 <div class="mb-3">
                    <label class="form-label"><strong>Category</strong></label>
                    <select name="category_id" class="form-select">
                        <option value="public" >Select Category</option>
                        <?php foreach($categories as $cat): ?>
                            <option value="<?= $cat->id;?>" <?php if($cat->id == $singlePost['category_id']) echo "selected";?>><?= $cat->name;?></option>
                        <?php endforeach;?>
                    </select>
                  </div>
                  <div class="mb-3">
                    <label class="form-label"><strong>Status</strong></label>
                    <select name="status" class="form-select bg-success bg-opacity-75 text-white" >
                        <option value="Published" <?php if($singlePost['status'] == "Published" ) echo "selected";?> >Published</option>
                        <option value="Unpublished" <?php if($singlePost['status'] == "Unpublished" ) echo "selected";?>>Unpublished</option>
                        <option value="Archived" <?php if($singlePost['status'] == "Archived" ) echo "selected";?>>Archived</option>
                        <option value="Trashed" <?php if($singlePost['status'] == "Trashed" ) echo "selected";?>>Trashed</option>
                    </select>
                  </div>
                  <div class="mb-3">
                    <label class="form-label"><strong>Access</strong></label>
                    <select name="access" class="form-select">
                        <option value="Public" <?php if($singlePost['access'] == "Public" ) echo "selected";?>>Public</option>
                        <option value="Private" <?php if($singlePost['access'] == "Private" ) echo "selected";?>>Private</option>
                        <option value="Users" <?php if($singlePost['access'] == "Users" ) echo "selected";?>>Users</option>
                    </select>
                  </div>
                  <div class="mb-3">
                    <div style="height: 150px; background: #F2F9FF; border-radius: 5px;">
                    <div id="postImgPreview"></div>
                    <small class="d-flex text-muted p-2">Add Photo to post</small>
                    </div>
                    <input type="file" name="photo" id="post_image" class="postImg upload-photo" accept=".jpg, .gif, .png, .tiff, .jpeg, .webp">
                    <img src="<?= $singlePost['photo']?>" width="80px">
                  </div>
                  <div class="mb-3">
                    <label class="form-label"><strong>Tags</strong> </label>
                    <input type="text" name="tags" value="<?=$singlePost['tags']?>" class="form-control" placeholder="separate by comma , ">
                  </div>
                  <div class="mb-3">
                    <label class="form-label"><strong>Author</strong></label>
                    <select name="author_id" class="form-select">
                        <option value="" >Select Author</option>
                        <?php foreach($authors as $a): ?>
                            <option value="<?= $a->user_id;?>" <?php if($a->user_id == $singlePost['author_id']) echo "selected";?>><?= $a->first_name.' '.$a->last_name;?></option>
                        <?php endforeach;?>
                    </select>
                  </div>
                <!-- END Main post params  !-->
                </div>
            </div>
            <div class="row mb-4">
                <div class="accordion accordion-flush" id="accordionFlushExample">
                    <div class="accordion-item">
                        <h2 class="accordion-header" id="flush-headingOne">
                        <button class="accordion-button collapsed bg-info bg-opacity-10                                    " type="button" data-bs-toggle="collapse" data-bs-target="#flush-collapseOne" aria-expanded="false" aria-controls="flush-collapseOne">
                           Add SEO meta description and keywords
                        </button>
                        </h2>
                        <div id="flush-collapseOne" class="accordion-collapse collapse" aria-labelledby="flush-headingOne" data-bs-parent="#accordionFlushExample">
                        <div class="accordion-body">
                            <div class="row">
                <div class="col">
                    <div class="mb-3">
                    <label class="form-label"><strong>SEO Description</strong></label>
                    <textarea name="metadesc" class="form-control"   placeholder="Provide description(150 words) for SEO experience"><?=$singlePost['metadesc']?></textarea>
                  </div>
                </div>
                <div class="col">
                    <div class="mb-3">
                    <label class="form-label"><strong>SEO Keywords</strong></label>
                    <textarea name="metakey" class="form-control"   placeholder="SEO Keywords separated by comma"><?=$singlePost['metakey']?></textarea>
                  </div>
                </div>
            </div>
                        </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</form>
<!-- End Create/Post !-->
<!---- JS --->
<script src="<?= base_url();?>/assets/js/modules/posts.js"></script>  
<?= $this->endSection();?>