<?php

namespace Modules\CustomerCare\Models;

use CodeIgniter\Model;

class CustomerFeedbackModel extends Model
{

  protected $table = 'feedback';
    protected $primaryKey = 'id';

    protected $allowedFields = ['name', 'phone', 'email','subject_id', 'account_type', 'message', 'response',  'responded_by', 'responded_at'];

    protected $returnType     = 'array';
    protected $useTimestamps  = true;
    protected $useSoftDeletes = true;

    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at'; 
    protected $deletedField  = 'deleted_at';

    //Get all Rates
    public function getAll()
    {
      $builder = $this->db->table('feedback as f');
      $builder->select('f.*,fs.title as subject_name, p.title as account_name');
      $builder->join('usc_posts as p', 'p.id=f.account_type', 'left');
      $builder->join('feedback_subject as fs', 'fs.id=f.subject_id', 'left');
      $builder->join('usc_users as u', 'u.id=f.responded_by', 'left');
      $builder->where('f.deleted_at', null);
	  $result = $builder->get()->getResult();
	  return $result;
    }

    public function singleMessage($id)
    {
      $builder = $this->db->table('feedback as f');
      $builder->select('f.*,fs.title as subject_name, p.title as account_name');
      $builder->join('usc_posts as p', 'p.id=f.account_type', 'left');
      $builder->join('feedback_subject as fs', 'fs.id=f.subject_id', 'left');
      $builder->where('f.id', $id);
	  $result = $builder->get()->getRow();
	  return $result;
    }


}
