<?php

namespace Modules\CustomerCare\Controllers;

use App\Controllers\Auth\AuthController;
use Modules\CustomerCare\Models\CustomerFeedbackModel;
use Modules\CustomerCare\Models\FeedbackSubjectModel;
use Modules\CustomerCare\Models\SubjectAnswersModel;

class CustomerFeedback extends AuthController
{

  public $customerfeedbackModel;
  public $feedbacksubjectModel;
  public $subjectanswersModel;
  public $postsModel;
  public function initController($request, $response, $logger)
  {
    parent::initController($request, $response, $logger);
    $this->customerfeedbackModel = new CustomerFeedbackModel();
    $this->feedbacksubjectModel = new FeedbackSubjectModel();
    $this->subjectanswersModel = new SubjectAnswersModel();
    $this->postsModel = new \Modules\Posts\Models\PostsModel();

  }
  public function index()
  {
    // display header information
	$this->data['title'] = "Customers Feedback Panel";
    $this->data['bcrumb'] = "Customer Feedback";

        if (!$this->session->get('loggedIn'))
        {
            return redirect()
                ->to('login');
        }
    $this->data['feedback'] = $this->customerfeedbackModel->getAll();
    $this->data['subjects'] = $this->feedbacksubjectModel->getAll();
    $this->data['subject_answers'] = $this->subjectanswersModel->getAllWithSubjects();

    // Get account types from usc_posts table where content_type_id = 3 (services)
    $this->data['accountTypes'] = $this->postsModel->getAllServices();

    return view('Modules\CustomerCare\Views\index', $this->data);
  }
  public function delFeedback($id = null)
  {
    $this->data['title'] = "Customers Feedback Panel";
    $this->data['bcrumb'] = "Customer Feedback";

    if($this->customerfeedbackModel->where('id', $id)->delete($id))
    {
        session()->setTempdata('success', 'Message deleted successfully', 3);
	    return redirect()->to('administrator/feedback');
    }

  }

  public function allFeedback()
  {
    // display header information
    $this->data['title'] = "All Customer Feedback";
    $this->data['bcrumb'] = "All Feedback";

    if (!$this->session->get('loggedIn'))
    {
        return redirect()->to('login');
    }
    $this->data['feedback'] = $this->customerfeedbackModel->getAll();

    return view('Modules\CustomerCare\Views\panel', $this->data);
  }

  public function addFeedback()
  {
    if($this->request->getMethod() == 'POST'){
        $rules = [
          'name' => ['label'=>'Name', 'rules'=>'required'],
          'email' => ['label'=>'Email', 'rules'=>'required|valid_email'],
          'subject_id' => ['label'=>'Subject', 'rules'=>'required'],
          'message' => ['label'=>'Message', 'rules'=>'required'],
      ];

      if($this->validate($rules))
      {
          $fData = [
              'name'          => $this->request->getVar("name"),
              'email'         => $this->request->getVar("email"),
              'phone'         => $this->request->getVar("phone"),
              'subject_id'    => $this->request->getVar("subject_id"),
              'account_type'  => $this->request->getVar("account_type"),
              'message'       => $this->request->getVar("message"),
          ];

          if($this->customerfeedbackModel->save($fData))
          {
              session()->setTempdata('success', 'Feedback added successfully', 3);
              return redirect()->to('administrator/feedback');
          }else{
              session()->setTempdata('error', 'Feedback NOT added', 3);
              return redirect()->to('administrator/feedback');
          }
      }else{
        session()->setTempdata('error', 'Please fill all required fields', 3);
        return redirect()->to('administrator/feedback');
      }
    }
  }

  public function editFeedback($id = null)
  {
    // display header information
    $this->data['title'] = "Edit Customer Feedback";
    $this->data['bcrumb'] = "Edit Feedback";

    if (!$this->session->get('loggedIn'))
    {
        return redirect()->to('login');
    }

    $this->data['singleFeedback'] = $this->customerfeedbackModel->singleMessage($id);
    $this->data['subjects'] = $this->feedbacksubjectModel->getAll();

    // Get account types from usc_posts table where content_type_id = 3 (services)
    $this->data['accountTypes'] = $this->postsModel->getAllServices();

    return view('Modules\CustomerCare\Views\edit_feedback', $this->data);
  }

  public function updateFeedback()
  {
    if($this->request->getMethod() == 'POST'){
        $rules = [
          'name' => ['label'=>'Name', 'rules'=>'required'],
          'email' => ['label'=>'Email', 'rules'=>'required|valid_email'],
          'subject_id' => ['label'=>'Subject', 'rules'=>'required'],
          'message' => ['label'=>'Message', 'rules'=>'required'],
      ];

      if($this->validate($rules))
      {
          $id = $this->request->getVar("id");
          $fData = [
              'name'          => $this->request->getVar("name"),
              'email'         => $this->request->getVar("email"),
              'phone'         => $this->request->getVar("phone"),
              'subject_id'    => $this->request->getVar("subject_id"),
              'account_type'  => $this->request->getVar("account_type"),
              'message'       => $this->request->getVar("message"),
          ];

          if($this->customerfeedbackModel->update($id, $fData))
          {
              session()->setTempdata('success', 'Feedback updated successfully', 3);
              return redirect()->to('administrator/feedback');
          }else{
              session()->setTempdata('error', 'Feedback NOT updated', 3);
              return redirect()->to('administrator/feedback/edit/'.$id);
          }
      }else{
        session()->setTempdata('error', 'Please fill all required fields correctly', 3);
        return redirect()->to('administrator/feedback/edit/'.$this->request->getVar("id"));
      }
    }
    return redirect()->to('administrator/feedback');
  }

  // Get feedback for AJAX
  public function getFeedback($id)
  {
    try {
      if (!$this->session->get('loggedIn')) {
        return $this->response->setStatusCode(401)->setJSON(['error' => 'Unauthorized']);
      }

      $feedback = $this->customerfeedbackModel->singleMessage($id);
      if (!$feedback) {
        return $this->response->setStatusCode(404)->setJSON(['error' => 'Feedback not found']);
      }

      $subjects = $this->feedbacksubjectModel->getAll();
      $accountTypes = $this->postsModel->getAllServices();

      $data = [
        'data' => $feedback,
        'subjects' => $subjects,
        'accountTypes' => $accountTypes
      ];

      return view('Modules\CustomerCare\Views\edit_feedback_modal', $data);
    } catch (
Exception $e) {
      log_message('error', 'Error in getFeedback: ' . $e->getMessage());
      return $this->response->setStatusCode(500)->setJSON(['error' => 'Internal server error']);
    }
  }

  // Get subject for AJAX
  public function getSubject($id)
  {
    try {
      if (!$this->session->get('loggedIn')) {
        return $this->response->setStatusCode(401)->setJSON(['error' => 'Unauthorized']);
      }

      $subject = $this->feedbacksubjectModel->where('id', $id)->first();
      if (!$subject) {
        return $this->response->setStatusCode(404)->setJSON(['error' => 'Subject not found']);
      }

      $data = [
        'data' => $subject
      ];

      return view('Modules\CustomerCare\Views\edit_subject_modal', $data);
    } catch (
Exception $e) {
      log_message('error', 'Error in getSubject: ' . $e->getMessage());
      return $this->response->setStatusCode(500)->setJSON(['error' => 'Internal server error']);
    }
  }

  // Add response to feedback
  public function addResponse($id)
  {
    if($this->request->getMethod() == 'POST'){
        $rules = [
          'response' => ['label'=>'Response', 'rules'=>'required'],
      ];

      if($this->validate($rules))
      {
          $fData = [
              'response'       => $this->request->getVar("response"),
              'responded_by'   => session()->get('logged_user'), // Fixed: use 'logged_user' instead of 'user_id'
              'responded_at'   => date('Y-m-d H:i:s'),
          ];

          if($this->customerfeedbackModel->update($id, $fData))
          {
              // Send response email to customer
              $this->sendResponseEmail($id, $fData);

              session()->setTempdata('success', 'Response added successfully', 3);
              return redirect()->to('administrator/feedback');
          }else{
              session()->setTempdata('error', 'Response NOT added', 3);
              return redirect()->to('administrator/feedback');
          }
      }else{
        session()->setTempdata('error', 'Response cannot be empty', 3);
        return redirect()->to('administrator/feedback');
      }
    }
    return redirect()->to('administrator/feedback');
  }

  // Responses view
  public function responses()
  {
    // display header information
    $this->data['title'] = "ABC Responses";
    $this->data['bcrumb'] = "Responses";

    if (!$this->session->get('loggedIn'))
    {
        return redirect()->to('login');
    }

    // Get feedback that has responses or needs responses
    $this->data['feedback'] = $this->customerfeedbackModel->getAll();

    return view('Modules\CustomerCare\Views\responses', $this->data);
  }

/** ================================================================
 * Predifined Subjects
 * ===================================================================**/
 public function subject()
 {
     // display header information
	$this->data['title'] = "Subjects";
    $this->data['bcrumb'] = "Subjects";

    $this->data['subjects'] = $this->feedbacksubjectModel->getAll();

    return view('Modules\CustomerCare\Views\pre_questions', $this->data);
 }
 public function addSubject()
 {
    // display header information
	$this->data['title'] = "Add Pre-Defined Question";
    $this->data['bcrumb'] = "Add Question";

    $this->data['subjects'] = $this->feedbacksubjectModel->getAll();

    if($this->request->getMethod() == 'POST'){
        $rules = [
          'title' => ['label'=>'Subject Name', 'rules'=>'required'],
      ];

      if($this->validate($rules))
      {
          $sData = [
              'title'          => $this->request->getVar("title"),
              'description'   => $this->request->getVar("description"),
          ];

          if($this->feedbacksubjectModel->save($sData))
          {
              session()->setTempdata('success', 'Subject added successfully', 3);
              return redirect()->to('administrator/feedback');
          }else{
              session()->setTempdata('error', 'Subject NOT added', 3);
              return redirect()->to('administrator/feedback');
          }
      }else{
        session()->setTempdata('error', 'Subject Name can not be empty', 3);
        return redirect()->to('administrator/feedback');
      }
    }
    return view('Modules\CustomerCare\Views\pre_questions', $this->data);
 }
 public function editSubject($id = null)
 {
     // display header information
	$this->data['title'] = "Edit Pre-Defined Question";
    $this->data['bcrumb'] = "Edit Question";

    $this->data['subjects'] = $this->feedbacksubjectModel->getAll();
    $this->data['singleSubject'] = $this->feedbacksubjectModel->where('id', $id)->first($id);

    return view('Modules\CustomerCare\Views\pre_questions', $this->data);
 }
 public function updateSubject()
 {
    // display header information
	$this->data['title'] = "Edit Pre-Defined Question";
    $this->data['bcrumb'] = "Edit Question";

    $this->data['subjects'] = $this->feedbacksubjectModel->getAll();

    if($this->request->getMethod() == 'POST'){
        $rules = [
          'title' => ['label'=>'Subject Name', 'rules'=>'required'],
      ];

      if($this->validate($rules))
      {
          $id = $this->request->getVar("id");
          $sData = [
              'title'          => $this->request->getVar("title"),
              'description'   => $this->request->getVar("description"),
          ];

          if($this->feedbacksubjectModel->update($id, $sData))
          {
              session()->setTempdata('success', 'Subject updated successfully', 3);
              return redirect()->to('administrator/feedback');
          }else{
              session()->setTempdata('error', 'Subject NOT updated', 3);
              return redirect()->to('administrator/feedback');
          }
      }else{
        session()->setTempdata('error', 'Subject Name can not be empty', 3);
        return redirect()->to('administrator/feedback');
      }
    }
    return view('Modules\CustomerCare\Views\pre_questions', $this->data);
 }
 public function delSubject($id = null)
 {
     // display header information
	$this->data['title'] = "Pre-Defined Question";
    $this->data['bcrumb'] = "Question";

    $this->data['subjects'] = $this->feedbacksubjectModel->getAll();
    if($this->feedbacksubjectModel->where('id', $id)->delete($id))
    {
        session()->setTempdata('success', 'Subject deleted successfully', 3);
		return redirect()->to('administrator/feedback');
    }

    return view('Modules\CustomerCare\Views\pre_questions', $this->data);
 }

  // Send response email to customer
  private function sendResponseEmail($id, $responseData)
  {
    try {
      // Get the feedback details
      $feedback = $this->customerfeedbackModel->singleMessage($id);
      if (!$feedback) {
        log_message('error', 'Feedback not found for response email: ' . $id);
        return false;
      }

      // Get responder details (assuming it's a user from the users table)
      $responderName = 'ABC Bank Customer Care';
      if ($responseData['responded_by']) {
        // You might need to adjust this based on your user model
        $userModel = new \App\Models\UsersModel();
        $user = $userModel->find($responseData['responded_by']);
        if ($user) {
          $responderName = $user['name'] ?? $user['username'] ?? 'ABC Bank Customer Care';
        }
      }

      $email = \Config\Services::email();

      $emailTemplate = view('email_templates/contact_response_template', [
        'clientName' => $feedback->name,
        'response' => $responseData['response'],
        'messageId' => $id,
        'originalMessage' => $feedback->message,
        'respondedBy' => $responderName,
      ]);

      $email->setMailType('html');
      $email->setFrom('ithelp@abccapitalbank.co.ug', 'ABC Capital Bank Customer Care');
      $email->setTo($feedback->email);
      $email->setSubject('Response to Your Contact Form Message - ABC Capital Bank');
      $email->setMessage($emailTemplate);

      $result = $email->send();

      if (!$result) {
        log_message('error', 'Failed to send response email to: ' . $feedback['email'] . ' for message ID: ' . $id);
      }

      return $result;
    } catch (
Exception $e) {
      log_message('error', 'Error sending response email: ' . $e->getMessage());
      return false;
    }
  }

/** ================================================================
 * Subject Answers Management
 * ===================================================================**/

  public function addSubjectAnswer()
  {
    if ($this->request->getMethod() == 'POST') {
      $rules = [
        'subject_id' => ['label' => 'Subject', 'rules' => 'required|numeric'],
        'answer' => ['label' => 'Answer', 'rules' => 'required'],
      ];

      if ($this->validate($rules)) {
        $sData = [
          'subject_id' => $this->request->getVar("subject_id"),
          'answer' => $this->request->getVar("answer"),
        ];

        if ($this->subjectanswersModel->save($sData)) {
          session()->setTempdata('success', 'Subject Answer added successfully', 3);
          return redirect()->to('administrator/feedback');
        } else {
          session()->setTempdata('error', 'Subject Answer NOT added', 3);
          return redirect()->to('administrator/feedback');
        }
      } else {
        session()->setTempdata('error', 'Please fill all required fields', 3);
        return redirect()->to('administrator/feedback');
      }
    }
    return redirect()->to('administrator/feedback');
  }

  public function getSubjectAnswer($id)
  {
    try {
      if (!$this->session->get('loggedIn')) {
        return $this->response->setStatusCode(401)->setJSON(['error' => 'Unauthorized']);
      }

      $answer = $this->subjectanswersModel->withDeleted()->find($id);
      if (!$answer) {
        return $this->response->setStatusCode(404)->setJSON(['error' => 'Subject Answer not found']);
      }

      $subjects = $this->feedbacksubjectModel->getAll();

      $data = [
        'data' => $answer,
        'subjects' => $subjects
      ];

      return view('Modules\CustomerCare\Views\edit_subject_answer_modal', $data);
    } catch (
Exception $e) {
      log_message('error', 'Error in getSubjectAnswer: ' . $e->getMessage());
      return $this->response->setStatusCode(500)->setJSON(['error' => 'Internal server error']);
    }
  }

  public function updateSubjectAnswer()
  {
    if ($this->request->getMethod() == 'POST') {
      $rules = [
        'id' => ['label' => 'ID', 'rules' => 'required|numeric'],
        'subject_id' => ['label' => 'Subject', 'rules' => 'required|numeric'],
        'answer' => ['label' => 'Answer', 'rules' => 'required'],
      ];

      if ($this->validate($rules)) {
        $id = $this->request->getVar("id");
        $sData = [
          'subject_id' => $this->request->getVar("subject_id"),
          'answer' => $this->request->getVar("answer"),
        ];

        if ($this->subjectanswersModel->update($id, $sData)) {
          session()->setTempdata('success', 'Subject Answer updated successfully', 3);
          return redirect()->to('administrator/feedback');
        } else {
          session()->setTempdata('error', 'Subject Answer NOT updated', 3);
          return redirect()->to('administrator/feedback');
        }
      }
    } else {
      session()->setTempdata('error', 'Please fill all required fields correctly', 3);
      return redirect()->to('administrator/feedback');
    }
    return redirect()->to('administrator/feedback');
  }

  public function deleteSubjectAnswer($id = null)
  {
    if (!$this->session->get('loggedIn')) {
      return redirect()->to('login');
    }

    if ($this->subjectanswersModel->delete($id, true)) {
      session()->setTempdata('success', 'Subject Answer deleted successfully', 3);
      return redirect()->to('administrator/feedback');
    } else {
      session()->setTempdata('error', 'Subject Answer NOT deleted', 3);
      return redirect()->to('administrator/feedback');
    }
  }


}