<?php

namespace Modules\CustomerCare\Config;

use Config;
// Create a new instance of our RouteCollection class.
$routes = Config\Services::routes();

// Load the system's routing file first, so that the app and ENVIRONMENT
// can override as needed.
if (is_file(SYSTEMPATH . 'Config/Routes.php')) {
    require SYSTEMPATH . 'Config/Routes.php';
}


//setting up Customer Feedback routes.
$routes->group('administrator/feedback', ['filter' => 'isLoggedIn', 'namespace' => 'Modules\CustomerCare\Controllers'],   static function($routes){

    $routes->GET('/', 'CustomerFeedback::index');
    $routes->GET('all', 'CustomerFeedback::allFeedback');
    $routes->POST('add', 'CustomerFeedback::addFeedback');
    $routes->GET('edit/(:any)', 'CustomerFeedback::editFeedback/$1');
    $routes->POST('update',  'CustomerFeedback::updateFeedback');
    $routes->GET('delete/(:any)', 'CustomerFeedback::delFeedback/$1');

    $routes->GET('responses', 'CustomerFeedback::responses');
    $routes->POST('response/add/(:any)', 'CustomerFeedback::addResponse/$1');

    $routes->GET('subjects', 'CustomerFeedback::subject');
    $routes->POST('subject/add', 'CustomerFeedback::addSubject');
    $routes->GET('subject/edit/(:any)', 'CustomerFeedback::editSubject/$1');
    $routes->POST('subject/update',  'CustomerFeedback::updateSubject');
    $routes->GET('subject/delete/(:any)', 'CustomerFeedback::delSubject/$1');
});

$routes->group('subjectanswers', ['namespace' => 'Modules\CustomerCare\Controllers'], static function($routes){
    $routes->POST('add', 'CustomerFeedback::addSubjectAnswer');
    $routes->GET('answer/get/(:num)', 'CustomerFeedback::getSubjectAnswer/$1');
    $routes->POST('update', 'CustomerFeedback::updateSubjectAnswer');
    $routes->GET('delete/(:num)', 'CustomerFeedback::deleteSubjectAnswer/$1');


    // AJAX routes for modals
    $routes->GET('get/(:any)', 'CustomerFeedback::getFeedback/$1');
    $routes->GET('subject/get/(:any)', 'CustomerFeedback::getSubject/$1');
});
