<?php

namespace Modules\Banners\Config;

use Config;
// Create a new instance of our RouteCollection class.
$routes = Config\Services::routes();

// Load the system's routing file first, so that the app and ENVIRONMENT
// can override as needed.
if (is_file(SYSTEMPATH . 'Config/Routes.php')) {
    require SYSTEMPATH . 'Config/Routes.php';
}

// Admin routes with authentication and permission checks
$routes->group('administrator/banners', ['filter' => ['isLoggedIn', 'checkPermission'], 'namespace' => 'Modules\Banners\Controllers'], static function($routes) {
    // View routes
    $routes->GET('/', 'Banners::index');
    $routes->GET('list', 'Banners::list');

    // Management routes
    $routes->GET('new', 'Banners::new');
    $routes->POST('create', 'Banners::create');
    $routes->GET('edit/(:num)', 'Banners::edit/$1');
    $routes->POST('update/(:num)', 'Banners::update/$1');
    $routes->POST('delete/(:num)', 'Banners::delete/$1');

    // Media management
    $routes->POST('media/upload', 'Banners::uploadMedia');
    $routes->POST('media/delete', 'Banners::deleteMedia');

    // Context and service group management
    $routes->GET('contexts', 'Banners::contexts');
    $routes->GET('service-groups', 'Banners::serviceGroups');

    // Settings
    $routes->GET('settings', 'Banners::settings');
    $routes->POST('settings/update', 'Banners::updateSettings');
});

// Public API endpoints for banner retrieval
$routes->group('api/banners', ['namespace' => 'Modules\Banners\Controllers'], static function($routes) {
    // Base banner types
    $routes->GET('hero', 'Banners::getHeroBanners');
    $routes->GET('promotional', 'Banners::getPromotionalBanners');
    $routes->GET('featured', 'Banners::getFeaturedBanners');

    // Dynamic context and service group routes
    $routes->GET('context/(:segment)', 'Banners::getByContext/$1');
    $routes->GET('service-group/(:segment)', 'Banners::getByServiceGroup/$1');
    $routes->GET('context/(:segment)/service-group/(:segment)', 'Banners::getByContextAndServiceGroup/$1/$2');
});