<?= $this->extend('Modules\Admin\Views\index'); ?>
<?= $this->section('content');?>
<!-- Home page !-->

<!-- print success message !-->
<div class="row">
    <div class="col">
		<!-- print success message !-->
		<?php if(session()->getTempdata('success')): ?>
			<div class="alert alert-success" role="alert"><?= session()->getTempdata('success');?></div>
		<?php endif;?>
		<!-- print failure message !-->
		<?php if(session()->getTempdata('error')): ?>
			<div class="alert alert-danger" role="alert"><?= session()->getTempdata('error');?></div>
		<?php endif;?>
        <?php if(isset($validation)): ?>
			<div class="alert alert-danger">
		<?= $validation->listErrors()?>
		</div>
        <?php endif;?>
        <div id="showMsg"></div>
</div></div>           
<div class="container-fluid mb-4">
    <div class="card card-body">
        <div class="d-flex bd-highlight">
        <div class="p-2 bd-highlight flex-grow-1"><h3>All Administrators & Contributors</h3></div>
        <div class="p-2 bd-highlight"><a class="btn btn-sm btn-primary" href="<?= base_url('administrator/users/register'); ?>">Create User</a></div>
        </div>
        <div class="table-responsive">
            <table class="table table-hovered" id="userslist">
                <thead style="font-size:13px">
                    <th>#</th>
                    <th>Name</th>
                    <th>Email</th>
                    <th>Mobile No.</th>
                    <th>Position</th>
                    <th>Role</th>
                    <th>Action</th>
                </thead>
                <tbody style="font-size:13px">
                    <?php foreach($users as $u):?>
                    <tr>
                    <td><?= $u->user_id; ?></td>
                    <td><?= $u->first_name.' '.$u->last_name; ?></td>
                    <td><?= $u->email; ?></td>
                    <td><?= $u->mobile; ?></td>
                    <td><small><?= $u->position; ?><?php if($u->org_name != Null):?><br/><span class="text-muted"> <?= $u->org_name; ?></span><?php endif;?> </small></td>
                    <td><?= $u->role; ?></td>
                    <td>
                        <div class="btn-group dropstart">
                        <button type="button" class="btn btn-white p-1" data-bs-toggle="dropdown" aria-expanded="false">
                        <i class="bi bi-three-dots-vertical"></i>
                        </button>
                        <ul class="dropdown-menu">
                            <li><a class="dropdown-item" href="<?= base_url('administrator/users/edit/').'/'.$u->user_id; ?>"><small>Edit Profile</small></a></li>
                            <li><a class="dropdown-item" title="Password" href="<?= base_url('administrator/change/password').'/'.$u->user_id; ?>"> <small>Change Password</small></a></li>
                            <li><a class="dropdown-item"  onclick="delete_user(<?= $u->user_id ?>, '<?= $u->first_name.' '.$u->last_name ?>')" style="cursor: pointer"><small>Delete</small></a></li>
                        </ul>
                        </div>
                    </td>
                    </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>
<!---- Modals --->
<?= view('Modules\Admin\Views\\modals\\del_userModal') ?>
<?= view('Modules\Admin\Views\\modals\\change_userPassword') ?>

<!-- JS !-->
<script type="text/javascript">
      $(document).ready(function () {
          $('#userslist').DataTable({
            pageLength: 10,
            order: [[0, "Desc"]],
          });
      });

</script>               
<script src="<?= base_url();?>/assets/js/modules/user.js"></script>   
<?= $this->endSection();?>