<?= $this->extend('Modules\Admin\Views\index'); ?>
<?= $this->section('content');?>
<div class="pagetitle">
      <h1>User Profile</h1>
      <nav>
        <ol class="breadcrumb">
          <li class="breadcrumb-item"><a href="<?= base_url('administrator'); ?>">Home</a></li>
          <li class="breadcrumb-item active">Dashboard</li>
        </ol>
      </nav>
    </div><!-- End Page Title -->
    <!-- Alerts here !-->
    <?php if(session()->getTempdata('error')):?>
    <div class="alert alert-danger">  <?= session()->getTempdata('error');?></div>
    <?php endif;?>
      <?php if(session()->getTempdata('success')):?>
      <div class="alert alert-success">  <?= session()->getTempdata('success');?></div>
      <?php endif;?>
			<?php if(session()->getTempdata('warning')):?>
      <div class="alert alert-warning">  <?= session()->getTempdata('warning');?></div>
      <?php endif;?> 					
    </div>
    <?php if(isset($validation)): ?>
			<div class="alert alert-danger">
			<?= $validation->listErrors()?>
			</div>
    <?php endif;?>

    <!-- End of Alerts !-->

    <section class="section profile">
      <div class="row">
        <div class="col-xl-4">

          <div class="card">
            <div class="card-body profile-card pt-4 d-flex flex-column align-items-center">
            <?php if(!isset($userdata->profile_photo)):?>
                <img src="<?= base_url();?>/assets/images/profiler.jpeg" alt="" class="rounded-circle mb-3" width="120px" height="120px">
              <?php else:?>
                <img src="<?= $userdata->profile_photo;?>" alt="<?= $userdata->first_name;?>" class="rounded-circle mb-3" width="120px" height="120px">
              <?php endif;?>
           <!-- End Profile Iamge Icon -->
              <h5><?= $userdata->first_name .' '.$userdata->last_name; ?></h5>
              
              <div class="social-links mt-2">
                <a href="https://www.twitter.com/<?= $userdata->twitter ?>" class="twitter"><i class="bi bi-twitter"></i></a>
                <a href="https://www.facebook.com/<?= $userdata->facebook ?>" class="facebook"><i class="bi bi-facebook"></i></a>
                <a href="https://www.instagram.com/<?= $userdata->instagram?>" class="instagram"><i class="bi bi-instagram"></i></a>
                <a href="https://www.linkedin.com/<?= $userdata->linkedin; ?>" class="linkedin"><i class="bi bi-linkedin"></i></a>
              </div>
            </div>
          </div>

        </div>

        <div class="col-xl-8">

          <div class="card">
            <div class="card-body pt-3">
              <!-- Bordered Tabs -->
              <ul class="nav nav-tabs nav-tabs-bordered">

                
                <li class="nav-item">
                  <button class="nav-link active" data-bs-toggle="tab" data-bs-target="#profile-edit">Edit Profile</button>
                </li>

                <li class="nav-item">
                  <button class="nav-link" data-bs-toggle="tab" data-bs-target="#profile-change-password">Change Password</button>
                </li>

              </ul>
              <div class="tab-content pt-2">

                <div class="tab-pane fade show active profile-edit pt-3" id="profile-edit">

                  <!-- Profile Edit Form -->
                  <form method="post" action="<?= base_url('administrator/my-profile/update');?>"  enctype="multipart/form-data">
                    <?= csrf_field(); ?>
                    <div class="row mb-3">
                      <label for="profileImage" class="col-md-4 col-lg-3 col-form-label">Profile Image</label>
                      <div class="col-md-8 col-lg-9">
                      <?php if(!isset($userdata->profile_photo)):?>
                      <img src="<?= base_url();?>/assets/images/profiler.jpeg" alt="" class="rounded-circle" width="100px" height="100px">
                    <?php else:?>
                      <img src="<?= $userdata->profile_photo;?>" alt="<?= $userdata->first_name;?>" class="rounded-circle " width="100px" height="100px">
                    <?php endif;?>
                        <div class="pt-2">
                          <input type="file" name="photo" class="form-file" accepted="image/jpeg, image/png, image/gif"/>
                        </div>
                      </div>
                    </div>

                    <div class="row mb-3">
                      <label for="fullName" class="col-md-4 col-lg-3 col-form-label">Full Name</label>
                      <div class="col-md-8 col-lg-9">
                        <div class="row">
                          <div class="col"> <input name="first_name" type="text" class="form-control" id="fullName" value="<?= $userdata->first_name; ?>"></div>
                          <div class="col"><input name="last_name" type="text" class="form-control" id="fullName" value="<?= $userdata->last_name; ?>"></div>
                        </div>
                      </div>
                    </div>
                    <div class="row mb-3">
                      <label for="Phone" class="col-md-4 col-lg-3 col-form-label">Phone</label>
                      <div class="col-md-8 col-lg-9">
                        <input name="mobile" type="text" class="form-control" id="Phone" value="<?= $userdata->mobile; ?>">
                      </div>
                    </div>

                    <div class="row mb-3">
                      <label for="Email" class="col-md-4 col-lg-3 col-form-label">Email</label>
                      <div class="col-md-8 col-lg-9">
                        <input name="email" type="email" class="form-control bg-secondary bg-opacity-10" id="Email" value="<?= $userdata->email; ?>" readonly>
                      </div>
                    </div>

                    <div class="row mb-3">
                      <label for="Gender" class="col-md-4 col-lg-3 col-form-label">Gender</label>
                      <div class="col-md-8 col-lg-9">
                        <select name="gender" class="form-select">
                          <option value="">Select </option>
                          <option value="Male" <?php if($userdata->gender == "male") echo "selected"; ?>>Male</option>
                          <option value="Female" <?php if($userdata->gender == "female") echo "selected"; ?>>Female</option>
                        </select>
                      </div>
                    </div>
                    <div class="row mb-3">
                      <label for="bday" class="col-md-4 col-lg-3 col-form-label">Birthday</label>
                      <div class="col-md-8 col-lg-9">
                        <input name="birthday" type="datetime-local" class="form-control" id="bday" value="<?= date('Y-m-d\TH:i',strtotime($userdata->birthday)); ?>">
                      </div>
                    </div>

                    <div class="row mb-3">
                      <label for="Address" class="col-md-4 col-lg-3 col-form-label">Address</label>
                      <div class="col-md-8 col-lg-9">
                        <input name="address" type="text" class="form-control" id="Address" value="<?= $userdata->address; ?>">
                      </div>
                    </div>

                    

                    <div class="row mb-3">
                      <label for="Twitter" class="col-md-4 col-lg-3 col-form-label">Twitter Profile</label>
                      <div class="col-md-8 col-lg-9">
                        <input name="twitter" type="text" class="form-control" id="Twitter" value="<?= $userdata->twitter; ?>">
                      </div>
                    </div>

                    <div class="row mb-3">
                      <label for="Facebook" class="col-md-4 col-lg-3 col-form-label">Facebook Profile</label>
                      <div class="col-md-8 col-lg-9">
                        <input name="facebook" type="text" class="form-control" id="Facebook" value="<?= $userdata->facebook; ?>">
                      </div>
                    </div>

                    <div class="row mb-3">
                      <label for="Instagram" class="col-md-4 col-lg-3 col-form-label">Instagram Profile</label>
                      <div class="col-md-8 col-lg-9">
                        <input name="instagram" type="text" class="form-control" id="Instagram" value="<?= $userdata->instagram; ?>">
                      </div>
                    </div>

                    <div class="row mb-3">
                      <label for="Linkedin" class="col-md-4 col-lg-3 col-form-label">Linkedin Profile</label>
                      <div class="col-md-8 col-lg-9">
                        <input name="linkedin" type="text" class="form-control" id="Linkedin" value="<?= $userdata->linkedin; ?>">
                      </div>
                    </div>

                    <div class="text-center d-grid">
                      <input type="hidden" name="id" value="<?= $userdata->user_id; ?>" />
                      <button type="submit" class="btn btn-primary">Save Changes</button>
                    </div>
                  </form><!-- End Profile Edit Form -->

                </div>

                <div class="tab-pane fade pt-3" id="profile-change-password">
                  <!-- Change Password Form -->
                  <form method="post" action="<?= base_url('administrator/password/update');?>">
                    <?= csrf_field(); ?>
                    <div class="row mb-3">
                      <label for="newPassword" class="col-md-4 col-lg-3 col-form-label">New Password</label>
                      <div class="col-md-8 col-lg-9">
                        <input name="password" type="password" class="form-control" id="newPassword">
                      </div>
                    </div>

                    <div class="row mb-3">
                      <label for="renewPassword" class="col-md-4 col-lg-3 col-form-label">Re-enter New Password</label>
                      <div class="col-md-8 col-lg-9">
                        <input name="cpass" type="password" class="form-control" id="renewPassword">
                      </div>
                    </div>

                    <div class="text-center">
                    <input type="hidden" name="user_id" value="<?= $userdata->user_id; ?>" />
                      <button type="submit" class="btn btn-primary">Change Password</button>
                    </div>
                  </form><!-- End Change Password Form -->

                </div>

              </div><!-- End Bordered Tabs -->

            </div>
          </div>

        </div>
      </div>
    </section>

 <?= $this->endSection();?>