<?php

namespace Modules\Admin\Controllers;

use App\Controllers\Auth\AuthController;
use App\Models\UsersModel;
use CodeIgniter\HTTP\Response;
use CodeIgniter\I18n\Time;
use Config\Services;

class Notifications extends AuthController
{
    public function initController($request, $response, $logger)
    {
        parent::initController($request, $response, $logger);
    }

    public function index()
    {
        $this->data['title'] = 'Notifications';
        $this->data['bcrumb'] = 'Notifications';
		
        $this->data['notifications'] = $this->notificationsModel->getAlertsByUserId($this->userdata->user_id);
        
        
        return view('Modules\Admin\Views\\notifications\\notifications', $this->data);
    }
    public function getNotificationsList()
    {
    $data = $this->notificationsModel->getAlertsByUserId($this->userdata->user_id);
    $response = [
                 'success' => true,
                 'data' => $data,
    ];
    return $this->response->setJSON($response);
    }
    public function status()
    {
        $this->data['title'] = 'Notifications';
        $this->data['bcrumb'] = 'Notifications';
        
    if($this->request->getMethod() == 'post')
    {
        $id = $this->request->getVar('id');    
        $cData = [
                'status'   => $this->request->getVar('status'),
            ];
        $results = $this->notificationsModel->update($id, $cData);
        if($results)
        {
            if($this->request->isAJAX())
            {
                    $response = [
                    'success' => true,
                    'msg' =>'Status changed successfully',	   
                    ];
                return $this->response->setJSON($response);
            }else{
                session()->setFlashdata('success', 'Status changed successfully');
                return redirect()->to('notifications');
            }
        }
    }
    return view('Modules\Admin\Views\notifications\notifications', $this->data);
    }
}