<?php

namespace Modules\Admin\Controllers;

use App\Controllers\Auth\AuthController;


class Dashboard extends AuthController
{


  public function index()
  {
    // display header information
	$this->data['title'] = "Dashboard";
    $this->data['bcrumb'] = "Dashboard";

    $this->data['activities'] = $this->notificationsModel->getLatestActivities($this->userdata->user_id);

    // Get website traffic statistics
    $this->data['total_hits'] = $this->webtrafficModel->getTotalHits();

    // Get total counts for dashboard
    $this->data['total_posts'] = $this->postsModel->where('content_type_id', 2)->where('deleted_at', null)->countAllResults();
    $this->data['total_pages'] = $this->postsModel->where('content_type_id', 1)->where('deleted_at', null)->countAllResults();
    $this->data['total_downloads'] = $this->downloadsModel->where('deleted_at', null)->countAllResults();

	return view('Modules\Admin\Views\dashboard\dashboard', $this->data);
  }
  
  //Display User Profile
  public function userProfile()
  {
      //Page title & Path
      $this->data['title'] = $this->userdata->first_name.' '.$this->userdata->last_name.' Profile';
      $this->data['bcrumb'] =  $this->userdata->first_name.' Profile';

      
      return View('Modules\Admin\Views\dashboard\users_profile', $this->data);
  }

  public function updateUserProfile()
  {
        //Page title & Path
        $this->data['title'] = $this->userdata->first_name.' '.$this->userdata->last_name.' Profile';
        $this->data['bcrumb'] =  $this->userdata->first_name.' Profile';
        $id = $this->request->getPost('id');
        
        $rules = [
            'first_name' => ['label' => 'Name', 'rules' => 'required'],
        ];
        $photoRules = [
            'photo' => [
                'label' => 'Image File',
                'rules' => 'uploaded[photo]'
                    . '|is_image[photo]'
                    . '|mime_in[photo,image/jpg,image/jpeg,image/gif,image/png,image/webp]'
                    . '|max_size[photo,1024]'
            ],
        ];
        if($this->validate($rules))
        {
            //Profile Image is uploaded
            $file1 = $this->request->getFile('photo');
            if($file1 != "")
            {
                if($this->validate($photoRules))
                { 
                    $newName4 = $file1->getRandomName();
                    $file1->move(ROOTPATH . 'media/user/profiles', $newName4);
                    $nwn1 = base_url('/media/user/profiles/').'/'.$newName4;

                    $adminData = [
                        'profile_photo'     => $nwn1,
                        'first_name'        => $this->request->getVar('first_name'),
                        'last_name'         => $this->request->getVar('last_name'),
                        'address'           => $this->request->getVar('address'),
                        'mobile'            => $this->request->getVar('mobile'),
                        'gender'            => $this->request->getVar('gender'),
						'birthday'          => $this->request->getVar('birthday'),
                        'city_id'           => $this->request->getPost('city_id'),
                        'state_id'          => $this->request->getPost('state_id'),
                        'country_id'        => $this->request->getPost('country_id'),
                        'facebook'          => $this->request->getVar('facebook'),
                        'twitter'           => $this->request->getVar('twitter'),
                        'whatsapp'          => $this->request->getVar('whatsapp'),
                        'instagram'         => $this->request->getVar('instagram'),
                        'linkedin'          => $this->request->getVar('linkedin'),
                        'updated_at'        => date('Y-m-d H:i:s'),
                    ];
                    if($this->userModel->update($id, $adminData))
                    {
                        session()->setFlashdata('success', 'Profile Updated with photo Successfully');
                        return redirect()->to('administrator/my-profile');;
                    }else
                    {
                        session()->setFlashdata('success', 'Profile not Updated');
                        return redirect()->to('administrator/my-profile');;
                    }
                }else
                {
                    $this->data['validation'] = $this->validator;
                }
            }else
            {
                $adminData = [
                    'first_name'        => $this->request->getVar('first_name'),
                    'last_name'         => $this->request->getVar('last_name'),
                    'address'           => $this->request->getVar('address'),
                    'mobile'            => $this->request->getVar('mobile'),
                    'gender'            => $this->request->getVar('gender'),
					'birthday'          => $this->request->getVar('birthday'),
                    'city_id'           => $this->request->getPost('city_id'),
                    'state_id'          => $this->request->getPost('state_id'),
                    'country_id'        => $this->request->getPost('country_id'),
                    'facebook'          => $this->request->getVar('facebook'),
                    'twitter'           => $this->request->getVar('twitter'),
                    'whatsapp'          => $this->request->getVar('whatsapp'),
                    'instagram'         => $this->request->getVar('instagram'),
                    'linkedin'          => $this->request->getVar('linkedin'),
                    'updated_at'        => date('Y-m-d H:i:s'),
                ];

                if($this->userModel->update($id, $adminData))
                    {
                        if($this->request->isAJAX())
                        {
                        $response = [
                            'success' => true,
                            'msg' =>'Profile Updated Successfully',	   
                        ];
                        return $this->response->setJSON($response);
                        }else{
                            session()->setFlashdata('success', 'Profile Updated Successfully');
                            return redirect()->to('administrator/my-profile');
                        }
                    }else
                    {
                        $this->session->setFlashdata('success', 'Profile not Updated');
                        return redirect()->to('administrator/my-profile');
                    }
            }
        }else
        {
            $this->data['validation'] = $this->validator;
        }
    
        return View('Modules\Admin\Views\dashboard\users_profile', $this->data);
    }
    public function updateUserPwd()
    {
        //Page title & Path
        $this->data['title']   = 'Password & Security';
        $this->data['bcrumb'] = 'Update Password';

        if($this->request->getMethod() == 'post')
        {
            $rules = [
                'password' => ['label' => 'Password', 'rules' => 'required|min_length[8]|max_length[18]|alpha_numeric_punct'],
                'cpass'	=> ['label' => 'Confirm Password', 'rules' => 'required|min_length[8]|max_length[20]|matches[password]'],
            ];
            if($this->validate($rules))
            {
                $id = $this->request->getVar('user_id');
                $password = password_hash($this->request->getVar('password'), PASSWORD_DEFAULT);
                if($this->userModel->updatePassword($id, $password))
                {
                    
                      session()->setFlashdata('success', 'Password updated successfully');
                      return redirect()->to('administrator/my-profile');
                    
                }else
                {
                      session()->setFlashdata('success', 'Password update failed');
                      return redirect()->to('administrator/my-profile');
                }
            }else{
              $this->data['validation'] = $this->validator;
            }
        }
        return View('Modules\Admin\Views\dashboard\users_profile', $this->data);
    }
    public function addUser()
    {
        if (!$this->session->get('loggedIn'))
        {
            return redirect()
                ->to('login');
        }
        // display header information
		$this->data['title'] = "User Registration";
        $this->data['bcrumb'] = "Add User";

        if($this->request->getMethod() == 'post')
		{
			$rules = $this->validation->getRuleGroup('userRegister');
			$email 			= \Config\Services::email();

				if($this->validate($rules))
				{
					$gcode	  	= $this->GUID();
					$fname =  substr($this->request->getVar('first_name'), 0, 2);
					$lname = substr($this->request->getVar('last_name'), 0, 1); 
                    $userNo		= strtoupper(('LTS-'.''.$fname.''.$lname));
					$userdata = [
						'first_name' 			=> $this->request->getVar('first_name', FILTER_SANITIZE_STRING),
						'last_name' 			=> $this->request->getVar('last_name', FILTER_SANITIZE_STRING),
						'email' 				=> $this->request->getVar('email'),
                        'mobile' 				=> $this->request->getVar('mobile'),
						'password'				=> password_hash($this->request->getVar('password'), PASSWORD_DEFAULT),
						'auth_code'		        => $gcode,
						'usc_code'				=> $userNo,
						'position' 				=> $this->request->getVar('position'),
						'org_name' 				=> $this->request->getVar('org_name'),
                        'address' 				=> $this->request->getVar('address'),
						'role_id'		        => '4',
						
					
					];
					 
					if($this->registerModel->insert($userdata))
					{
					    $filepath = 'assets/images/logo-mobile.png';
						$to = $this->request->getVar('email');
						$subject = 'Account Activation Link - ABC Capital Website';
						$message = 'Hello '.$this->request->getVar('first_name').",<br><br>Your account has been created "
						."successfully. Please click on the link below to activate your account <br><br>"
						."<a href='".base_url()."/user/activate/".$gcode."'>Activate Now</a><br><br> OR copy this URL below into address bar and activate<br><strong> ".base_url()."/admin/register/activate/".$gcode." </strong><br><br>Thank You<br>Uganda Safari Chapter!";
						
						$email->setTo($to);
						$email->setFrom('no-reply@abccapitalbank.co.ug', 'ABC CMS');
						$email->setSubject($subject);
						$email->setMessage($message);
						$email->attach($filepath);
						$email->setMailType('html');
						if($this->email->send())
							{
								session()->setTempdata('success', 'Account created successfully. Activation link sent to your email');
								return redirect()->to('administrator/users');	
							}else{
								session()->setTempdata('error', 'Account created successfully. Sorry unable to send you activation link. Contact Admin');
								return redirect()->to('administrator/users/register');	
							}
					}else{
						session()->setTempdata('error', 'Sorry! Unable to create account. Try again');
						return redirect()->to('administrator/users/register');
					}
				}else{
					$this->data['validation'] = $this->validator;
				}
		}
        return view('Modules\Admin\Views\users\add_user', $this->data);
    }
    public function allUsers()
    {
        // display header information
	    $this->data['title'] = "Users";
        $this->data['bcrumb'] = "Users";
        
        $this->data['users'] = $this->userModel->getAllUsers();
		// var_dump($users);

		 //$this->data['users']
        
        return view('Modules\Admin\Views\users\all_users', $this->data);
    }
    public function editUser($id = null)
    {
        // display header information
	    $this->data['title'] = "Update User details";
        $this->data['bcrumb'] = "Edit User";
        
        $this->data['user_roles'] = $this->roleModel->getAll();
        $this->data['user'] = $this->userModel->where('user_id', $id)->first($id);
        
        return view('Modules\Admin\Views\users\add_user', $this->data);
    }
    public function updateUser()
    {
        // display header information
	    $this->data['title'] = "Update User details";
        $this->data['bcrumb'] = "Edit User";
        
        $this->data['user_roles'] = $this->roleModel->getAll();
        if($this->request->getMethod() == 'post')
		{
			$email 			= \Config\Services::email();
			$id         = $this->request->getVar('user_id');
			$rules = [
                'first_name' => ['label'=>'First Name', 'rules'=>'required'],
                'email' => ['label'=>'Email', 'rules'=>'required'],
                ];

				if($this->validate($rules))
				{
					$userdata = [
						'first_name' 			=> $this->request->getVar('first_name', FILTER_SANITIZE_STRING),
						'last_name' 			=> $this->request->getVar('last_name', FILTER_SANITIZE_STRING),
						'email' 				=> $this->request->getVar('email'),
                        'mobile' 				=> $this->request->getVar('mobile'),
						'position' 				=> $this->request->getVar('position'),
						'org_name' 				=> $this->request->getVar('org_name'),
                        'address' 				=> $this->request->getVar('address'),
                        'status'		        => $this->request->getVar('status'),
						'role_id'		        => $this->request->getVar('role_id'),
					];
					 
					if($this->userModel->update($id, $userdata))
					{
					    session()->setTempdata('success', 'User account updated successfully', 3);
						return redirect()->to('administrator/users');
						
					}else{
						session()->setTempdata('error', 'Sorry! Unable to update account. Try again', 3);
						return redirect()->to('administrator/users');
					}
				}else{
					$this->data['validation'] = $this->validator;
				}
		}
        return view('Modules\Admin\Views\users\add_user', $this->data);
        
    }
    public function delUser($id = null)
    {
        $this->userModel->where('user_id', $id)->delete($id);
        if($this->request->isAJAX())
        {
          $response = [
            'error' => true,
            'msg' =>'User deleted successfully',	   
          ];
          return $this->response->setJSON($response);
        }else{
          session()->setFlashdata('success', 'User deleted successfully', 3);
    			return redirect()->to('administrator/users');
        }
    }

	public function changeUserPwd($id = null)
    {
		// display header information
	    $this->data['title'] = "Change Password";
        $this->data['bcrumb'] = "Change User Password";
		
		$this->data['user'] = $this->userModel->mojaUser($id);
        
		return view('Modules\Admin\Views\users\change_userpwd', $this->data);
    }
    public function changePwd()
	{
		// display header information
	    $this->data['title'] = "Change Password";
        $this->data['bcrumb'] = "Change User Password";
		if($this->request->getMethod() == "post")
        {
			$id = $this->request->getVar('user_id');
			$this->data['user'] = $this->userModel->mojaUser($id);
			$code = $this->request->getVar('user_id');
            $rules = [
                'password'		 	 	 => ['label' => 'Password', 'rules' => 'required|min_length[8]|max_length[20]|alpha_numeric_punct'],
		        'cpass'				 	 => ['label' => 'Confirm Password', 'rules' => 'required|matches[password]'],
            ];

            if ($this->validate($rules))
            {

                $pwdData = [
                    'password' => password_hash($this->request->getVar('password'), PASSWORD_DEFAULT),
                ];
                $results = $this->userModel->update($id, $pwdData);

                if($results)
                {
					session()->setTempdata('success', 'User password updated successfully', 3);
					return redirect()->to('administrator/users');

				}else{
					session()->setTempdata('error', 'Sorry! Unable to change password. Try again', 3);
					return redirect()->to('administrator/change/password/'.$id);
				}
            }else{
				$this->data['validation'] = $this->validator;
			}
        }
		return view('Modules\Admin\Views\users\change_userpwd', $this->data);
	}

    public function view_hit_count()
    {
        // display header information
        $this->data['title'] = "Website Traffic Statistics";
        $this->data['bcrumb'] = "Traffic Statistics";

        // Get detailed traffic data
        $this->data['traffic_data'] = $this->webtrafficModel->getAll();
        $this->data['total_hits'] = $this->webtrafficModel->getTotalHits();

        return view('Modules\Admin\Views\dashboard\traffic_stats', $this->data);
    }
}
