<?php

namespace Modules\Admin\Config;

use Config;
// Create a new instance of our RouteCollection class.
$routes = Config\Services::routes();

// Load the system's routing file first, so that the app and ENVIRONMENT
// can override as needed.
if (is_file(SYSTEMPATH . 'Config/Routes.php')) {
    require SYSTEMPATH . 'Config/Routes.php';
}


//setting up Inventory routes.
$routes->group('administrator', ['filter' => ['isLoggedIn' , 'checkPermission'], 'namespace' => 'Modules\Admin\Controllers'],   static function($routes){
 

    $routes->GET('/', 'Dashboard::index');
    $routes->GET('my-profile', 'Dashboard::userProfile');
    $routes->POST('my-profile/update', 'Dashboard::updateUserProfile');
    $routes->POST('password/update', 'Dashboard::updateUserPwd');


    $routes->GET('users', 'AdminUsers::index');
    $routes->GET('users/list', 'AdminUsers::usersList');
    $routes->GET('users/add', 'AdminUsers::addUser');
    $routes->POST('users/add', 'AdminUsers::addUser');
    $routes->GET('users/edit/(:any)', 'AdminUsers::editUser/$1');
    $routes->POST('users/update', 'AdminUsers::updateUser');
    $routes->GET('users/delete/(:any)', 'AdminUsers::deleteUser/$1');
    $routes->POST('users/change/password', 'AdminUsers::changePwd');
    $routes->POST('users/change/group', 'AdminUsers::changeGroup');

});

//Administrator settings not affected by permissions
$routes->group('administrator', ['filter' => 'isLoggedIn', 'namespace' => 'Modules\Admin\Controllers'],   static function($routes){
 

    $routes->GET('notifications', 'Notifications::index');
    $routes->GET('notifications/list', 'Notifications::getNotificationsList');
    $routes->POST('notifications/status/(:num)', 'Notifications::status/$1');

    $routes->GET('hits', 'Dashboard::view_hit_count');
});

