<?php

namespace App\Models;

use CodeIgniter\Model;

class UserAuthTokenModel extends Model
{
    protected $table = 'usc_user_auth_tokens';
    protected $primaryKey = 'id';

    protected $allowedFields = ['hashed_token', 'user_id', 'ip_address', 'expires', 'updated_at'];

    protected $useTimestamps = false;
    protected $createdField = 'created_at';
    protected $updatedField = 'updated_at';
    protected $deletedField = 'deleted_at';

    //Verify User Token - reset password
    public function verifyToken($token)
    {
        $builder = $this->db->table('user_auth_tokens');
        $builder->where('hashed_token', $token);
        return $result = $builder->get()->getRow();
    }

    //Update user Token
    public function updateOnToken($id)
	{
        $t = date('Y-m-d H:i:s');
		$builder = $this->db->table('users as u');
		$builder->where('id', $id);
		$builder->update(['updated_at'=> $t]);
		$result = $builder->get()->getRow();
		return $result;
	}
}